/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.matchers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.matchers.ComponentClassMatcher;
import com.mathworks.page.utils.VertFlowLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LayoutPanelMatcher
extends ComponentClassMatcher {
    public LayoutPanelMatcher(Class<? extends Handler> handlerClass) {
        super(JPanel.class, handlerClass);
    }

    @Override
    public boolean matches(Object component) {
        if (super.matches(component)) {
            JPanel panel = (JPanel)component;
            LayoutManager layout = panel.getLayout();
            if (panel.getBorder() != null && panel.getBorder() instanceof TitledBorder) {
                return false;
            }
            if (layout != null && layout instanceof BoxLayout) {
                boolean vertical;
                BoxLayout box = (BoxLayout)layout;
                boolean bl = vertical = box.getAxis() == 3 || box.getAxis() == 1;
                if (vertical) {
                    for (Component child : panel.getComponents()) {
                        if (!(Math.abs((double)child.getAlignmentX() - 0.5) > 0.001)) continue;
                        return false;
                    }
                    return true;
                }
            } else {
                if (layout != null && layout instanceof GridLayout) {
                    GridLayout grid = (GridLayout)layout;
                    return grid.getColumns() == 1 && grid.getRows() > 1 && grid.getHgap() == 0 && grid.getVgap() == 0;
                }
                if (layout != null && layout instanceof VertFlowLayout) {
                    Container parentContainer;
                    Component[] siblings;
                    return panel.getParent() == null || !(panel.getParent() instanceof Container) || (siblings = (parentContainer = panel.getParent()).getComponents()).length <= 1;
                }
            }
        }
        return false;
    }
}

