/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClient;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamHandler;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamServer;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamServerImpl;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse.MouseStream;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.mouse.MouseStreamHandler;
import com.mathworks.matlabserver.jcp.utils.KeyboardUtils;
import com.mathworks.matlabserver.jcp.utils.MouseUtils;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class AbstractPixelHandler
extends AbstractComponentHandler
implements ImageStreamHandler,
MouseStreamHandler {
    private static final Logger logger = Logger.getLogger(AbstractPixelHandler.class.getSimpleName());
    private BufferedImage backBuffer;
    private BufferedImage middleBuffer;
    private BufferedImage frontBuffer;
    private Observer peerEventObserver;
    private ImageStreamServer imageStream;
    private MouseStream mouseStream;

    protected abstract BufferedImage getComponentImage(BufferedImage var1);

    protected abstract void addRepaintListener();

    protected abstract void removeRepaintListener();

    @Override
    public String getType() {
        return "StreamCanvas";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.imageStream = new ImageStreamServerImpl("/jcp/imageStream/" + UUID.randomUUID(), this);
        this.imageStream.start();
        this.mouseStream = new MouseStream("/jcp/mouseStream" + UUID.randomUUID());
        this.mouseStream.start();
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    public void destroy() {
        this.imageStream.stop();
        this.mouseStream.stop();
        super.destroy();
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> properties = super.doGetProperties(component);
        properties.put("imageStream", this.imageStream);
        properties.put("mouseStream", this.mouseStream);
        return properties;
    }

    protected void imageUpdated() {
        this.imageStream.markDirty();
    }

    @Override
    public synchronized BufferedImage getImage() {
        BufferedImage newImage = this.getComponentImage(this.backBuffer);
        if (newImage != null) {
            this.backBuffer = this.middleBuffer;
            this.middleBuffer = this.frontBuffer;
            this.frontBuffer = newImage;
        }
        return this.frontBuffer;
    }

    @Override
    public void clientStateChange(ImageStreamClient.State state) {
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.addRepaintListener();
        this.mouseStream.setMouseStreamListener(this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.removeRepaintListener();
        this.mouseStream.setMouseStreamListener(null);
    }

    @Override
    public void mouseScrolled(final int x, final int y, final int zoom) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.scrolled(AbstractPixelHandler.this.getEventTarget(x, y), x, y, zoom);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mousePressed(final int x, final int y, final int modifiers, final int buttons, final int clickCount) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.pressed(AbstractPixelHandler.this.getEventTarget(x, y), x, y, AbstractPixelHandler.this.convertModifiers(modifiers), AbstractPixelHandler.this.convertButtons(buttons), clickCount);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseReleased(final int x, final int y, final int modifiers, final int buttons, final int clickCount) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.released(AbstractPixelHandler.this.getEventTarget(x, y), x, y, AbstractPixelHandler.this.convertModifiers(modifiers), AbstractPixelHandler.this.convertButtons(buttons), clickCount);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(final int x, final int y, final int modifiers, final int buttons, final int clickCount) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.clicked(AbstractPixelHandler.this.getEventTarget(x, y), x, y, AbstractPixelHandler.this.convertModifiers(modifiers), AbstractPixelHandler.this.convertButtons(buttons), clickCount);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseMoved(final int x, final int y, final int modifiers) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.moved(AbstractPixelHandler.this.getEventTarget(x, y), x, y, AbstractPixelHandler.this.convertModifiers(modifiers));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseDragged(final int x, final int y, final int modifiers, final int buttons) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MouseUtils.dragged(AbstractPixelHandler.this.getEventTarget(x, y), x, y, AbstractPixelHandler.this.convertModifiers(modifiers), AbstractPixelHandler.this.convertButtons(buttons));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Component getEventTarget(int x, int y) {
        Component target = SwingUtilities.getDeepestComponentAt(this.component, x, y);
        return target != null ? target : this.component;
    }

    @Override
    public Map<String, Object> getCursor() {
        final Map[] result = new Map[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    result[0] = MouseUtils.getCursor(AbstractPixelHandler.this.component);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result[0];
    }

    private int convertModifiers(int modifiers) {
        int newModifiers = 0;
        if ((modifiers & 1) > 0) {
            newModifiers += 65;
        }
        if ((modifiers & 2) > 0) {
            newModifiers += 130;
        }
        if ((modifiers & 4) > 0) {
            newModifiers += 520;
        }
        if ((modifiers & 8) > 0) {
            newModifiers += 260;
        }
        return newModifiers;
    }

    private int convertButtons(int buttons) {
        int newButtons = 0;
        if ((buttons & 1) > 0) {
            newButtons += 1040;
        }
        if ((buttons & 2) > 0) {
            newButtons += 2056;
        }
        if ((buttons & 4) > 0) {
            newButtons += 4100;
        }
        return newButtons;
    }

    @Override
    public void addPeerNodeListeners() {
        this.peerEventObserver = new Observer(){

            public void handle(final Event event) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyboardUtils.handleKeyEvent(AbstractPixelHandler.this.component, event.getData());
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error while dispatching canvas mouse event: ", e);
                }
            }
        };
        this.peerNode.addEventListener("peerEvent", this.peerEventObserver);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.peerEventObserver);
    }
}

