/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Map;

public class KeyboardUtils {
    public static void keyUp(Component component, int keyCode, char keyChar, int modifiers) {
        KeyboardUtils.dispatchEvent(component, 402, modifiers, keyCode, keyChar);
    }

    public static void keyDown(Component component, int keyCode, char keyChar, int modifiers) {
        KeyboardUtils.dispatchEvent(component, 401, modifiers, keyCode, keyChar);
    }

    public static void handleKeyEvent(Component component, Map<String, Object> data) {
        if (data.containsKey("keyCode") && data.containsKey("keyChar")) {
            int modifiers = 0;
            if (data.get("altKey") != null && data.get("altKey").equals(true)) {
                modifiers |= 0x208;
            }
            if (data.get("ctrlKey") != null && data.get("ctrlKey").equals(true)) {
                modifiers |= 0x82;
            }
            if (data.get("shiftKey") != null && data.get("shiftKey").equals(true)) {
                modifiers |= 0x41;
            }
            if (data.get("metaKey") != null && data.get("metaKey").equals(true)) {
                modifiers |= 0x104;
            }
            int keyCode = ((Double)data.get("keyCode")).intValue();
            char keyChar = ((String)data.get("keyChar")).charAt(0);
            if (data.get("type").equals("keyDown")) {
                KeyboardUtils.keyDown(component, keyCode, keyChar, modifiers);
            } else if (data.get("type").equals("keyUp")) {
                KeyboardUtils.keyUp(component, keyCode, keyChar, modifiers);
            }
        }
    }

    private static void dispatchEvent(Component component, int type, int modifiers, int keyCode, char keyChar) {
        component.dispatchEvent(new KeyEvent(component, type, new Date().getTime(), modifiers, KeyboardUtils.convertKeyCode(keyCode), KeyboardUtils.convertKeyChar(keyCode, keyChar), KeyboardUtils.getKeyLocation(keyCode)));
    }

    private static int convertKeyCode(int keyCode) {
        switch (keyCode) {
            default: 
        }
        return keyCode;
    }

    private static char convertKeyChar(int keyCode, char keyChar) {
        switch (keyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 127: 
            case 157: {
                return '\uffff';
            }
        }
        return keyChar;
    }

    private static int getKeyLocation(int keyCode) {
        switch (keyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return 2;
            }
        }
        return 1;
    }
}

