/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.parallel.hadoop.MatlabConfiguration;
import com.mathworks.toolbox.parallel.hadoop.MatlabInputFormat;
import com.mathworks.toolbox.parallel.hadoop.MatlabMapper;
import com.mathworks.toolbox.parallel.hadoop.MatlabOutputFormat;
import com.mathworks.toolbox.parallel.hadoop.MatlabReducer;
import com.mathworks.toolbox.parallel.hadoop.TaskUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class JobLaunchTool
extends Configured
implements Tool {
    private final ExecutorService fExecutorService = Executors.newSingleThreadExecutor();
    private static final int POLL_INTERVAL_IN_MILLISECONDS = 1000;
    private final Writer fOutputStatusWriter;

    public JobLaunchTool(Writer writer) {
        this.fOutputStatusWriter = writer;
    }

    public int run(String[] args) throws Exception {
        this.ensureLibraryPathContainsLocalMatlab();
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(JobLaunchTool.class);
        job.getConfiguration().setInt("mapred.job.reuse.jvm.num.tasks", -1);
        job.getConfiguration().setInt("mapreduce.job.jvm.numtasks", -1);
        job.setMapperClass(MatlabMapper.class);
        job.setReducerClass(MatlabReducer.class);
        job.setInputFormatClass(MatlabInputFormat.class);
        job.setOutputFormatClass(MatlabOutputFormat.class);
        job.setMapOutputKeyClass(BytesWritable.class);
        job.setMapOutputValueClass(BytesWritable.class);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(Void.class);
        for (int ii = 0; ii < args.length - 1; ++ii) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(new URI(args[ii])));
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(new URI(args[args.length - 1])));
        ProcessManipulation processManipulation = new ProcessManipulation();
        Future<Void> completionFuture = this.submitJob(job);
        this.addJobCancelShutdownHook();
        int parentMatlabPid = new MatlabConfiguration(this.getConf()).getParentMatlabPid();
        while (processManipulation.isPIDAlive(parentMatlabPid)) {
            try {
                completionFuture.get(1000L, TimeUnit.MILLISECONDS);
                break;
            }
            catch (TimeoutException e) {
            }
            catch (ExecutionException e) {
                return 1;
            }
        }
        if (!job.isComplete()) {
            this.cancelJob();
        }
        return job.isSuccessful() ? 0 : 1;
    }

    private Future<Void> submitJob(final Job job) {
        Future<Void> completionFuture = this.fExecutorService.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    try {
                        job.submit();
                        job.waitForCompletion(true);
                    }
                    catch (Throwable throwable) {
                        String jobIDString = job.getJobID() != null ? "" + job.getJobID().getId() : "";
                        JobLaunchTool.this.fOutputStatusWriter.write("JobId:" + jobIDString + "\n");
                        throw throwable;
                    }
                    String jobIDString = job.getJobID() != null ? "" + job.getJobID().getId() : "";
                    JobLaunchTool.this.fOutputStatusWriter.write("JobId:" + jobIDString + "\n");
                }
                catch (InterruptedException e) {
                    if (!job.isComplete()) {
                        job.killJob();
                    }
                    throw e;
                }
                catch (Exception e) {
                    JobLaunchTool.this.fOutputStatusWriter.write(e.getMessage());
                    throw e;
                }
                return null;
            }
        });
        this.fExecutorService.shutdown();
        return completionFuture;
    }

    private void cancelJob() throws InterruptedException {
        this.fExecutorService.shutdownNow();
        while (!this.fExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
    }

    private void addJobCancelShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!JobLaunchTool.this.fExecutorService.isTerminated()) {
                    try {
                        JobLaunchTool.this.cancelJob();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void ensureLibraryPathContainsLocalMatlab() {
        MatlabConfiguration matlabConf = new MatlabConfiguration(this.getConf());
        if (!matlabConf.getHadoopVersion().equals("1") && !TaskUtils.isWindowsPlatform()) {
            return;
        }
        String libraryPath = System.getProperty("java.library.path");
        libraryPath = libraryPath != null && !libraryPath.isEmpty() ? libraryPath + File.pathSeparator + matlabConf.getParentMatlabBinFolder() : matlabConf.getParentMatlabBinFolder();
        try {
            System.setProperty("java.library.path", libraryPath);
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(System.class.getClassLoader(), null);
            fieldSysPath.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (!TaskUtils.isMdceDebug()) {
            JobLaunchTool.disableConfigurationDeprecationMessages();
        }
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        File optionsFile = new File(args[0]);
        ArrayList<String> optionsList = new ArrayList<String>();
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(new FileInputStream(optionsFile)));){
            String option = inputReader.readLine();
            while (option != null) {
                optionsList.add(option);
                option = inputReader.readLine();
            }
        }
        String[] options = optionsList.toArray(new String[optionsList.size()]);
        File finalStatusFile = new File(args[1]);
        int res = 1;
        try (FileWriter outputWriter = new FileWriter(finalStatusFile);){
            res = ToolRunner.run((Tool)new JobLaunchTool(outputWriter), (String[])options);
        }
        System.exit(res);
    }

    private static void disableConfigurationDeprecationMessages() {
        try {
            Log configurationLogger = LogFactory.getLog(Configuration.class);
            if (configurationLogger instanceof Log4JLogger) {
                Log4JLogger configurationLog4jLogger = (Log4JLogger)configurationLogger;
                configurationLog4jLogger.getLogger().setLevel(Level.ERROR);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

