/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.page.plottool.ErrorHandlerResources;
import com.mathworks.util.Log;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class ErrorHandler {
    private static boolean fDoPrintError = false;

    public static void setPrintErrors(boolean bl) {
        fDoPrintError = bl;
    }

    public static boolean getPrintErrors() {
        return fDoPrintError;
    }

    public static void showSimpleError(String string, Component component) {
        MJOptionPane.showMessageDialog((Component)component, (Object)string, (String)ErrorHandlerResources.getBundle().getString("dialog.title"), (int)0);
    }

    public static void showMatlabError(final String string, MatlabEvent matlabEvent, Matlab matlab) {
        if (fDoPrintError) {
            System.out.println("ERROR in page.plottool.ErrorHandler: " + string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Log.printLn((String)string);
                }
            });
        }
    }

    public static void showMatlabError(String string, Matlab matlab) {
        ErrorHandler.showMatlabError(string, null);
    }

    public static void showMatlabError(final String string) {
        if (fDoPrintError) {
            System.out.println("ERROR in page.plottool.ErrorHandler: " + string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Log.printLn((String)string);
                }
            });
        }
    }

    public static void showJavaException(String string, final Exception exception) {
        if (fDoPrintError) {
            exception.printStackTrace();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Log.logException((Exception)exception);
                }
            });
        }
    }
}

