/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.panels;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.graphics.PlotCommandDescriptor;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.graphics.PlotSignature;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.propertyeditor.BeanManager;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.BooleanControl;
import com.mathworks.page.plottool.propertyeditor.controls.CategoricalVariableComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.ComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.MixedComboControl;
import com.mathworks.page.plottool.propertyeditor.controls.TextControl;
import com.mathworks.page.plottool.propertyeditor.panels.AbstractSeriesPropPanel;
import com.mathworks.page.plottool.propertyeditor.panels.PropertyPanel;
import com.mathworks.util.QueueEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class ContourGroupPropPanel
extends AbstractSeriesPropPanel {
    private TextControl fLevelStepTextControl;
    private List<LevelStepModeChangeListener> fLevelStepModeChangeListeners = new ArrayList<LevelStepModeChangeListener>();

    @Override
    protected PlotSignature getPlotSignature() {
        return PlotMetadata.getPlotSignature((String)PlotCommandDescriptor.CONTOUR);
    }

    @Override
    protected String getPlotType() {
        return "Contour";
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        for (LevelStepModeChangeListener levelStepModeChangeListener : this.fLevelStepModeChangeListeners) {
            levelStepModeChangeListener.remove();
        }
        this.fLevelStepModeChangeListeners.clear();
        if (PropertyEditor.isHGUsingMATLABClasses() && object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                LevelStepModeChangeListener levelStepModeChangeListener = new LevelStepModeChangeListener(object2, this.fLevelStepTextControl);
                levelStepModeChangeListener.add();
                this.fLevelStepModeChangeListeners.add(levelStepModeChangeListener);
            }
        }
    }

    @Override
    protected void createAndLayoutAppearanceControls(MJPanel mJPanel) {
        ComboControl comboControl;
        this.fLevelStepTextControl = new PositiveScalarTextControl("LevelStep", this, this.getGroupName());
        BooleanControl booleanControl = new BooleanControl("LevelStepMode", this, PropertyEditorResources.getBundle().getString("label.auto"), this.getGroupName());
        if (PropertyEditor.isHGUsingMATLABClasses()) {
            booleanControl.setTrueValue(0);
            booleanControl.setFalseValue(1);
        } else {
            booleanControl.setTrueValue(1);
            booleanControl.setFalseValue(0);
        }
        MixedComboControl mixedComboControl = new MixedComboControl("TextStep", this, this.getGroupName());
        mixedComboControl.setModePropertyName("TextStepMode");
        BooleanControl booleanControl2 = new BooleanControl("Fill", this, PropertyEditorResources.getBundle().getString("label.fill"), this.getGroupName());
        BooleanControl booleanControl3 = new BooleanControl("ShowText", this, PropertyEditorResources.getBundle().getString("label.showtext"), this.getGroupName());
        if (PropertyEditor.isHGUsingMATLABClasses()) {
            comboControl = new CategoricalVariableComboControl("LineStyle", this, this.getGroupName());
            ((CategoricalVariableComboControl)comboControl).setPrototypeDisplayValue("no line");
        } else {
            comboControl = new PropertyPanel.LineStyleControl("LineStyle", this, this.getGroupName());
        }
        PropertyPanel.SizeControl sizeControl = new PropertyPanel.SizeControl("LineWidth", this, this.getGroupName());
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)this.fLevelStepTextControl));
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)mixedComboControl));
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)booleanControl2));
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)booleanControl3));
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)comboControl));
        ContourGroupPropPanel.protectSizeFromGridBag((JComponent)((Object)sizeControl));
        GridBagConstraints gridBagConstraints = PropertyPanel.createLabelGBC();
        GridBagConstraints gridBagConstraints2 = PropertyPanel.createControlGBC();
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        mJPanel.add((Component)new MJLabel(PropertyEditorResources.getBundle().getString("label.levelstep")), (Object)gridBagConstraints);
        gridBagConstraints2.gridx = 1;
        mJPanel.add((Component)((Object)this.fLevelStepTextControl), (Object)gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 2;
        mJPanel.add((Component)((Object)booleanControl), (Object)gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        mJPanel.add((Component)((Object)booleanControl3), (Object)gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        mJPanel.add((Component)new MJLabel(PropertyEditorResources.getBundle().getString("label.lines")), (Object)gridBagConstraints);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        mJPanel.add((Component)((Object)comboControl), (Object)gridBagConstraints2);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridx = 2;
        mJPanel.add((Component)((Object)sizeControl), (Object)gridBagConstraints2);
        gridBagConstraints2.gridx = 3;
        mJPanel.add((Component)((Object)booleanControl2), (Object)gridBagConstraints2);
    }

    public static class PositiveScalarTextControl
    extends TextControl {
        public PositiveScalarTextControl(String string, CellEditorListener cellEditorListener, String string2) {
            super(string, cellEditorListener, string2);
        }

        @Override
        public Object getDisplayedValue() {
            double d;
            String string = this.fText.getText();
            if (string.isEmpty()) {
                this.errorAndCleanup(string, "PropertyControl.error.empty");
                return null;
            }
            if (string.equalsIgnoreCase("nan")) {
                this.errorAndCleanup(string, "PropertyControl.error.parse");
                return null;
            }
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorAndCleanup(string, "PropertyControl.error.parse");
                return null;
            }
            if (d <= 0.0) {
                this.errorAndCleanup(string, "PropertyControl.error.negative");
                return null;
            }
            return d;
        }

        protected void errorAndCleanup(String string, String string2) {
            if (Matlab.isMatlabAvailable()) {
                ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString(string2), string), this.getTopLevelAncestor());
            }
            this.fText.setText(this.fPrevText);
            this.fText.requestFocus();
        }
    }

    public static class LevelStepModeChangeListener
    extends MatlabWorker<Object>
    implements PropertyChangeListener {
        private Object iBean = null;
        private TextControl iLevelTextControl;

        public LevelStepModeChangeListener(Object object, TextControl textControl) {
            this.iBean = object;
            this.iLevelTextControl = textControl;
        }

        public Object runOnMatlabThread() {
            return BeanManager.getPropertyValue(this.iBean, BeanManager.getProperty(this.iBean, "LevelStep"));
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (this.iLevelTextControl != null) {
                this.iLevelTextControl.setValue(object);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue())) {
                return;
            }
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    LevelStepModeChangeListener.this.start();
                }
            });
        }

        public void add() {
            if (this.iBean instanceof UDDObject) {
                ((UDDObject)this.iBean).addObjectPropertyChangeListener("LevelStepMode", (PropertyChangeListener)this);
            }
        }

        public void remove() {
            if (this.iBean instanceof UDDObject) {
                ((UDDObject)this.iBean).removeObjectPropertyChangeListener("LevelStepMode", (PropertyChangeListener)this);
            }
        }
    }
}

