/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupUnmarshalException
extends Exception {
    private static final long serialVersionUID = 2956893184719950537L;
    private ServiceRegistrar[] registrars = null;
    private MarshalledObject[] marshalledRegistrars = null;
    private Throwable[] exceptions = null;

    public LookupUnmarshalException(ServiceRegistrar[] serviceRegistrarArray, MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray) {
        this.init(serviceRegistrarArray, marshalledObjectArray, throwableArray);
    }

    public LookupUnmarshalException(ServiceRegistrar[] serviceRegistrarArray, MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray, String string) {
        super(string);
        this.init(serviceRegistrarArray, marshalledObjectArray, throwableArray);
    }

    public ServiceRegistrar[] getRegistrars() {
        return this.registrars;
    }

    public MarshalledObject[] getMarshalledRegistrars() {
        return this.marshalledRegistrars;
    }

    public Throwable[] getExceptions() {
        return this.exceptions;
    }

    private void init(ServiceRegistrar[] serviceRegistrarArray, MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray) {
        if (marshalledObjectArray == null) {
            throw new NullPointerException("marshalledRegistrars cannot be null");
        }
        if (throwableArray == null) {
            throw new NullPointerException("exceptions cannot be null");
        }
        if (marshalledObjectArray.length == 0) {
            throw new IllegalArgumentException("marshalledRegistrars has 0 length");
        }
        if (throwableArray.length != marshalledObjectArray.length) {
            throw new IllegalArgumentException("exceptions.length (" + throwableArray.length + ") is not equal to marshalledRegistrars.length " + "(" + marshalledObjectArray.length + ")");
        }
        this.registrars = serviceRegistrarArray;
        this.marshalledRegistrars = marshalledObjectArray;
        this.exceptions = throwableArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.marshalledRegistrars == null) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - marshalledRegistrars field is null");
        }
        if (this.exceptions == null) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - exceptions field is null");
        }
        if (this.marshalledRegistrars.length == 0) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - marshalledRegistrars.length == 0");
        }
        if (this.exceptions.length != this.marshalledRegistrars.length) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - exceptions.length (" + this.exceptions.length + ") is not equal to marshalledRegistrars.length " + "(" + this.marshalledRegistrars.length + ")");
        }
    }
}

