/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import [Ljava.lang.String;;
import [Lnet.jini.core.discovery.LookupLocator;;
import com.sun.jini.config.Config;
import com.sun.jini.example.browser.MetalIcons;
import com.sun.jini.example.browser.ServiceBrowser;
import com.sun.jini.example.browser.ServiceEditor;
import com.sun.jini.example.browser.SpaceBrowser;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.JavaSpaceAdmin;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.entry.ServiceControlled;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.space.JavaSpace;

public class Browser
extends JFrame {
    static final String BROWSER = "com.sun.jini.example.browser";
    static final Logger logger = Logger.getLogger("com.sun.jini.example.browser");
    private transient SecurityContext ctx;
    private transient ClassLoader ccl;
    transient Configuration config;
    private transient DiscoveryGroupManagement disco;
    private transient ServiceRegistrar lookup = null;
    private transient long eventID = 0L;
    private transient long seqNo = Long.MAX_VALUE;
    private transient ActionListener exiter;
    private transient ServiceTemplate tmpl;
    private transient Listener listen;
    private transient LookupListener adder;
    private transient Lease elease = null;
    transient ProxyPreparer leasePreparer;
    transient ProxyPreparer servicePreparer;
    transient ProxyPreparer adminPreparer;
    private transient MethodConstraints locatorConstraints;
    transient LeaseRenewalManager leaseMgr;
    private transient LeaseListener lnotify;
    private transient List ignoreInterfaces;
    private transient JTextArea text;
    private transient JMenu registrars;
    private transient JCheckBoxMenuItem esuper;
    private transient JCheckBoxMenuItem ssuper;
    private transient JCheckBoxMenuItem sclass;
    private transient boolean isAdmin;
    private transient JList list;
    private transient DefaultListModel listModel;
    private transient DefaultListModel dummyModel = new DefaultListModel();
    private transient JScrollPane listScrollPane;
    private static Icon[] icons = new Icon[3];
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$jini$core$entry$Entry;
    static /* synthetic */ Class class$net$jini$export$Exporter;

    public Browser(ActionListener actionListener, Configuration configuration) throws ConfigurationException, IOException {
        JComponent jComponent;
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        if (actionListener == null) {
            actionListener = this.wrap(new Exit());
        }
        this.exiter = actionListener;
        if (configuration == null) {
            configuration = EmptyConfiguration.INSTANCE;
        }
        this.config = configuration;
        this.ctx = Security.getContext();
        this.ccl = Thread.currentThread().getContextClassLoader();
        this.leaseMgr = (LeaseRenewalManager)Config.getNonNullEntry(configuration, BROWSER, "leaseManager", LeaseRenewalManager.class, new LeaseRenewalManager(configuration));
        this.isAdmin = (Boolean)configuration.getEntry(BROWSER, "folderView", Boolean.TYPE, Boolean.TRUE);
        this.leasePreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, BROWSER, "leasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.servicePreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, BROWSER, "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.adminPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, BROWSER, "adminPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.locatorConstraints = (MethodConstraints)configuration.getEntry(BROWSER, "locatorConstraints", MethodConstraints.class, null);
        this.ignoreInterfaces = Arrays.asList((String[])Config.getNonNullEntry(configuration, BROWSER, "uninterestingInterfaces", String;.class, new String[]{"java.io.Serializable", "java.rmi.Remote", "net.jini.admin.Administrable", "net.jini.core.constraint.RemoteMethodControl", "net.jini.id.ReferentUuid"}));
        this.listen = new Listener();
        try {
            object2 = (DiscoveryManagement)Config.getNonNullEntry(configuration, BROWSER, "discoveryManager", DiscoveryManagement.class);
            if (!(object2 instanceof DiscoveryGroupManagement)) {
                throw new ConfigurationException("discoveryManager does not  support DiscoveryGroupManagement");
            }
            if (!(object2 instanceof DiscoveryLocatorManagement)) {
                throw new ConfigurationException("discoveryManager does not  support DiscoveryLocatorManagement");
            }
            this.disco = (DiscoveryGroupManagement)object2;
            object = this.disco.getGroups();
            if (object == null || ((String[])object).length > 0) {
                throw new ConfigurationException("discoveryManager cannot have initial groups");
            }
            if (((DiscoveryLocatorManagement)object2).getLocators().length > 0) {
                throw new ConfigurationException("discoveryManager cannot have initial locators");
            }
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.disco = new LookupDiscoveryManager(new String[0], new LookupLocator[0], null, configuration);
        }
        this.disco.setGroups((String[])configuration.getEntry(BROWSER, "initialLookupGroups", String;.class, null));
        ((DiscoveryLocatorManagement)((Object)this.disco)).setLocators((LookupLocator[])Config.getNonNullEntry(configuration, BROWSER, "initialLookupLocators", LookupLocator;.class, new LookupLocator[0]));
        this.tmpl = new ServiceTemplate(null, new Class[0], new Entry[0]);
        this.setTitle("Lookup");
        object2 = new JMenuBar();
        object = new JMenu("File");
        JMenuItem jMenuItem2 = new JMenuItem("Find All");
        jMenuItem2.addActionListener(this.wrap(new AllFind()));
        ((JMenu)object).add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Find Public");
        jMenuItem3.addActionListener(this.wrap(new PubFind()));
        ((JMenu)object).add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Find By Group...");
        jMenuItem4.addActionListener(this.wrap(new MultiFind()));
        ((JMenu)object).add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Find By Address...");
        jMenuItem5.addActionListener(this.wrap(new UniFind()));
        ((JMenu)object).add(jMenuItem5);
        if (!this.isAdmin) {
            jMenuItem = new JMenuItem("Show Matches");
            jMenuItem.addActionListener(this.wrap(new Show()));
            ((JMenu)object).add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Reset");
        jMenuItem.addActionListener(this.wrap(new Reset()));
        ((JMenu)object).add(jMenuItem);
        JMenuItem jMenuItem6 = new JMenuItem("Exit");
        jMenuItem6.addActionListener(actionListener);
        ((JMenu)object).add(jMenuItem6);
        ((JMenuBar)object2).add((JMenu)object);
        this.addWindowListener(this.wrap(new Exiter()));
        this.registrars = new JMenu("Registrar");
        Browser.addNone(this.registrars);
        ((JMenuBar)object2).add(this.registrars);
        JMenu jMenu = new JMenu("Options");
        this.esuper = new JCheckBoxMenuItem("Attribute supertypes", false);
        jMenu.add(this.esuper);
        this.ssuper = new JCheckBoxMenuItem("Service supertypes", false);
        jMenu.add(this.ssuper);
        this.sclass = new JCheckBoxMenuItem("Service classes", false);
        jMenu.add(this.sclass);
        ((JMenuBar)object2).add(jMenu);
        JMenu jMenu2 = new JMenu("Services");
        jMenu2.addMenuListener(this.wrap(new Services(jMenu2)));
        ((JMenuBar)object2).add(jMenu2);
        JMenu jMenu3 = new JMenu("Attributes");
        jMenu3.addMenuListener(this.wrap(new Entries(jMenu3)));
        ((JMenuBar)object2).add(jMenu3);
        this.setJMenuBar((JMenuBar)object2);
        this.getContentPane().setLayout(new BorderLayout());
        int n = 8;
        if (this.isAdmin) {
            n = 4;
            jComponent = new JPanel();
            jComponent.setLayout(new BorderLayout());
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Matching Services");
            titledBorder.setTitlePosition(2);
            titledBorder.setTitleJustification(1);
            jComponent.setBorder(titledBorder);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.setFixedCellHeight(20);
            this.list.setCellRenderer((ListCellRenderer)this.wrap(new ServiceItemRenderer(), ListCellRenderer.class));
            this.list.addMouseListener(this.wrap(new MouseReceiver(new ServiceListPopup())));
            this.listScrollPane = new JScrollPane(this.list);
            jComponent.add((Component)this.listScrollPane, "Center");
            this.getContentPane().add((Component)jComponent, "South");
        }
        this.text = new JTextArea(this.genText(false), n, 40);
        jComponent = new JScrollPane(this.text);
        this.getContentPane().add((Component)jComponent, "Center");
        this.validate();
        this.pack();
        this.show();
        this.adder = new LookupListener();
        this.lnotify = new LeaseNotify();
        ((DiscoveryManagement)((Object)this.disco)).addDiscoveryListener(this.adder);
    }

    private static String typeName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void setText(boolean bl) {
        this.text.setText(this.genText(bl));
    }

    private String genText(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tmpl.serviceTypes.length > 0) {
            for (int i = 0; i < this.tmpl.serviceTypes.length; ++i) {
                stringBuffer.append(this.tmpl.serviceTypes[i].getName());
                stringBuffer.append("\n");
            }
        }
        if (this.tmpl.attributeSetTemplates.length > 0) {
            this.genEntries(stringBuffer, this.tmpl.attributeSetTemplates, false);
        }
        this.genMatches(stringBuffer, bl);
        return stringBuffer.toString();
    }

    private void genEntries(StringBuffer stringBuffer, Entry[] entryArray, boolean bl) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            if (entry == null) {
                stringBuffer.append("null\n");
                continue;
            }
            stringBuffer.append(Browser.typeName(entry.getClass()));
            stringBuffer.append(": ");
            try {
                Field[] fieldArray = entry.getClass().getFields();
                for (int j = 0; j < fieldArray.length; ++j) {
                    Object object;
                    if (!Browser.valid(fieldArray[j]) || (object = fieldArray[j].get(entry)) == null && !bl) continue;
                    stringBuffer.append(fieldArray[j].getName());
                    stringBuffer.append("=");
                    stringBuffer.append(object);
                    stringBuffer.append(" ");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.append("\n");
        }
    }

    private static boolean valid(Field field) {
        return (field.getModifiers() & 0x18) == 0;
    }

    private void genMatches(StringBuffer stringBuffer, boolean bl) {
        int n;
        ServiceMatches serviceMatches;
        if (this.isAdmin) {
            this.list.setModel(this.dummyModel);
            this.listModel.removeAllElements();
            this.list.clearSelection();
            this.list.ensureIndexIsVisible(0);
            this.list.repaint();
            this.list.revalidate();
            this.listScrollPane.validate();
        }
        if (this.lookup == null) {
            String[] stringArray = this.disco.getGroups();
            if (stringArray == null) {
                stringBuffer.append("Groups: <all>\n");
            } else if (stringArray.length > 0) {
                stringBuffer.append("Groups:");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string.length() == 0) {
                        string = "public";
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                }
                stringBuffer.append("\n");
            }
            LookupLocator[] lookupLocatorArray = ((DiscoveryLocatorManagement)((Object)this.disco)).getLocators();
            if (lookupLocatorArray.length > 0) {
                stringBuffer.append("Addresses:");
                for (int i = 0; i < lookupLocatorArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(lookupLocatorArray[i].getHost());
                    if (lookupLocatorArray[i].getPort() == 4160) continue;
                    stringBuffer.append(":");
                    stringBuffer.append(lookupLocatorArray[i].getPort());
                }
                stringBuffer.append("\n");
            }
            if (!(this.registrars.getMenuComponent(0) instanceof JRadioButtonMenuItem)) {
                stringBuffer.append("No registrars to select");
                return;
            }
            int n2 = this.registrars.getMenuComponentCount();
            if (n2 == 1) {
                stringBuffer.append("1 registrar, not selected");
            } else {
                stringBuffer.append(n2);
                stringBuffer.append(" registrars, none selected");
            }
            return;
        }
        try {
            serviceMatches = this.lookup.lookup(this.tmpl, bl || this.isAdmin ? 1000 : 0);
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "lookup failed", throwable);
            return;
        }
        if (serviceMatches.items != null) {
            for (n = 0; n < serviceMatches.items.length; ++n) {
                if (serviceMatches.items[n].service == null) continue;
                try {
                    serviceMatches.items[n].service = this.servicePreparer.prepareProxy(serviceMatches.items[n].service);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "proxy preparation failed", throwable);
                    serviceMatches.items[n].service = null;
                }
            }
        }
        if (this.isAdmin) {
            for (n = 0; n < serviceMatches.items.length; ++n) {
                this.listModel.addElement(new ServiceListItem(serviceMatches.items[n]));
            }
            this.list.setModel(this.listModel);
            this.list.clearSelection();
            this.list.ensureIndexIsVisible(0);
            this.list.repaint();
            this.list.revalidate();
            this.listScrollPane.validate();
        }
        if (!bl && this.tmpl.serviceTypes.length == 0 && this.tmpl.attributeSetTemplates.length == 0) {
            stringBuffer.append("Total services registered: ");
            stringBuffer.append(serviceMatches.totalMatches);
            return;
        }
        stringBuffer.append("\nMatching services: ");
        stringBuffer.append(serviceMatches.totalMatches);
        if (!this.isAdmin) {
            if (!bl) {
                return;
            }
            stringBuffer.append("\n\n");
            for (n = 0; n < serviceMatches.items.length; ++n) {
                ServiceItem serviceItem = serviceMatches.items[n];
                stringBuffer.append("Service ID: ");
                stringBuffer.append(serviceItem.serviceID);
                stringBuffer.append("\n");
                stringBuffer.append("Service instance: ");
                stringBuffer.append(serviceItem.service);
                stringBuffer.append("\n");
                this.genEntries(stringBuffer, serviceItem.attributeSets, true);
                stringBuffer.append("\n");
            }
        }
    }

    private static void addNone(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem("(none)");
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
    }

    private void addOne(ServiceRegistrar serviceRegistrar) {
        LookupLocator lookupLocator;
        try {
            lookupLocator = serviceRegistrar.getLocator();
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "obtaining locator failed", throwable);
            return;
        }
        String string = lookupLocator.getHost();
        if (lookupLocator.getPort() != 4160) {
            string = string + ":" + lookupLocator.getPort();
        }
        RegistrarMenuItem registrarMenuItem = new RegistrarMenuItem(string, serviceRegistrar.getServiceID());
        registrarMenuItem.addActionListener(this.wrap(new Lookup(serviceRegistrar)));
        if (!(this.registrars.getMenuComponent(0) instanceof JRadioButtonMenuItem)) {
            this.registrars.removeAll();
        }
        this.registrars.add(registrarMenuItem);
    }

    static Class[] getInterfaces(Class clazz) {
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            while (--n >= 0) {
                hashSet.add(classArray[n]);
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    ActionListener wrap(ActionListener actionListener) {
        return (ActionListener)this.wrap(actionListener, ActionListener.class);
    }

    MenuListener wrap(MenuListener menuListener) {
        return (MenuListener)this.wrap(menuListener, MenuListener.class);
    }

    MouseListener wrap(MouseListener mouseListener) {
        return (MouseListener)this.wrap(mouseListener, MouseListener.class);
    }

    WindowListener wrap(WindowListener windowListener) {
        return (WindowListener)this.wrap(windowListener, WindowListener.class);
    }

    Runnable wrap(Runnable runnable) {
        return (Runnable)this.wrap(runnable, Runnable.class);
    }

    private Object wrap(Object object, Class clazz) {
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new Handler(object));
    }

    private void resetTmpl() {
        this.tmpl.serviceTypes = new Class[0];
        this.tmpl.attributeSetTemplates = new Entry[0];
        this.update();
    }

    private void reset() {
        this.ssuper.setState(false);
        this.esuper.setState(false);
        this.sclass.setState(false);
        this.resetTmpl();
    }

    private void setGroups(String[] stringArray) {
        ((DiscoveryLocatorManagement)((Object)this.disco)).setLocators(new LookupLocator[0]);
        try {
            this.disco.setGroups(stringArray);
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "setting groups failed", throwable);
        }
        this.resetTmpl();
    }

    private static String[] parseList(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            if (bl && stringArray[n].equalsIgnoreCase("public")) {
                stringArray[n] = "";
            }
            ++n;
        }
        return stringArray;
    }

    private void update() {
        this.setText(false);
        if (this.elease != null) {
            try {
                this.leaseMgr.cancel(this.elease);
            }
            catch (Throwable throwable) {
                logger.log(Levels.HANDLED, "lease cancellation failed", throwable);
            }
            this.elease = null;
        }
        if (this.lookup == null) {
            return;
        }
        try {
            EventRegistration eventRegistration = this.lookup.notify(this.tmpl, 7, this.listen.proxy, null, -1L);
            this.elease = (Lease)this.leasePreparer.prepareProxy(eventRegistration.getLease());
            this.leaseMgr.renewUntil(this.elease, -1L, this.lnotify);
            this.eventID = eventRegistration.getID();
            this.seqNo = eventRegistration.getSequenceNumber();
        }
        catch (Throwable throwable) {
            this.failure(throwable);
        }
    }

    private void failure(Throwable throwable) {
        logger.log(Level.INFO, "call to lookup service failed", throwable);
        ((DiscoveryManagement)((Object)this.disco)).discard(this.lookup);
    }

    private static boolean isAdministrable(ServiceItem serviceItem) {
        return serviceItem.service instanceof Administrable;
    }

    private static boolean isJoinAdministrable(ServiceItem serviceItem) throws RemoteException {
        if (!Browser.isAdministrable(serviceItem)) {
            return false;
        }
        try {
            return ((Administrable)serviceItem.service).getAdmin() instanceof JoinAdmin;
        }
        catch (SecurityException securityException) {
            logger.log(Levels.HANDLED, "getAdmin call failed", securityException);
            return false;
        }
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            final Configuration configuration = ConfigurationProvider.getInstance(stringArray, Browser.class.getClassLoader());
            LoginContext loginContext = (LoginContext)configuration.getEntry(BROWSER, "loginContext", LoginContext.class, null);
            if (loginContext != null) {
                loginContext.login();
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Browser(null, configuration);
                }
            };
            if (loginContext != null) {
                Subject.doAsPrivileged(loginContext.getSubject(), privilegedExceptionAction, null);
            } else {
                privilegedExceptionAction.run();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof PrivilegedActionException) {
                throwable2 = throwable.getCause();
            }
            logger.log(Level.SEVERE, "browser initialization failed", throwable2);
        }
    }

    static {
        Browser.icons[0] = MetalIcons.getBlueFolderIcon();
        Browser.icons[1] = MetalIcons.getGrayFolderIcon();
        Browser.icons[2] = MetalIcons.getUnusableFolderIcon();
    }

    private class Exit
    implements ActionListener {
        private Exit() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class Exiter
    extends WindowAdapter {
        private Exiter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Browser.this.exiter.actionPerformed(new ActionEvent(windowEvent.getSource(), windowEvent.getID(), "Exit", System.currentTimeMillis(), 0));
        }
    }

    private class ServiceListPopup
    extends JPopupMenu
    implements ActionListener,
    PopupMenuListener {
        protected JMenuItem infoItem;
        protected JMenuItem browseItem;
        protected JMenuItem adminItem;
        protected JMenuItem spaceItem;
        protected ServiceItem item;

        public ServiceListPopup() {
            ActionListener actionListener = Browser.this.wrap(this);
            this.infoItem = new JMenuItem("Show Info");
            this.infoItem.addActionListener(actionListener);
            this.infoItem.setActionCommand("showInfo");
            this.add(this.infoItem);
            this.browseItem = new JMenuItem("Browse Service");
            this.browseItem.addActionListener(actionListener);
            this.browseItem.setActionCommand("browseService");
            this.add(this.browseItem);
            this.adminItem = new JMenuItem("Admin Service");
            this.adminItem.addActionListener(actionListener);
            this.adminItem.setActionCommand("adminService");
            this.add(this.adminItem);
            this.spaceItem = new JMenuItem("Browse Entries");
            this.spaceItem.addActionListener(actionListener);
            this.spaceItem.setActionCommand("browseEntry");
            this.add(this.spaceItem);
            this.addPopupMenuListener(this);
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
        }

        public void setServiceItem(ServiceListItem serviceListItem) {
            this.item = serviceListItem.getServiceItem();
            try {
                if (!serviceListItem.isAccessible()) {
                    this.infoItem.setEnabled(false);
                    this.browseItem.setEnabled(false);
                    this.adminItem.setEnabled(false);
                    this.spaceItem.setEnabled(false);
                } else {
                    this.infoItem.setEnabled(true);
                    this.browseItem.setEnabled(true);
                    this.adminItem.setEnabled(Browser.isJoinAdministrable(this.item));
                    this.spaceItem.setEnabled(this.item.service instanceof JavaSpace);
                }
            }
            catch (Throwable throwable) {
                logger.log(Levels.HANDLED, "determining admin status failed", throwable);
                this.infoItem.setEnabled(false);
                this.browseItem.setEnabled(false);
                this.adminItem.setEnabled(false);
                this.spaceItem.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("showInfo")) {
                Class[] classArray = Browser.getInterfaces(this.item.service.getClass());
                String[] stringArray = new String[3 + classArray.length];
                stringArray[0] = "ServiceID: " + this.item.serviceID;
                stringArray[1] = "Service Instance: " + this.item.service.getClass().getName();
                stringArray[2] = classArray.length == 1 ? "Implemented Interface:" : "Implemented Interfaces:";
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[3 + i] = classArray[i].getName();
                }
                JOptionPane.showMessageDialog(Browser.this, stringArray, "ServiceItem Information", 1);
            } else if (string.equals("browseService")) {
                new ServiceBrowser(this.item, Browser.this.lookup, Browser.this).setVisible(true);
            } else if (string.equals("adminService")) {
                new ServiceEditor(this.item, Browser.this.lookup, Browser.this).setVisible(true);
            } else if (string.equals("browseEntry")) {
                try {
                    JavaSpaceAdmin javaSpaceAdmin = (JavaSpaceAdmin)Browser.this.adminPreparer.prepareProxy(((Administrable)this.item.service).getAdmin());
                    new SpaceBrowser(javaSpaceAdmin, Browser.this).setVisible(true);
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "browsing space failed", throwable);
                    JOptionPane.showMessageDialog(Browser.this, throwable.getMessage(), throwable.getClass().getName(), 2);
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class MouseReceiver
    extends MouseAdapter {
        private ServiceListPopup popup;

        public MouseReceiver(ServiceListPopup serviceListPopup) {
            this.popup = serviceListPopup;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                ServiceItem serviceItem = this.getTargetItem(mouseEvent);
                if (serviceItem == null) {
                    return;
                }
                try {
                    if (this.getTargetListItem(mouseEvent).isAccessible()) {
                        if (Browser.isJoinAdministrable(serviceItem)) {
                            new ServiceEditor(serviceItem, Browser.this.lookup, Browser.this).setVisible(true);
                        } else {
                            new ServiceBrowser(serviceItem, Browser.this.lookup, Browser.this).setVisible(true);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.log(Levels.HANDLED, "accessing service failed", throwable);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.getTargetListItem(mouseEvent) != null) {
                this.popup.setServiceItem(this.getTargetListItem(mouseEvent));
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && this.getTargetListItem(mouseEvent) != null) {
                this.popup.setServiceItem(this.getTargetListItem(mouseEvent));
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private ServiceListItem getTargetListItem(MouseEvent mouseEvent) {
            int n = Browser.this.list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                return (ServiceListItem)Browser.this.listModel.getElementAt(n);
            }
            return null;
        }

        private ServiceItem getTargetItem(MouseEvent mouseEvent) {
            ServiceListItem serviceListItem = this.getTargetListItem(mouseEvent);
            if (serviceListItem != null) {
                return serviceListItem.getServiceItem();
            }
            return null;
        }
    }

    private class ServiceListItem {
        private ServiceItem item;
        private boolean isAccessible = true;

        public ServiceListItem(ServiceItem serviceItem) {
            this.item = serviceItem;
            if (serviceItem.service == null) {
                this.isAccessible = false;
            }
        }

        public String getTitle() {
            if (this.item.service == null) {
                return "Unknown service";
            }
            HashSet<String> hashSet = new HashSet<String>();
            Class[] classArray = Browser.getInterfaces(this.item.service.getClass());
            for (int i = 0; i < classArray.length; ++i) {
                hashSet.add(classArray[i].getName());
            }
            hashSet.removeAll(Browser.this.ignoreInterfaces);
            String string = null;
            if (hashSet.size() == 1) {
                Iterator iterator = hashSet.iterator();
                string = (String)iterator.next();
            } else {
                string = this.item.service.getClass().getName();
            }
            if (!this.isAccessible) {
                string = string + " (Stale service)";
            }
            return string;
        }

        public boolean isAccessible() {
            return this.isAccessible;
        }

        public ServiceItem getServiceItem() {
            return this.item;
        }

        public Entry[] getAttributes() {
            return this.item.attributeSets;
        }

        private boolean isControllable(int n) {
            return !(this.item.attributeSets[n] instanceof ServiceControlled);
        }

        public Icon getIcon() {
            try {
                if (!this.isAccessible) {
                    return icons[2];
                }
                if (Browser.isJoinAdministrable(this.item)) {
                    return icons[0];
                }
                return icons[1];
            }
            catch (Throwable throwable) {
                logger.log(Levels.HANDLED, "determining admin status failed", throwable);
                this.isAccessible = false;
                return icons[2];
            }
        }

        public String toString() {
            return this.isAccessible ? this.item.service.getClass().getName() : "Unknown service";
        }
    }

    class ServiceItemRenderer
    implements ListCellRenderer {
        private JLabel label = new JLabel();

        public ServiceItemRenderer() {
            this.label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ServiceListItem serviceListItem = null;
            if (object instanceof ServiceListItem) {
                serviceListItem = (ServiceListItem)object;
            }
            this.label.setFont(jList.getFont());
            if (bl) {
                this.label.setBackground(jList.getSelectionBackground());
                this.label.setForeground(jList.getSelectionForeground());
            } else {
                this.label.setBackground(jList.getBackground());
                this.label.setForeground(jList.getForeground());
            }
            if (serviceListItem != null) {
                this.label.setIcon(serviceListItem.getIcon());
                this.label.setText(serviceListItem.getTitle());
            } else {
                this.label.setText(object.toString());
            }
            return this.label;
        }
    }

    static class LeaseNotify
    implements LeaseListener {
        LeaseNotify() {
        }

        public void notify(LeaseRenewalEvent leaseRenewalEvent) {
            if (leaseRenewalEvent.getException() != null) {
                logger.log(Level.INFO, "lease renewal failed", leaseRenewalEvent.getException());
            } else {
                logger.log(Level.INFO, "lease renewal failed");
            }
        }
    }

    private class Lookup
    implements ActionListener {
        private ServiceRegistrar registrar;

        public Lookup(ServiceRegistrar serviceRegistrar) {
            this.registrar = serviceRegistrar;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Browser.this.lookup == this.registrar) {
                Browser.this.lookup = null;
            } else {
                Browser.this.lookup = this.registrar;
            }
            Browser.this.seqNo = Long.MAX_VALUE;
            for (int i = 0; i < Browser.this.registrars.getMenuComponentCount(); ++i) {
                JMenuItem jMenuItem = (JMenuItem)Browser.this.registrars.getMenuComponent(i);
                if (jMenuItem == actionEvent.getSource()) continue;
                jMenuItem.setSelected(false);
            }
            Browser.this.resetTmpl();
        }
    }

    private class UniFind
    implements ActionListener {
        private UniFind() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Browser.this, (Object)"Enter host[:port] addresses");
            if (string == null) {
                return;
            }
            String[] stringArray = Browser.parseList(string, false);
            LookupLocator[] lookupLocatorArray = new LookupLocator[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    lookupLocatorArray[i] = new ConstrainableLookupLocator("jini://" + stringArray[i], Browser.this.locatorConstraints);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(Browser.this, "\"" + stringArray[i] + "\": " + malformedURLException.getMessage(), "Bad Address", 0);
                    return;
                }
            }
            try {
                Browser.this.disco.setGroups(new String[0]);
            }
            catch (Throwable throwable) {
                logger.log(Levels.HANDLED, "setting groups failed", throwable);
            }
            ((DiscoveryLocatorManagement)((Object)Browser.this.disco)).setLocators(lookupLocatorArray);
            Browser.this.resetTmpl();
        }
    }

    private class MultiFind
    implements ActionListener {
        private MultiFind() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Browser.this, (Object)"Enter group names");
            if (string == null) {
                return;
            }
            Browser.this.setGroups(Browser.parseList(string, true));
        }
    }

    private class PubFind
    implements ActionListener {
        private PubFind() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Browser.this.setGroups(new String[]{""});
        }
    }

    private class AllFind
    implements ActionListener {
        private AllFind() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Browser.this.setGroups(null);
        }
    }

    private class LookupListener
    implements DiscoveryListener {
        private LookupListener() {
        }

        public void discovered(DiscoveryEvent discoveryEvent) {
            final ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                public void run() {
                    for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                        Browser.this.addOne(serviceRegistrarArray[i]);
                    }
                    if (Browser.this.lookup == null) {
                        Browser.this.setText(false);
                    }
                }
            }));
        }

        public void discarded(DiscoveryEvent discoveryEvent) {
            final ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                public void run() {
                    block0: for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                        ServiceID serviceID = serviceRegistrarArray[i].getServiceID();
                        if (Browser.this.lookup != null && serviceID.equals(Browser.this.lookup.getServiceID())) {
                            Browser.this.lookup = null;
                            Browser.this.seqNo = Long.MAX_VALUE;
                        }
                        for (int j = 0; j < Browser.this.registrars.getMenuComponentCount(); ++j) {
                            JMenuItem jMenuItem = (JMenuItem)Browser.this.registrars.getMenuComponent(j);
                            if (!(jMenuItem instanceof RegistrarMenuItem) || !serviceID.equals(((RegistrarMenuItem)jMenuItem).id)) continue;
                            jMenuItem.setSelected(false);
                            Browser.this.registrars.remove(jMenuItem);
                            if (Browser.this.registrars.getMenuComponentCount() != 0) continue block0;
                            Browser.addNone(Browser.this.registrars);
                            continue block0;
                        }
                    }
                    if (Browser.this.lookup == null) {
                        Browser.this.resetTmpl();
                    }
                }
            }));
        }
    }

    private class Listener
    implements RemoteEventListener,
    ServerProxyTrust {
        private final Exporter exporter;
        final RemoteEventListener proxy;

        public Listener() throws ConfigurationException, ExportException {
            this.exporter = (Exporter)Config.getNonNullEntry(Browser.this.config, Browser.BROWSER, "listenerExporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = Browser.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory()));
            this.proxy = (RemoteEventListener)this.exporter.export(this);
        }

        public void notify(final RemoteEvent remoteEvent) {
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                public void run() {
                    if (Browser.this.eventID == remoteEvent.getID() && Browser.this.seqNo < remoteEvent.getSequenceNumber() && Browser.this.lookup != null && Browser.this.lookup.getServiceID().equals(((ServiceRegistrar)remoteEvent.getSource()).getServiceID())) {
                        Browser.this.seqNo = remoteEvent.getSequenceNumber();
                        Browser.this.setText(false);
                    }
                }
            }));
        }

        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(this.proxy);
        }
    }

    private class Value
    implements ActionListener {
        private int index;
        private Field field;
        private Object value;

        public Value(int n, Field field, Object object) {
            this.index = n;
            this.field = field;
            this.value = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.field.set(((Browser)Browser.this).tmpl.attributeSetTemplates[this.index], this.value);
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "setting attribute value failed", throwable);
            }
            Browser.this.update();
        }
    }

    private class Values
    implements MenuListener {
        private JMenu menu;
        private int index;
        private Field field;

        public Values(JMenu jMenu, int n, Field field) {
            this.menu = jMenu;
            this.index = n;
            this.field = field;
        }

        public void menuSelected(MenuEvent menuEvent) {
            Object[] objectArray;
            try {
                objectArray = Browser.this.lookup.getFieldValues(Browser.this.tmpl, this.index, this.field.getName());
            }
            catch (Throwable throwable) {
                Browser.this.failure(throwable);
                return;
            }
            if (objectArray == null) {
                Browser.addNone(this.menu);
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(objectArray[i].toString());
                jMenuItem.addActionListener(Browser.this.wrap(new Value(this.index, this.field, objectArray[i])));
                this.menu.add(jMenuItem);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            this.menu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.menu.removeAll();
        }
    }

    private class Unmatch
    implements ActionListener {
        private int index;

        public Unmatch(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ((Browser)Browser.this).tmpl.attributeSetTemplates.length;
            Entry[] entryArray = new Entry[n - 1];
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, 0, entryArray, 0, this.index);
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, this.index + 1, entryArray, this.index, n - this.index - 1);
            ((Browser)Browser.this).tmpl.attributeSetTemplates = entryArray;
            Browser.this.update();
        }
    }

    private class Fields
    implements MenuListener {
        private JMenu menu;
        private int index;

        public Fields(JMenu jMenu, int n) {
            this.menu = jMenu;
            this.index = n;
        }

        public void menuSelected(MenuEvent menuEvent) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("(match)");
            jRadioButtonMenuItem.setSelected(true);
            jRadioButtonMenuItem.addActionListener(Browser.this.wrap(new Unmatch(this.index)));
            this.menu.add(jRadioButtonMenuItem);
            Entry entry = ((Browser)Browser.this).tmpl.attributeSetTemplates[this.index];
            Field[] fieldArray = entry.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (!Browser.valid(field)) continue;
                try {
                    JMenuItem jMenuItem;
                    if (field.get(entry) != null) {
                        jMenuItem = new JCheckBoxMenuItem(field.getName(), true);
                        jMenuItem.addActionListener(Browser.this.wrap(new Value(this.index, field, null)));
                        this.menu.add(jMenuItem);
                        continue;
                    }
                    jMenuItem = new JMenu(field.getName());
                    ((JMenu)jMenuItem).addMenuListener(Browser.this.wrap(new Values((JMenu)jMenuItem, this.index, field)));
                    this.menu.add(jMenuItem);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "getting fields failed", throwable);
                }
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            this.menu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.menu.removeAll();
        }
    }

    private class AttrSet
    implements ActionListener {
        private Class type;

        public AttrSet(Class clazz) {
            this.type = clazz;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Entry entry;
            try {
                entry = (Entry)this.type.newInstance();
            }
            catch (Throwable throwable) {
                logger.log(Level.INFO, "creating entry failed", throwable);
                return;
            }
            int n = ((Browser)Browser.this).tmpl.attributeSetTemplates.length;
            Entry[] entryArray = new Entry[n + 1];
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, 0, entryArray, 0, n);
            entryArray[n] = entry;
            ((Browser)Browser.this).tmpl.attributeSetTemplates = entryArray;
            Browser.this.update();
        }
    }

    private class Entries
    implements MenuListener {
        private JMenu menu;

        public Entries(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void menuSelected(MenuEvent menuEvent) {
            Class[] classArray;
            Serializable serializable;
            if (Browser.this.lookup == null) {
                Browser.addNone(this.menu);
                return;
            }
            Entry[] entryArray = ((Browser)Browser.this).tmpl.attributeSetTemplates;
            for (int i = 0; i < entryArray.length; ++i) {
                serializable = entryArray[i].getClass();
                JMenu jMenu = new JMenu(Browser.typeName(serializable));
                jMenu.addMenuListener(new Fields(jMenu, i));
                this.menu.add(jMenu);
            }
            try {
                classArray = Browser.this.lookup.getEntryClasses(Browser.this.tmpl);
            }
            catch (Throwable throwable) {
                Browser.this.failure(throwable);
                return;
            }
            if (classArray == null) {
                if (entryArray.length == 0) {
                    Browser.addNone(this.menu);
                }
                return;
            }
            serializable = new Vector();
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == null) {
                    this.menu.add(new JMenuItem("null"));
                    continue;
                }
                this.addType(classArray[i], (Vector)serializable);
            }
        }

        private void addType(Class clazz, Vector vector) {
            if (vector.contains(clazz)) {
                return;
            }
            vector.addElement(clazz);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Browser.typeName(clazz), false);
            jCheckBoxMenuItem.addActionListener(Browser.this.wrap(new AttrSet(clazz)));
            this.menu.add(jCheckBoxMenuItem);
            if (Browser.this.esuper.getState() && (class$net$jini$core$entry$Entry == null ? (class$net$jini$core$entry$Entry = Browser.class$("net.jini.core.entry.Entry")) : class$net$jini$core$entry$Entry).isAssignableFrom(clazz.getSuperclass())) {
                this.addType(clazz.getSuperclass(), vector);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            this.menu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.menu.removeAll();
        }
    }

    private class Service
    implements ActionListener {
        private Class type;
        private int index;

        public Service(Class clazz, int n) {
            this.type = clazz;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Class[] classArray;
            int n = ((Browser)Browser.this).tmpl.serviceTypes.length;
            if (this.index < 0) {
                classArray = new Class[n + 1];
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, 0, classArray, 0, n);
                classArray[n] = this.type;
            } else {
                classArray = new Class[n - 1];
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, 0, classArray, 0, this.index);
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, this.index + 1, classArray, this.index, n - this.index - 1);
            }
            ((Browser)Browser.this).tmpl.serviceTypes = classArray;
            Browser.this.update();
        }
    }

    private class Reset
    implements ActionListener {
        private Reset() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Browser.this.reset();
        }
    }

    private class Show
    implements ActionListener {
        private Show() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Browser.this.setText(true);
        }
    }

    private class Handler
    implements InvocationHandler {
        private final Object obj;

        Handler(Object object) {
            this.obj = object;
        }

        public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = Browser.class$("java.lang.Object")) : class$java$lang$Object)) {
                if ("equals".equals(method.getName())) {
                    return object == objectArray[0];
                }
                if ("hashCode".equals(method.getName())) {
                    return new Integer(System.identityHashCode(object));
                }
            }
            try {
                return AccessController.doPrivileged(Browser.this.ctx.wrap(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Thread thread = Thread.currentThread();
                        ClassLoader classLoader = thread.getContextClassLoader();
                        try {
                            thread.setContextClassLoader(Browser.this.ccl);
                            try {
                                Object object = method.invoke(Handler.this.obj, objectArray);
                                return object;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwable throwable = invocationTargetException.getCause();
                                if (throwable instanceof Error) {
                                    throw (Error)throwable;
                                }
                                throw (Exception)throwable;
                            }
                        }
                        finally {
                            thread.setContextClassLoader(classLoader);
                        }
                    }
                }), Browser.this.ctx.getAccessControlContext());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        }
    }

    private class Services
    implements MenuListener {
        private JMenu menu;

        public Services(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void menuSelected(MenuEvent menuEvent) {
            Class[] classArray;
            int n;
            if (Browser.this.lookup == null) {
                Browser.addNone(this.menu);
                return;
            }
            Vector<Serializable> vector = new Vector<Serializable>();
            Class[] classArray2 = ((Browser)Browser.this).tmpl.serviceTypes;
            for (n = 0; n < classArray2.length; ++n) {
                vector.addElement(classArray2[n]);
                classArray = new JCheckBoxMenuItem(classArray2[n].getName(), true);
                classArray.addActionListener(Browser.this.wrap(new Service(classArray2[n], n)));
                this.menu.add((JMenuItem)classArray);
            }
            try {
                classArray2 = Browser.this.lookup.getServiceTypes(Browser.this.tmpl, "");
            }
            catch (Throwable throwable) {
                Browser.this.failure(throwable);
                return;
            }
            if (classArray2 == null) {
                if (vector.isEmpty()) {
                    Browser.addNone(this.menu);
                }
                return;
            }
            for (n = 0; n < classArray2.length; ++n) {
                if (classArray2[n] == null) {
                    vector.addElement(new JMenuItem("null"));
                    continue;
                }
                classArray = classArray2[n].isInterface() || Browser.this.sclass.getState() ? new Class[]{classArray2[n]} : Browser.getInterfaces(classArray2[n]);
                for (int i = 0; i < classArray.length; ++i) {
                    this.addType(classArray[i], vector);
                }
            }
        }

        private void addType(Class clazz, Vector vector) {
            if (vector.contains(clazz)) {
                return;
            }
            vector.addElement(clazz);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(clazz.getName(), false);
            jCheckBoxMenuItem.addActionListener(Browser.this.wrap(new Service(clazz, -1)));
            this.menu.add(jCheckBoxMenuItem);
            if (!Browser.this.ssuper.getState()) {
                return;
            }
            if (Browser.this.sclass.getState() && clazz.getSuperclass() != null) {
                this.addType(clazz.getSuperclass(), vector);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                this.addType(classArray[i], vector);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            this.menu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            this.menu.removeAll();
        }
    }

    private static class RegistrarMenuItem
    extends JRadioButtonMenuItem {
        ServiceID id;

        RegistrarMenuItem(String string, ServiceID serviceID) {
            super(string);
            this.id = serviceID;
        }
    }
}

