/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.accessories;

import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.accessories.CalloutToolTip;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CalloutToolTipManager {
    private ToolTipListener fToolTipListener = new ToolTipListener();
    private Timer fTimer;
    private Client fTipClient;
    private CalloutToolTip fTip;
    private boolean fGlobalListenerAttached;
    private boolean fMousedOver;
    private static CalloutToolTipManager sInstance = new CalloutToolTipManager();
    private static final int TIP_DELAY = 1000;
    private static final int OVERSHOOT_MARGIN = 10;
    private static final String CLIENT_PROPERTY_KEY = "tool-tip-manager-client";

    private CalloutToolTipManager() {
    }

    public static CalloutToolTipManager getInstance() {
        return sInstance;
    }

    public void register(Client client) {
        JComponent jComponent = client.getComponent();
        jComponent.putClientProperty(CLIENT_PROPERTY_KEY, client);
        jComponent.addMouseListener(this.fToolTipListener);
    }

    public void clear() {
        this.cancelPendingTip();
        this.hideTip();
    }

    private void showTip() {
        if (this.fTipClient != null) {
            JComponent jComponent = this.fTipClient.getComponent();
            Frame frame = (Frame)WindowUtils.getTopmostWindow((Component)jComponent);
            if (frame == null) {
                return;
            }
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, jComponent);
            this.fTip = new CalloutToolTip(this.fTipClient.getComponent(), null, this.fTipClient.getToolTipContentProvider().getToolTipContent(), new Dimension(600, 600), SwingUtilities.getAncestorOfClass(GalleryView.class, jComponent) == null ? CalloutToolTip.EAST_WEST_PLACEMENT : CalloutToolTip.SOUTH_NORTH_PLACEMENT);
            this.fTip.show();
            this.fMousedOver = false;
            if (!this.fGlobalListenerAttached) {
                Toolkit.getDefaultToolkit().addAWTEventListener(new GlobalEventListener(), 40L);
                this.fGlobalListenerAttached = true;
            }
        }
    }

    private void cancelPendingTip() {
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
            this.fTipClient = null;
        }
    }

    private void hideTip() {
        if (this.fTip != null) {
            this.fTip.hide();
            this.fTip = null;
            this.fTipClient = null;
        }
    }

    private class GlobalEventListener
    implements AWTEventListener {
        private GlobalEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (CalloutToolTipManager.this.fTipClient != null && CalloutToolTipManager.this.fTip != null && CalloutToolTipManager.this.fTip.isShowing()) {
                if (aWTEvent.getID() == 503) {
                    Rectangle rectangle;
                    Point point = ((MouseEvent)aWTEvent).getPoint();
                    SwingUtilities.convertPointToScreen(point, ((MouseEvent)aWTEvent).getComponent());
                    Rectangle rectangle2 = rectangle = CalloutToolTipManager.this.fTip.getBounds();
                    if (CalloutToolTipManager.this.fMousedOver) {
                        rectangle2 = new Rectangle(rectangle);
                        rectangle2.width += 10;
                    }
                    if (rectangle2.contains(point)) {
                        CalloutToolTipManager.this.fMousedOver = true;
                        return;
                    }
                    JComponent jComponent = CalloutToolTipManager.this.fTipClient.getComponent();
                    Point point2 = new Point();
                    SwingUtilities.convertPointToScreen(point2, jComponent);
                    Rectangle rectangle3 = new Rectangle(point2.x, point2.y, jComponent.getWidth(), jComponent.getHeight());
                    if (rectangle3.contains(point)) {
                        return;
                    }
                    int n = rectangle3.x + rectangle3.width;
                    if (rectangle.x > n && point.x <= rectangle.x && point.x >= n) {
                        return;
                    }
                    int n2 = rectangle.x + rectangle.width;
                    if (n2 < rectangle3.x && point.x >= n2 && point.x <= rectangle3.x) {
                        return;
                    }
                    int n3 = rectangle3.y + rectangle3.height;
                    if (rectangle.y > n3 && point.y <= rectangle.y && point.y >= n3) {
                        return;
                    }
                    int n4 = rectangle.y + rectangle.height;
                    if (n4 < rectangle3.y && point.y >= n4 && point.y <= rectangle3.y) {
                        return;
                    }
                    CalloutToolTipManager.this.hideTip();
                } else if (aWTEvent.getID() == 401) {
                    CalloutToolTipManager.this.hideTip();
                }
            }
        }
    }

    private class ToolTipListener
    extends MouseAdapter
    implements ActionListener {
        private ToolTipListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent() instanceof JComponent) {
                MenuElement[] menuElementArray;
                if (CalloutToolTipManager.this.fTipClient != null && CalloutToolTipManager.this.fTip != null && !CalloutToolTipManager.this.fTip.isShowing()) {
                    CalloutToolTipManager.this.fTip = null;
                    CalloutToolTipManager.this.fTipClient = null;
                }
                if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) != null && menuElementArray.length > 0) {
                    return;
                }
                Window window = WindowUtils.getWindowForComponent((Component)mouseEvent.getComponent());
                if (!(window != null && window.isActive() || (window = WindowUtils.getTopmostWindow((Component)mouseEvent.getComponent())) != null && window.isActive())) {
                    return;
                }
                Client client = (Client)((JComponent)mouseEvent.getComponent()).getClientProperty(CalloutToolTipManager.CLIENT_PROPERTY_KEY);
                if (client != CalloutToolTipManager.this.fTipClient) {
                    CalloutToolTipManager.this.hideTip();
                    ToolTipContentProvider toolTipContentProvider = client.getToolTipContentProvider();
                    if (toolTipContentProvider == null) {
                        CalloutToolTipManager.this.cancelPendingTip();
                    } else {
                        if (CalloutToolTipManager.this.fTimer == null) {
                            CalloutToolTipManager.this.fTimer = new Timer(1000, this);
                            CalloutToolTipManager.this.fTimer.setRepeats(false);
                            CalloutToolTipManager.this.fTimer.start();
                        } else {
                            CalloutToolTipManager.this.fTimer.restart();
                        }
                        CalloutToolTipManager.this.fTipClient = client;
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            CalloutToolTipManager.this.cancelPendingTip();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            CalloutToolTipManager.this.hideTip();
            CalloutToolTipManager.this.cancelPendingTip();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalloutToolTipManager.this.showTip();
            CalloutToolTipManager.this.fTimer = null;
        }
    }

    public static interface Client {
        public JComponent getComponent();

        public ToolTipContentProvider getToolTipContentProvider();
    }
}

