/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.ComponentMnemonicsProvider;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TSToggleButton
extends MJToggleButton
implements HasMnemonic,
TSComponent {
    public static final String BUTTON_ORIENTATION_PROPERTY = "buttonOrientation";
    private ButtonOrientation fOrientation = ButtonOrientation.AUTO;
    private String fMnemonic;

    public TSToggleButton() {
    }

    public TSToggleButton(Action action) {
        super(action);
    }

    public TSToggleButton(Icon icon) {
        super(icon);
    }

    public TSToggleButton(String string) {
        super(string);
    }

    public TSToggleButton(String string, Icon icon) {
        super(string, icon);
    }

    public TSToggleButton(Icon icon, boolean bl) {
        super(icon, bl);
    }

    public TSToggleButton(String string, boolean bl) {
        super(string, bl);
    }

    public TSToggleButton(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
    }

    public ButtonOrientation getOrientation() {
        return this.fOrientation;
    }

    public TSToggleButton setOrientation(ButtonOrientation buttonOrientation) {
        Preconditions.checkNotNull((Object)((Object)buttonOrientation), (Object)"Orientation cannot be null");
        ButtonOrientation buttonOrientation2 = this.fOrientation;
        this.fOrientation = buttonOrientation;
        if (buttonOrientation2 != buttonOrientation) {
            this.firePropertyChange(BUTTON_ORIENTATION_PROPERTY, (Object)buttonOrientation2, (Object)buttonOrientation);
        }
        return this;
    }

    @Override
    @NotNull
    public LayoutMode getSupportedLayoutMode() {
        switch (this.getOrientation()) {
            case VERTICAL: {
                return LayoutMode.VERTICAL_ONLY_CAPABILITIES;
            }
            case HORIZONTAL: {
                return LayoutMode.HORIZONTAL_NO_LABELS_CAPABILITIES;
            }
        }
        return LayoutMode.VERTICAL_HORIZONTAL_NO_LABELS_CAPABILITIES;
    }

    @Override
    public int getPreferredWidth(@NotNull LayoutMode layoutMode, int n) {
        return this.getUI().getPreferredWidth(this, layoutMode);
    }

    @Override
    public boolean canBeGroupedWith(@NotNull TSComponent tSComponent) {
        return tSComponent instanceof AbstractButton;
    }

    public void setText(String string) {
        if (this.isAutoMnemonicEnabled() && string != null) {
            String[] stringArray = LAFUtil.parseMnemonic(string);
            super.setText(stringArray[0]);
            this.fMnemonic = stringArray[1];
            this.fOriginalString = string;
        } else {
            super.setText(string);
        }
    }

    public String getButtonMnemonic() {
        return this.fMnemonic;
    }

    public void setButtonMnemonic(String string) {
        this.fMnemonic = string;
    }

    public Mnemonic getComponentMnemonic() {
        return this.fMnemonic == null ? null : new Mnemonic(){

            @NotNull
            public String getMnemonic() {
                return TSToggleButton.this.fMnemonic;
            }

            @NotNull
            public Point getLocationOnComponent() {
                return TSUtil.getMnemonicLocation((AbstractButton)((Object)TSToggleButton.this), TSToggleButton.this.getOrientation());
            }

            @NotNull
            public JComponent getComponent() {
                return TSToggleButton.this;
            }
        };
    }

    public ToolstripButtonUI getUI() {
        return (ToolstripButtonUI)this.ui;
    }

    public String getUIClassID() {
        return "Toolstrip.ToggleButtonUI";
    }

    protected void doCustomSetup() {
    }

    public boolean isFocusTraversable() {
        return this.super_isFocusTraversable();
    }

    public String toString() {
        return LAFUtil.getComponentDescription(this, this.getText());
    }

    public MnemonicsProvider getMnemonicsProvider() {
        return this.fMnemonic == null ? null : this.createProvider();
    }

    protected ButtonMnemonicsProvider createProvider() {
        return new ButtonMnemonicsProvider();
    }

    public String getToolTipText() {
        String string = this.getHiddenLabelTip();
        return string != null ? string : super.getToolTipText();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = this.getHiddenLabelTip();
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    private String getHiddenLabelTip() {
        if (this.fTextHidden && this.fOriginalString != null && this.fOriginalString.length() > 0) {
            String string = LAFUtil.parseMnemonic(this.fOriginalString)[0];
            Action action = this.getAction();
            return action instanceof ExtendedAction ? KeyStrokeUtils.appendShortcut((String)string, (ExtendedAction)((ExtendedAction)action)) : string;
        }
        return null;
    }

    public class ButtonMnemonicsProvider
    extends ComponentMnemonicsProvider {
        public ButtonMnemonicsProvider() {
            super((JComponent)((Object)TSToggleButton.this));
        }

        @Override
        protected void execute() {
            TSUtil.clickButton((AbstractButton)((Object)TSToggleButton.this));
        }
    }
}

