/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.mathworks.desktop.mnemonics.MnemonicsManagerImpl;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.components.ButtonOrientation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class TSUtil {
    public static final String KEEP_POPUPS_OPEN_PROPERTY_KEY = "keep-popups-open";
    private static Map<Toolstrip, KeyTriggerListener> sKeyTriggerListenerMap = new HashMap<Toolstrip, KeyTriggerListener>();

    private TSUtil() {
    }

    public static void keyPopupsOpenFollowingAction(JComponent jComponent) {
        jComponent.putClientProperty(KEEP_POPUPS_OPEN_PROPERTY_KEY, true);
    }

    public static void toolstripActionProcessed(Component component) {
        MnemonicsManagers.get().clear();
        if (component instanceof JComponent && ((JComponent)component).getClientProperty(KEEP_POPUPS_OPEN_PROPERTY_KEY) == Boolean.TRUE) {
            return;
        }
        OverlayManager overlayManager = OverlayManagers.get((Component)component);
        if (overlayManager != null) {
            overlayManager.removeSingleSelectPopups();
        }
    }

    public static void relinquishFocus(Component component) {
        Toolstrip toolstrip = TSRobot.getToolstripFor(component);
        if (toolstrip instanceof DefaultToolstrip) {
            ((DefaultToolstrip)toolstrip).relinquishFocus();
        }
    }

    public static void clickButton(final AbstractButton abstractButton) {
        if (TSUtil.fireKeyTriggerListener(abstractButton)) {
            ((MnemonicsManagerImpl)MnemonicsManagers.get()).suppressFocusReturn();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    abstractButton.doClick();
                }
            });
        } else {
            abstractButton.doClick();
        }
    }

    public static void addKeyTriggerListener(Toolstrip toolstrip, KeyTriggerListener keyTriggerListener) {
        sKeyTriggerListenerMap.put(toolstrip, keyTriggerListener);
    }

    public static void removeKeyTriggerListener(Toolstrip toolstrip, KeyTriggerListener keyTriggerListener) {
        if (keyTriggerListener == sKeyTriggerListenerMap.get(toolstrip)) {
            sKeyTriggerListenerMap.remove(toolstrip);
        }
    }

    private static boolean fireKeyTriggerListener(Component component) {
        KeyTriggerListener keyTriggerListener;
        Toolstrip toolstrip = TSRobot.getToolstripFor(component);
        if (toolstrip != null && (keyTriggerListener = sKeyTriggerListenerMap.get(toolstrip)) != null) {
            return keyTriggerListener.triggeredByKey();
        }
        return false;
    }

    public static void setDefaultRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static String getSequentialMnemonic(int n) {
        if (n < 9) {
            return Integer.toString(n + 1);
        }
        if (n < 18) {
            return "0" + (n - 8);
        }
        if (n < 44) {
            return "0" + (char)(65 + (n - 18));
        }
        return null;
    }

    public static Point getMnemonicLocation(AbstractButton abstractButton) {
        return TSUtil.getMnemonicLocation(abstractButton, ButtonOrientation.HORIZONTAL);
    }

    public static Point getMnemonicLocation(AbstractButton abstractButton, ButtonOrientation buttonOrientation) {
        return TSUtil.getMnemonicLocation(abstractButton, buttonOrientation, abstractButton.getText() != null && abstractButton.getText().length() > 0);
    }

    public static Point getMnemonicLocation(JComponent jComponent, ButtonOrientation buttonOrientation, boolean bl) {
        Dimension dimension = jComponent.getSize();
        return new Point(bl && buttonOrientation != ButtonOrientation.VERTICAL ? 32 : dimension.width / 2, dimension.height);
    }

    public static interface KeyTriggerListener {
        public boolean triggeredByKey();
    }
}

