/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.model;

import com.mathworks.toolstrip.components.gallery.model.DefaultGalleryModel;
import com.mathworks.toolstrip.components.gallery.model.FilteredGalleryModel;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.util.Predicate;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class SearchableGalleryModel
extends FilteredGalleryModel {
    public SearchableGalleryModel() {
        this(new DefaultGalleryModel());
    }

    public SearchableGalleryModel(@NotNull GalleryModel galleryModel) {
        super(galleryModel);
    }

    @Override
    public void dispose() {
        this.fParentModel.removePropertyChangeListener(this.fPropertyListener);
    }

    public void endSearch() {
        this.setFilter(null);
    }

    public void search(String string) {
        if (string == null || string.isEmpty()) {
            this.endSearch();
        } else {
            SearchFilter searchFilter = (SearchFilter)this.getFilter();
            if (searchFilter == null) {
                this.setFilter(new SearchFilter(string));
            } else {
                searchFilter.setText(string);
                this.updateFilter();
            }
        }
    }

    public boolean isSearchInProgress() {
        boolean bl = false;
        SearchFilter searchFilter = (SearchFilter)this.getFilter();
        if (searchFilter != null && searchFilter.iSearchText != null && !searchFilter.iSearchText.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private static class SearchFilter
    implements Predicate<Item> {
        private String iSearchText;

        private SearchFilter(String string) {
            this.setText(string);
        }

        private void setText(String string) {
            this.iSearchText = string.toUpperCase(Locale.getDefault());
        }

        public boolean accept(Item item) {
            if (this.iSearchText == null || item.getLabel().toUpperCase(Locale.getDefault()).contains(this.iSearchText) || item.getDescription() != null && item.getDescription().toUpperCase(Locale.getDefault()).contains(this.iSearchText)) {
                return true;
            }
            if (item.getKeyWords() != null) {
                for (String string : item.getKeyWords()) {
                    if (!string.toUpperCase(Locale.getDefault()).contains(this.iSearchText)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

