/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerListener;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.factory.XMLUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.Pair;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TSToolSetContents {
    public static final String SHORTCUT_FREE_DESCRIPTION = "shortcut-free-description";
    private final String fName;
    private final ResourceBundle fResourceBundle;
    private final KeyBindingManager fKeyBindingManager;
    private final Map<String, Tool> fToolMap = new HashMap<String, Tool>();
    private final List<Dependency> fDependencyList = new ArrayList<Dependency>();
    private CodeType fInitCodeType;
    private String fInitCode;
    private boolean fHasDownwardDependencies;
    private boolean fIsTemplate;
    private Map<String, TSToolSetContents> fContributingToolSetMap;
    private static final String TOOLSET_TAG = "toolset";
    private static final String TOOL_TAG = "tool";
    private static final String ICON_TAG = "icon";
    private static final String CHILD_TOOL_TAG = "child_tool";
    private static final String PARENT_TOOL_TAG = "parent_tool";
    private static final String SEPARATOR_TAG = "separator";
    private static final String INIT_CALL_TAG = "init_call";
    private static final String CALLBACK_TAG = "callback";
    private static final String TOOL_SET_ID_ATTRIBUTE = "toolset_id";
    private static final String TEMPLATE_ATTRIBUTE = "template";
    private static final String ACTION_ID_ATTRIBUTE = "action_id";
    private static final String CONTEXT_ID_ATTRIBUTE = "context_id";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String STYLE_ATTRIBUTE = "style";
    private static final String HEADER_TYPE_ATTRIBUTE = "header";
    private static final String ELIGIBILITY_ATTRIBUTE = "quick_access_eligible";
    private static final String COMMON_ATTRIBUTE = "common";
    private static final String KEEP_POPUPS_OPEN_ATTRIBUTE = "keep_popups_open";
    private static final String ALPHABETIZE_ATTRIBUTE = "alphabetize";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String FILENAME_ATTRIBUTE = "filename";
    private static final String CONTEXTUAL_ATTRIBUTE = "contextual";
    private static final String REFERENCE_ID_ATTRIBUTE = "reference_id";
    private static final String REFERENCE_TOOLSET_ID_ATTRIBUTE = "reference_toolset_id";
    private static final String POSITION_ATTRIBUTE = "position";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String CATEGORY_VALUE = "category";
    private static final String MENU_STYLE_VALUE = "menu";
    private static final String TEXT_ONLY_STYLE_VALUE = "text_only";
    private static final String WITH_ICON_STYLE_VALUE = "with_icon";
    private static final String WITH_LARGE_ICON_STYLE_VALUE = "with_large_icon";
    private static final String WITH_ONE_LINE_STYLE_VALUE = "with_one_line";
    private static final String WITH_DESCRIPTION_STYLE_VALUE = "with_description";
    private static final String TEXT_ONLY_ALIAS = "text_list";
    private static final String WITH_ICON_ALIAS = "text_icon_list";
    private static final String WITH_DESCRIPTION_ALIAS = "rich_list";
    private static final String CODE_TYPE_ATTRIBUTE = "type";
    private static final String ROWS_ATTRIBUTE = "rows";
    private static final String MIN_COLUMNS_ATTRIBUTE = "min_columns";
    private static final String MAX_COLUMNS_ATTRIBUTE = "max_columns";
    private static final String LABEL_LINE_COUNT_ATTRIBUTE = "label_line_count";
    private static final String COLUMN_WIDTH_ATTRIBUTE = "column_width";
    private static final String POPUP_VIEWS_ATTRIBUTE = "popup_views";
    private static final String INITIAL_POPUP_ATTRIBUTE = "initial_popup";
    private static final String ENABLE_SEARCH_ATTRIBUTE = "enable_search";
    private static final String MULTI_SELECT_POPUP_ATTRIBUTE = "multi_select_popup";
    private static final String ONLY_FAVORITES_ATTRIBUTE = "show_only_favorites";
    private static final String SHOW_SELECTION_ATTRIBUTE = "show_selection";
    private static final String SUPPORT_FAVORITES_ATTRIBUTE = "support_favorites";

    public TSToolSetContents(String string) {
        this(string, null);
    }

    public TSToolSetContents(String string, boolean bl) {
        this(string, null);
        this.fIsTemplate = bl;
        if (bl) {
            this.fContributingToolSetMap = new HashMap<String, TSToolSetContents>();
        }
    }

    public TSToolSetContents(String string, ResourceBundle resourceBundle) {
        this(string, resourceBundle, null);
    }

    public TSToolSetContents(String string, ResourceBundle resourceBundle, KeyBindingManager keyBindingManager) {
        this.fName = string;
        this.fResourceBundle = resourceBundle;
        this.fKeyBindingManager = keyBindingManager;
    }

    public String getName() {
        return this.fName;
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public CodeType getInitCodeType() {
        return this.fInitCodeType;
    }

    public String getInitCode() {
        return this.fInitCode;
    }

    public int getToolCount() {
        return this.fToolMap.size();
    }

    public Tool getTool(String string) {
        return this.fToolMap.get(string);
    }

    public Tool addTool(ToolParameters toolParameters, Dependency ... dependencyArray) {
        Tool tool = new Tool(toolParameters.iName, toolParameters.iToolSetName == null ? this.fName : toolParameters.iToolSetName, toolParameters.iType, toolParameters.iStyle, toolParameters.iHeaderType, toolParameters.iGalleryOptions, toolParameters.iIcon, toolParameters.iLabel, toolParameters.iDescription, toolParameters.iKeywordList, toolParameters.iActionId, toolParameters.iContextId, toolParameters.iIsQuickAccessEligible, toolParameters.iIsCommon, toolParameters.iKeepPopupsOpen, toolParameters.iAlphabetizeChildren, toolParameters.iCodeType, toolParameters.iCode);
        return this.addTool(tool, dependencyArray);
    }

    public Tool addTool(Tool tool, Dependency ... dependencyArray) {
        this.addToMap(tool);
        for (Dependency dependency : dependencyArray) {
            dependency.iChildTool = tool;
            if (dependency.iParentToolSetName == null || dependency.iParentToolSetName.equals(this.fName)) {
                dependency.iParentToolSetName = this.fName;
                if (dependency.iReferenceToolName != null && dependency.iReferenceToolSetName == null) {
                    dependency.iReferenceToolSetName = this.fName;
                }
                this.addToParent(dependency);
                continue;
            }
            if (!this.fIsTemplate) {
                this.fDependencyList.add(dependency);
                continue;
            }
            this.fContributingToolSetMap.get(dependency.iParentToolSetName).addToParent(dependency);
        }
        return tool;
    }

    public Tool removeTool(String string, Dependency ... dependencyArray) {
        Tool tool = this.fToolMap.remove(string);
        block0: for (Dependency dependency : dependencyArray) {
            Tool tool2;
            if (dependency.iParentToolSetName != null && !dependency.iParentToolSetName.equals(this.fName)) continue;
            dependency.iParentToolSetName = this.fName;
            if (dependency.iReferenceToolName != null && dependency.iReferenceToolSetName == null) {
                dependency.iReferenceToolSetName = this.fName;
            }
            if ((tool2 = this.getTool(dependency.iParentToolName)) == null || !tool2.hasChildren()) continue;
            Iterator iterator = tool2.iChildList.iterator();
            while (iterator.hasNext()) {
                if (!string.equals(((Dependency)iterator.next()).iChildTool.iName)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return tool;
    }

    public void addSeparator(Dependency ... dependencyArray) {
        this.addTool(new ToolParameters(), dependencyArray);
    }

    public boolean configure(String string, Action action) {
        Tool tool = this.getTool(string);
        if (tool == null) {
            return false;
        }
        tool.configure(action);
        return true;
    }

    public static void resolveDependencies(TSToolSetContents tSToolSetContents, TSToolSetContents tSToolSetContents2) {
        tSToolSetContents.copyDependentReferences(tSToolSetContents2);
        tSToolSetContents2.copyDependentReferences(tSToolSetContents);
        tSToolSetContents.addDependents(tSToolSetContents2);
        tSToolSetContents2.addDependents(tSToolSetContents);
    }

    public void addDependent(TSToolSetContents tSToolSetContents, String string) {
        for (Dependency dependency : tSToolSetContents.fDependencyList) {
            if (!dependency.iParentToolSetName.equals(this.fName) || !string.equals(dependency.iChildTool.iName)) continue;
            this.addToParent(dependency);
        }
    }

    public Tool contributeTo(Tool tool) {
        Tool tool2 = tool;
        for (Dependency dependency : this.fDependencyList) {
            if (!dependency.iIsContextualContribution || !tool.getName().equals(dependency.iParentToolName) || !tool.getToolSetName().equals(dependency.iParentToolSetName)) continue;
            if (tool2 == tool) {
                tool2 = tool.clone();
            }
            tool2.addChild(dependency);
        }
        return tool2;
    }

    void addDescendants(Tool tool) {
        if (tool.hasChildren()) {
            for (Dependency dependency : tool.iChildList) {
                this.addDescendants(dependency.iChildTool);
            }
        } else {
            this.addToMap(tool);
        }
    }

    static TSToolSetContents createTemplate(Tool tool) {
        TSToolSetContents tSToolSetContents = new TSToolSetContents(tool.getToolSetName(), true);
        tSToolSetContents.addCopy(tool, null);
        return tSToolSetContents;
    }

    private void addCopy(Tool tool, Tool tool2) {
        ToolParameters toolParameters = new ToolParameters(tool.getName()).setToolSetName(tool.getToolSetName());
        if (tool2 == null) {
            this.addTool(toolParameters, new Dependency[0]);
        } else {
            this.addTool(toolParameters, new Dependency(tool2.getName(), tool2.getToolSetName()));
        }
        if (tool.hasChildren()) {
            for (Dependency dependency : tool.iChildList) {
                this.addCopy(dependency.iChildTool, tool);
            }
        }
    }

    public static TSToolSetContents readToolSetContents(Class<?> clazz, String string) {
        try {
            return new TSToolSetContents(SimpleDOMUtils.read((URL)clazz.getResource(string)));
        }
        catch (DataFormatException dataFormatException) {
            Log.logException((Exception)dataFormatException);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        return null;
    }

    private void addToMap(Tool tool) {
        if (tool.iName == null) {
            return;
        }
        if (this.fName.equals(tool.getToolSetName())) {
            this.fToolMap.put(tool.iName, tool);
        } else if (this.fIsTemplate) {
            TSToolSetContents tSToolSetContents = this.fContributingToolSetMap.get(tool.iToolSetName);
            if (tSToolSetContents == null) {
                tSToolSetContents = new TSToolSetContents(tool.iToolSetName, true);
                this.fContributingToolSetMap.put(tool.iToolSetName, tSToolSetContents);
            }
            tSToolSetContents.fToolMap.put(tool.iName, tool);
        } else if (!this.fName.equals(tool.getToolSetName())) {
            this.fToolMap.put(tool.iName, tool);
        }
    }

    public boolean deepEquals(TSToolSetContents tSToolSetContents) {
        if (!this.fName.equals(tSToolSetContents.fName) || this.getToolCount() != tSToolSetContents.getToolCount()) {
            return false;
        }
        for (Tool tool : this.fToolMap.values()) {
            Tool tool2 = tSToolSetContents.getTool(tool.getName());
            if (tool2 != null && tool.deepEquals(tool2)) continue;
            return false;
        }
        return true;
    }

    private Tool getTool(String string, String string2) {
        TSToolSetContents tSToolSetContents;
        if (string2 == null || string2.equals(this.fName)) {
            return this.fToolMap.get(string);
        }
        if (this.fContributingToolSetMap != null && (tSToolSetContents = this.fContributingToolSetMap.get(string2)) != null) {
            return tSToolSetContents.fToolMap.get(string);
        }
        return null;
    }

    private void addDependents(TSToolSetContents tSToolSetContents) {
        for (Dependency dependency : tSToolSetContents.fDependencyList) {
            if (dependency.iParentToolSetName != null && !dependency.iParentToolSetName.equals(this.fName)) continue;
            if (dependency.iIsContextualContribution) {
                Tool tool = this.getParentFor(dependency);
                if (tool == null) continue;
                tool.iHasContextContributors = true;
                continue;
            }
            this.addToParent(dependency);
        }
    }

    private void copyDependentReferences(TSToolSetContents tSToolSetContents) {
        if (!this.fHasDownwardDependencies) {
            return;
        }
        for (Tool tool : this.fToolMap.values()) {
            if (!tool.hasChildren()) continue;
            for (Dependency dependency : tool.iChildList) {
                Tool tool2 = dependency.iChildTool;
                if (!tSToolSetContents.fName.equals(tool2.iToolSetName)) continue;
                dependency.iChildTool = tSToolSetContents.getTool(tool2.iName);
            }
        }
    }

    private void addToParent(Dependency dependency) {
        Tool tool = this.getParentFor(dependency);
        if (tool == null) {
            Log.log((String)("Unable to find parent " + dependency.iParentToolName + " for " + dependency.iChildTool.getName() + "\n"));
        } else {
            tool.addChild(dependency);
        }
    }

    private Tool getParentFor(Dependency dependency) {
        return dependency.iParentToolName != null ? this.fToolMap.get(dependency.iParentToolName) : null;
    }

    private static void addKeywordsToList(List<String> list, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
    }

    private void gatherContributions() {
        for (Tool tool : this.fToolMap.values()) {
            if (!tool.hasChildren()) continue;
            for (Dependency dependency : tool.iChildList) {
                Tool tool2;
                TSToolSetContents tSToolSetContents;
                Tool tool3 = dependency.iChildTool;
                if (this.fName.equals(tool3.iToolSetName) || (tSToolSetContents = this.fContributingToolSetMap.get(tool3.iToolSetName)) == null || (tool2 = tSToolSetContents.getTool(tool3.iName)) == null || !tool2.hasChildren()) continue;
                tool3.iType = tool2.iType;
                if (tool3.iChildList == null) {
                    tool3.iChildList = new DependentList(tool2.iChildList);
                    continue;
                }
                tool3.iChildList.addAll(tool2.iChildList);
            }
        }
    }

    public TSToolSetContents(SimpleElement simpleElement) throws DataFormatException {
        this(simpleElement, null, null);
    }

    public TSToolSetContents(SimpleElement simpleElement, String string) throws DataFormatException {
        this(simpleElement, string, null);
    }

    public TSToolSetContents(SimpleElement simpleElement, KeyBindingManager keyBindingManager) throws DataFormatException {
        this(simpleElement, null, keyBindingManager);
    }

    public TSToolSetContents(SimpleElement simpleElement, String string, KeyBindingManager keyBindingManager) throws DataFormatException {
        Pair<CodeType, String> pair;
        Object object;
        String string2;
        SimpleElement simpleElement2;
        int n;
        assert (TOOLSET_TAG.equals(simpleElement.getTagName()));
        this.fName = XMLUtils.readIdAttribute(simpleElement, TOOLSET_TAG);
        this.fKeyBindingManager = keyBindingManager;
        this.fResourceBundle = XMLUtils.readResourceBundleAttribute(simpleElement);
        this.fIsTemplate = XMLUtils.readBooleanAttribute(simpleElement, TEMPLATE_ATTRIBUTE, false);
        Pair<CodeType, String> pair2 = TSToolSetContents.readCallInfo(simpleElement, CodeType.JAVA_METHOD, INIT_CALL_TAG);
        this.fInitCodeType = (CodeType)((Object)pair2.getFirst());
        this.fInitCode = (String)pair2.getSecond();
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(TOOL_TAG);
        int n2 = simpleNodeList.getLength();
        for (n = 0; n < n2; ++n) {
            simpleElement2 = (SimpleElement)simpleNodeList.item(n);
            string2 = XMLUtils.readIdAttribute(simpleElement2, TOOL_TAG);
            object = new ToolParameters(string2);
            ((ToolParameters)object).setToolSetName(this.fName);
            if (simpleElement2.hasAttribute(ACTION_ID_ATTRIBUTE)) {
                ((ToolParameters)object).setActionId(simpleElement2.getAttribute(ACTION_ID_ATTRIBUTE));
            }
            if (simpleElement2.hasAttribute(CONTEXT_ID_ATTRIBUTE)) {
                ((ToolParameters)object).setContextId(simpleElement2.getAttribute(CONTEXT_ID_ATTRIBUTE));
            }
            if (simpleElement2.hasAttribute("type")) {
                ((ToolParameters)object).setType(TSToolSetContents.readTypeAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(STYLE_ATTRIBUTE)) {
                ((ToolParameters)object).setStyle(TSToolSetContents.readStyleAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(HEADER_TYPE_ATTRIBUTE)) {
                ((ToolParameters)object).setHeaderType(TSToolSetContents.readHeaderTypeAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(ELIGIBILITY_ATTRIBUTE)) {
                ((ToolParameters)object).setIsQuickAcccessEligible(TSToolSetContents.readEligibilityAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(COMMON_ATTRIBUTE)) {
                ((ToolParameters)object).setIsCommon(TSToolSetContents.readCommonAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(KEEP_POPUPS_OPEN_ATTRIBUTE)) {
                ((ToolParameters)object).setKeepPopupsOpen(TSToolSetContents.readKeepPopupsOpenAttribute(simpleElement2));
            }
            if (simpleElement2.hasAttribute(ALPHABETIZE_ATTRIBUTE)) {
                ((ToolParameters)object).setAlphabetizeChildrein(TSToolSetContents.readAlphabetizeAttribute(simpleElement2));
            }
            pair = TSToolSetContents.readCallInfo(simpleElement2, CodeType.MATLAB, CALLBACK_TAG);
            ((ToolParameters)object).setCodeType((CodeType)((Object)pair.getFirst()));
            ((ToolParameters)object).setCode((String)pair.getSecond());
            ((ToolParameters)object).setIcon(TSToolSetContents.readIcons(simpleElement2, string));
            if (((ToolParameters)object).iType == ToolType.GALLERY) {
                ((ToolParameters)object).setGalleryOptions(TSToolSetContents.readGalleryOptions(simpleElement2));
            }
            this.addTool((ToolParameters)object, new Dependency[0]);
        }
        n2 = simpleNodeList.getLength();
        for (n = 0; n < n2; ++n) {
            Object object2;
            simpleElement2 = (SimpleElement)simpleNodeList.item(n);
            string2 = simpleElement2.getAttribute("id");
            object = this.getTool(string2);
            pair = simpleElement2.getChildElements();
            int n3 = pair.getLength();
            for (int i = 0; i < n3; ++i) {
                Object object3;
                SimpleElement simpleElement3 = (SimpleElement)pair.item(i);
                object2 = null;
                int n4 = 0;
                if (CHILD_TOOL_TAG.equals(simpleElement3.getTagName())) {
                    object3 = XMLUtils.readIdAttribute(simpleElement3, CHILD_TOOL_TAG);
                    String string3 = simpleElement3.getAttribute(TOOL_SET_ID_ATTRIBUTE);
                    if (string3 == null || string3.equals(this.fName)) {
                        object2 = this.getTool((String)object3);
                        if (object2 == null) {
                            Log.log((String)("Unable to find child " + (String)object3 + " parented to " + string2 + "\n"));
                        }
                    } else {
                        object2 = new Tool((String)object3, string3);
                    }
                    n4 = XMLUtils.readIntegerAttribute(simpleElement3, PRIORITY_ATTRIBUTE, n4);
                } else if (SEPARATOR_TAG.equals(simpleElement3.getTagName())) {
                    object2 = new Tool(null, this.fName);
                }
                if (object2 == null) continue;
                object3 = new Dependency(string2, this.fName);
                ((Dependency)object3).iPriority = n4;
                ((Dependency)object3).iChildTool = (Tool)object2;
                ((Tool)object).addChild((Dependency)object3);
            }
            SimpleNodeList simpleNodeList2 = simpleElement2.getChildrenByTagName(PARENT_TOOL_TAG);
            int n5 = simpleNodeList2.getLength();
            for (n3 = 0; n3 < n5; ++n3) {
                object2 = (SimpleElement)simpleNodeList2.item(n3);
                Dependency dependency = new Dependency(XMLUtils.readIdAttribute(object2, PARENT_TOOL_TAG), object2.hasAttribute(TOOL_SET_ID_ATTRIBUTE) ? object2.getAttribute(TOOL_SET_ID_ATTRIBUTE) : this.fName);
                dependency.iChildTool = (Tool)object;
                dependency.iReferenceToolName = object2.getAttribute(REFERENCE_ID_ATTRIBUTE);
                if (dependency.iReferenceToolName != null) {
                    dependency.iReferenceToolSetName = object2.hasAttribute(REFERENCE_TOOLSET_ID_ATTRIBUTE) ? object2.getAttribute(REFERENCE_TOOLSET_ID_ATTRIBUTE) : dependency.iParentToolSetName;
                }
                dependency.iIsContextualContribution = XMLUtils.readBooleanAttribute(object2, CONTEXTUAL_ATTRIBUTE, false);
                dependency.iReferencePosition = TSToolSetContents.readPositionAttribute(object2);
                dependency.iPriority = XMLUtils.readIntegerAttribute(object2, PRIORITY_ATTRIBUTE, dependency.iPriority);
                if (dependency.iParentToolSetName == null || dependency.iParentToolSetName.equals(this.fName)) {
                    this.addToParent(dependency);
                    continue;
                }
                this.fDependencyList.add(dependency);
            }
        }
        if (this.fIsTemplate) {
            this.fContributingToolSetMap = new HashMap<String, TSToolSetContents>();
            SimpleNodeList simpleNodeList3 = simpleElement.getChildrenByTagName(TOOLSET_TAG);
            int n6 = simpleNodeList3.getLength();
            for (n2 = 0; n2 < n6; ++n2) {
                string2 = (SimpleElement)simpleNodeList3.item(n2);
                object = new TSToolSetContents((SimpleElement)string2);
                this.fContributingToolSetMap.put(((TSToolSetContents)object).fName, (TSToolSetContents)object);
            }
            if (!this.fContributingToolSetMap.isEmpty()) {
                this.gatherContributions();
            }
        }
    }

    private static ToolType readTypeAttribute(SimpleElement simpleElement) throws DataFormatException {
        String string = simpleElement.getAttribute("type");
        for (ToolType toolType : ToolType.values()) {
            if (!toolType.name().toLowerCase(Locale.ENGLISH).equals(string)) continue;
            return toolType;
        }
        if (CATEGORY_VALUE.toLowerCase(Locale.ENGLISH).equals(string)) {
            return ToolType.GROUP;
        }
        throw new DataFormatException("Invalid attibute tool:type=" + string);
    }

    private static ListStyle readStyleAttribute(SimpleElement simpleElement) throws DataFormatException {
        ListStyle listStyle;
        String string = simpleElement.getAttribute(STYLE_ATTRIBUTE);
        if (MENU_STYLE_VALUE.equals(string)) {
            listStyle = null;
        } else if (TEXT_ONLY_STYLE_VALUE.equals(string) || TEXT_ONLY_ALIAS.equals(string)) {
            listStyle = ListStyle.TEXT_ONLY;
        } else if (WITH_ICON_STYLE_VALUE.equals(string) || WITH_ICON_ALIAS.equals(string)) {
            listStyle = ListStyle.ICON_TEXT;
        } else if (WITH_ONE_LINE_STYLE_VALUE.equals(string)) {
            listStyle = ListStyle.SINGLE_LINE_DESCRIPTION;
        } else if (WITH_DESCRIPTION_STYLE_VALUE.equals(string) || WITH_DESCRIPTION_ALIAS.equals(string)) {
            listStyle = ListStyle.ICON_TEXT_DESCRIPTION;
        } else if (WITH_LARGE_ICON_STYLE_VALUE.equals(string)) {
            listStyle = ListStyle.LARGE_ICON_TEXT;
        } else {
            throw new DataFormatException("Invalid attibute tool:style=" + string);
        }
        return listStyle;
    }

    private static HeaderType readHeaderTypeAttribute(SimpleElement simpleElement) throws DataFormatException {
        String string = simpleElement.getAttribute(HEADER_TYPE_ATTRIBUTE);
        if (string != null) {
            try {
                return HeaderType.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataFormatException("Invalid attibute parent_tool:header=" + string);
            }
        }
        return HeaderType.TITLE;
    }

    private static boolean readEligibilityAttribute(SimpleElement simpleElement) throws DataFormatException {
        return XMLUtils.readBooleanAttribute(simpleElement, ELIGIBILITY_ATTRIBUTE, true);
    }

    private static boolean readCommonAttribute(SimpleElement simpleElement) throws DataFormatException {
        return XMLUtils.readBooleanAttribute(simpleElement, COMMON_ATTRIBUTE, false);
    }

    private static boolean readKeepPopupsOpenAttribute(SimpleElement simpleElement) throws DataFormatException {
        return XMLUtils.readBooleanAttribute(simpleElement, KEEP_POPUPS_OPEN_ATTRIBUTE, false);
    }

    private static boolean readAlphabetizeAttribute(SimpleElement simpleElement) throws DataFormatException {
        return XMLUtils.readBooleanAttribute(simpleElement, ALPHABETIZE_ATTRIBUTE, false);
    }

    private static Pair<CodeType, String> readCallInfo(SimpleElement simpleElement, CodeType codeType, String string) throws DataFormatException {
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(string);
        CodeType codeType2 = null;
        String string2 = null;
        if (!simpleNodeList.isEmpty()) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.firstElement();
            string2 = simpleElement2.getText();
            codeType2 = null;
            String string3 = simpleElement2.getAttribute("type");
            if (string3 != null) {
                try {
                    codeType2 = CodeType.valueOf(string3.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DataFormatException("Invalid attibute " + string + ":" + "type" + "=" + string3);
                }
            }
            if (codeType2 == null) {
                codeType2 = codeType;
            }
        }
        return new Pair(codeType2, string2);
    }

    private static Icon readIcons(SimpleElement simpleElement, String string) throws DataFormatException {
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(ICON_TAG);
        ArrayList<ImageIcon> arrayList = new ArrayList<ImageIcon>(simpleNodeList.size());
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            ImageIcon imageIcon;
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            if (!simpleElement2.hasAttribute(FILENAME_ATTRIBUTE)) {
                throw new DataFormatException("Missing required attribute icon:filename");
            }
            String string2 = simpleElement2.getAttribute(FILENAME_ATTRIBUTE);
            if (!simpleElement2.hasAttribute(PATH_ATTRIBUTE)) {
                imageIcon = IconEnumerationUtils.getIcon((String)string2);
            } else {
                String string3 = simpleElement2.getAttribute(PATH_ATTRIBUTE);
                if (string != null) {
                    string3 = FileUtils.resolveRelativePath((String)string, (String)string3);
                    imageIcon = new ImageIcon(new File(string3, string2).getPath());
                } else {
                    if (!string3.endsWith("/")) {
                        string3 = string3 + "/";
                    }
                    imageIcon = IconEnumerationUtils.getIcon((String)string3, (String)string2);
                }
            }
            if (imageIcon == null) {
                Log.log((String)("Unable to find icon with filename: " + string2 + "\n"));
            }
            if (imageIcon == null) continue;
            arrayList.add(imageIcon);
        }
        return arrayList.isEmpty() ? null : (arrayList.size() == 1 ? (Icon)arrayList.get(0) : new IconSet(arrayList));
    }

    private static Position readPositionAttribute(SimpleElement simpleElement) throws DataFormatException {
        String string = simpleElement.getAttribute(POSITION_ATTRIBUTE);
        if (string != null) {
            try {
                return Position.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataFormatException("Invalid attibute parent_tool:position=" + string);
            }
        }
        return null;
    }

    private static GalleryOptions readGalleryOptions(SimpleElement simpleElement) throws DataFormatException {
        GalleryOptions galleryOptions = new GalleryOptions();
        galleryOptions.setRowCount(XMLUtils.readIntegerAttribute(simpleElement, ROWS_ATTRIBUTE, galleryOptions.getRowCount()));
        galleryOptions.setMinColumnCount(XMLUtils.readIntegerAttribute(simpleElement, MIN_COLUMNS_ATTRIBUTE, galleryOptions.getMinColumnCount()));
        galleryOptions.setMaxColumnCount(XMLUtils.readIntegerAttribute(simpleElement, MAX_COLUMNS_ATTRIBUTE, galleryOptions.getMaxColumnCount()));
        galleryOptions.setLabelLineCount(XMLUtils.readIntegerAttribute(simpleElement, LABEL_LINE_COUNT_ATTRIBUTE, galleryOptions.getLabelLineCount()));
        galleryOptions.setColumnWidth(XMLUtils.readFloatAttribute(simpleElement, COLUMN_WIDTH_ATTRIBUTE, galleryOptions.getColumnWidth()));
        galleryOptions.setPopupViews(TSToolSetContents.readPopupViewsAttribute(simpleElement, galleryOptions.getPopupViews()));
        galleryOptions.setInitialPopupView(TSToolSetContents.readInitialPopupAttribute(simpleElement, galleryOptions.getInitialPopupView()));
        galleryOptions.setEnableSearch(XMLUtils.readBooleanAttribute(simpleElement, ENABLE_SEARCH_ATTRIBUTE, galleryOptions.getEnableSearch()));
        galleryOptions.setMultiSelectPopup(XMLUtils.readBooleanAttribute(simpleElement, MULTI_SELECT_POPUP_ATTRIBUTE, galleryOptions.getMultiSelectPopup()));
        galleryOptions.setShowOnlyFavoritesOnToolstrip(XMLUtils.readBooleanAttribute(simpleElement, ONLY_FAVORITES_ATTRIBUTE, galleryOptions.showOnlyFavoritesOnToolstrip()));
        galleryOptions.setShowSelection(XMLUtils.readBooleanAttribute(simpleElement, SHOW_SELECTION_ATTRIBUTE, galleryOptions.showSelection()));
        galleryOptions.setSupportFavorites(XMLUtils.readBooleanAttribute(simpleElement, SUPPORT_FAVORITES_ATTRIBUTE, galleryOptions.supportFavorites()));
        return galleryOptions;
    }

    private static GalleryOptions.PopupViewType readInitialPopupAttribute(SimpleElement simpleElement, GalleryOptions.PopupViewType popupViewType) throws DataFormatException {
        String string = simpleElement.getAttribute(INITIAL_POPUP_ATTRIBUTE);
        if (string != null) {
            try {
                return GalleryOptions.PopupViewType.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataFormatException("Invalid attibute parent_tool:initial_popup=" + string);
            }
        }
        return popupViewType;
    }

    private static EnumSet<GalleryOptions.PopupViewType> readPopupViewsAttribute(SimpleElement simpleElement, EnumSet<GalleryOptions.PopupViewType> enumSet) throws DataFormatException {
        String string = simpleElement.getAttribute(POPUP_VIEWS_ATTRIBUTE);
        if (string != null) {
            try {
                EnumSet<GalleryOptions.PopupViewType> enumSet2 = EnumSet.noneOf(GalleryOptions.PopupViewType.class);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[]{}() ,");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    enumSet2.add(GalleryOptions.PopupViewType.valueOf(string2.toUpperCase(Locale.ENGLISH)));
                }
                return enumSet2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataFormatException("Invalid attibute parent_tool:popup_views=" + string);
            }
        }
        return enumSet;
    }

    public Element toXML(Document document) {
        Element element;
        Element element2 = document.createElement(TOOLSET_TAG);
        element2.setAttribute("id", this.fName);
        element2.setAttribute(TEMPLATE_ATTRIBUTE, this.fIsTemplate ? "true" : "false");
        for (Tool object : this.fToolMap.values()) {
            element = document.createElement(TOOL_TAG);
            element.setAttribute("id", object.iName);
            element.setAttribute(TOOL_SET_ID_ATTRIBUTE, object.iToolSetName);
            if (object.iType != ToolType.BUTTON) {
                element.setAttribute("type", object.iType.name().toLowerCase(Locale.ENGLISH));
            }
            if (object.iStyle != null) {
                TSToolSetContents.writeStyleAttribute(element, object.iStyle);
            }
            if (object.iHeaderType != HeaderType.TITLE) {
                element.setAttribute(HEADER_TYPE_ATTRIBUTE, object.iHeaderType.name().toLowerCase(Locale.ENGLISH));
            }
            if (object.iGalleryOptions != null) {
                TSToolSetContents.writeGalleryOptions(element, object.iGalleryOptions);
            }
            if (object.iActionId != null) {
                element.setAttribute(ACTION_ID_ATTRIBUTE, object.iActionId);
            }
            if (object.iContextId != null) {
                element.setAttribute(CONTEXT_ID_ATTRIBUTE, object.iContextId);
            }
            if (!object.isQuickAccessEligible()) {
                element.setAttribute(ELIGIBILITY_ATTRIBUTE, "false");
            }
            if (object.iIsCommon) {
                element.setAttribute(COMMON_ATTRIBUTE, "true");
            }
            if (object.iKeepPopupsOpen) {
                element.setAttribute(KEEP_POPUPS_OPEN_ATTRIBUTE, "true");
            }
            if (object.iAlphabetizeChildren) {
                element.setAttribute(ALPHABETIZE_ATTRIBUTE, "true");
            }
            if (object.iCodeType != null && object.iCode != null) {
                TSToolSetContents.writeCallback(document, element, object.iCodeType, object.iCode);
            }
            if (object.hasChildren()) {
                for (Dependency dependency : object.iChildList) {
                    if (dependency.iChildTool == null) continue;
                    if (dependency.iChildTool.iName == null) {
                        element.appendChild(document.createElement(SEPARATOR_TAG));
                        continue;
                    }
                    Element element3 = document.createElement(CHILD_TOOL_TAG);
                    element3.setAttribute("id", dependency.iChildTool.iName);
                    element3.setAttribute(TOOL_SET_ID_ATTRIBUTE, dependency.iChildTool.iToolSetName);
                    element.appendChild(element3);
                }
            }
            element2.appendChild(element);
        }
        if (this.fContributingToolSetMap != null) {
            for (TSToolSetContents tSToolSetContents : this.fContributingToolSetMap.values()) {
                element = tSToolSetContents.toXML(document);
                element2.appendChild(element);
            }
        }
        return element2;
    }

    private static void writeStyleAttribute(Element element, ListStyle listStyle) {
        String string;
        switch (listStyle) {
            case TEXT_ONLY: {
                string = TEXT_ONLY_STYLE_VALUE;
                break;
            }
            case ICON_TEXT: {
                string = WITH_ICON_STYLE_VALUE;
                break;
            }
            case SINGLE_LINE_DESCRIPTION: {
                string = WITH_ONE_LINE_STYLE_VALUE;
                break;
            }
            default: {
                string = WITH_DESCRIPTION_STYLE_VALUE;
            }
        }
        element.setAttribute(STYLE_ATTRIBUTE, string);
    }

    private static void writeGalleryOptions(Element element, GalleryOptions galleryOptions) {
        GalleryOptions galleryOptions2 = new GalleryOptions();
        if (galleryOptions.getRowCount() != galleryOptions2.getRowCount()) {
            element.setAttribute(ROWS_ATTRIBUTE, Integer.toString(galleryOptions.getRowCount()));
        }
        if (galleryOptions.getMinColumnCount() != galleryOptions2.getMinColumnCount()) {
            element.setAttribute(MIN_COLUMNS_ATTRIBUTE, Integer.toString(galleryOptions.getMinColumnCount()));
        }
        if (galleryOptions.getMaxColumnCount() != galleryOptions2.getMaxColumnCount()) {
            element.setAttribute(MAX_COLUMNS_ATTRIBUTE, Integer.toString(galleryOptions.getMaxColumnCount()));
        }
        if (galleryOptions.getLabelLineCount() != galleryOptions2.getLabelLineCount()) {
            element.setAttribute(LABEL_LINE_COUNT_ATTRIBUTE, Integer.toString(galleryOptions.getLabelLineCount()));
        }
        if (galleryOptions.getColumnWidth() != galleryOptions2.getColumnWidth()) {
            element.setAttribute(COLUMN_WIDTH_ATTRIBUTE, Float.toString(galleryOptions.getColumnWidth()));
        }
        if (!galleryOptions.getPopupViews().equals(galleryOptions2.getPopupViews())) {
            element.setAttribute(POPUP_VIEWS_ATTRIBUTE, galleryOptions.getPopupViews().toString());
        }
        if (galleryOptions.getInitialPopupView() != galleryOptions2.getInitialPopupView()) {
            element.setAttribute(INITIAL_POPUP_ATTRIBUTE, galleryOptions.getInitialPopupView().name().toLowerCase(Locale.ENGLISH));
        }
        if (galleryOptions.getEnableSearch() != galleryOptions2.getEnableSearch()) {
            element.setAttribute(ENABLE_SEARCH_ATTRIBUTE, galleryOptions.getEnableSearch() ? "true" : "false");
        }
        if (galleryOptions.getMultiSelectPopup() != galleryOptions2.getMultiSelectPopup()) {
            element.setAttribute(MULTI_SELECT_POPUP_ATTRIBUTE, galleryOptions.getMultiSelectPopup() ? "true" : "false");
        }
        if (galleryOptions.showOnlyFavoritesOnToolstrip() != galleryOptions2.showOnlyFavoritesOnToolstrip()) {
            element.setAttribute(ONLY_FAVORITES_ATTRIBUTE, galleryOptions.showOnlyFavoritesOnToolstrip() ? "true" : "false");
        }
        if (galleryOptions.showSelection() != galleryOptions2.showSelection()) {
            element.setAttribute(SHOW_SELECTION_ATTRIBUTE, galleryOptions.showSelection() ? "true" : "false");
        }
        if (galleryOptions.supportFavorites() != galleryOptions2.supportFavorites()) {
            element.setAttribute(SUPPORT_FAVORITES_ATTRIBUTE, galleryOptions.supportFavorites() ? "true" : "false");
        }
    }

    private static void writeCallback(Document document, Element element, CodeType codeType, String string) {
        Element element2 = document.createElement(CALLBACK_TAG);
        if (codeType != CodeType.MATLAB) {
            element2.setAttribute("type", codeType.name().toLowerCase(Locale.ENGLISH));
        }
        element2.setTextContent(string);
        element.appendChild(element2);
    }

    private class DependentList
    extends ArrayList<Dependency> {
        DependentList() {
        }

        DependentList(DependentList dependentList) {
            super(dependentList);
        }

        void addWithPriority(Dependency dependency) {
            int n;
            for (n = this.size(); n > 0 && dependency.iPriority > ((Dependency)this.get(n - 1)).iPriority; --n) {
            }
            this.add(n, dependency);
        }
    }

    public static class Dependency {
        private final String iParentToolName;
        private String iParentToolSetName;
        private boolean iIsContextualContribution;
        private String iReferenceToolName;
        private String iReferenceToolSetName;
        private Position iReferencePosition;
        private int iReferenceOffset;
        private int iPriority;
        private Tool iChildTool;

        public Dependency(String string) {
            this(string, null);
        }

        public Dependency(String string, String string2) {
            this.iParentToolName = string;
            this.iParentToolSetName = string2;
        }

        public Dependency setIsContextualContribution(boolean bl) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iIsContextualContribution = bl;
            return this;
        }

        public Dependency setReferenceToolName(String string) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iReferenceToolName = string;
            return this;
        }

        public Dependency setReferenceToolSetName(String string) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iReferenceToolSetName = string;
            return this;
        }

        public Dependency setReferencePosition(Position position) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iReferencePosition = position;
            return this;
        }

        public Dependency setReferenceOffset(int n) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iReferenceOffset = n;
            return this;
        }

        public Dependency setPriority(int n) {
            assert (this.iChildTool == null) : "Can't change Dependency fields once the Tool has been created";
            this.iPriority = n;
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)object;
            return this.iParentToolName.equals(dependency.iParentToolName) && this.iParentToolSetName == dependency.iParentToolSetName || this.iParentToolSetName != null && this.iParentToolSetName.equals(dependency.iParentToolSetName);
        }

        public int hashCode() {
            return (this.iParentToolName == null ? 0 : this.iParentToolName.hashCode() * 31) + (this.iParentToolSetName == null ? 0 : this.iParentToolSetName.hashCode());
        }
    }

    public static class ToolParameters {
        private final String iName;
        private String iToolSetName;
        private ToolType iType = ToolType.BUTTON;
        private ListStyle iStyle;
        private HeaderType iHeaderType = HeaderType.TITLE;
        private GalleryOptions iGalleryOptions;
        private Icon iIcon;
        private String iLabel;
        private String iDescription;
        private List<String> iKeywordList;
        private String iActionId;
        private String iContextId;
        private boolean iIsQuickAccessEligible = true;
        private boolean iIsCommon;
        private boolean iKeepPopupsOpen;
        private boolean iAlphabetizeChildren;
        private CodeType iCodeType;
        private String iCode;

        public ToolParameters() {
            this.iName = null;
            this.iType = ToolType.SEPARATOR;
            this.iIsQuickAccessEligible = false;
        }

        public ToolParameters(String string) {
            this.iName = string;
        }

        public ToolParameters setToolSetName(String string) {
            this.iToolSetName = string;
            return this;
        }

        public ToolParameters setType(ToolType toolType) {
            this.iType = toolType;
            if (toolType == ToolType.LABEL || toolType == ToolType.SEPARATOR || toolType == ToolType.GROUP || toolType == ToolType.TEXT_AREA || toolType == ToolType.GALLERY) {
                this.iIsQuickAccessEligible = false;
            }
            return this;
        }

        public ToolParameters setStyle(ListStyle listStyle) {
            this.iStyle = listStyle;
            return this;
        }

        public ToolParameters setHeaderType(HeaderType headerType) {
            this.iHeaderType = headerType;
            return this;
        }

        public ToolParameters setGalleryOptions(GalleryOptions galleryOptions) {
            this.iGalleryOptions = galleryOptions;
            return this;
        }

        public ToolParameters setIcon(Icon icon) {
            this.iIcon = icon;
            return this;
        }

        public ToolParameters setLabel(String string) {
            this.iLabel = string;
            return this;
        }

        public ToolParameters setDescription(String string) {
            this.iDescription = string;
            return this;
        }

        public ToolParameters setKeywords(List<String> list) {
            this.iKeywordList = list;
            return this;
        }

        public ToolParameters setActionId(String string) {
            this.iActionId = string;
            return this;
        }

        public ToolParameters setContextId(String string) {
            this.iContextId = string;
            return this;
        }

        public ToolParameters setIsQuickAcccessEligible(boolean bl) {
            this.iIsQuickAccessEligible = bl;
            return this;
        }

        public ToolParameters setIsCommon(boolean bl) {
            this.iIsCommon = bl;
            return this;
        }

        public ToolParameters setKeepPopupsOpen(boolean bl) {
            this.iKeepPopupsOpen = bl;
            return this;
        }

        public ToolParameters setAlphabetizeChildrein(boolean bl) {
            this.iAlphabetizeChildren = bl;
            return this;
        }

        public ToolParameters setCodeType(CodeType codeType) {
            this.iCodeType = codeType;
            return this;
        }

        public ToolParameters setCode(String string) {
            this.iCode = string;
            return this;
        }
    }

    public class Tool {
        private final String iName;
        private final String iToolSetName;
        private ToolType iType;
        private final ListStyle iStyle;
        private final HeaderType iHeaderType;
        private final GalleryOptions iGalleryOptions;
        private final Icon iIcon;
        private final String iLabel;
        private final String iDescription;
        private final List<String> iKeywordList;
        private final String iActionId;
        private final String iContextId;
        private final boolean iIsQuickAccessEligible;
        private final boolean iIsCommon;
        private final boolean iKeepPopupsOpen;
        private final boolean iAlphabetizeChildren;
        private final CodeType iCodeType;
        private final String iCode;
        private DependentList iChildList;
        private boolean iHasContextContributors;
        private int iLastContributionIndex = -1;

        public String getName() {
            return this.iName;
        }

        public String getToolSetName() {
            return this.iToolSetName;
        }

        public ToolType getType() {
            return this.iType;
        }

        public ListStyle getStyle() {
            return this.iStyle;
        }

        public HeaderType getHeaderType() {
            return this.iHeaderType;
        }

        public GalleryOptions getGalleryOptions() {
            return this.iGalleryOptions;
        }

        public Icon getIcon() {
            ActionData actionData;
            if (this.iIcon == null && (actionData = this.getActionData()) != null) {
                return actionData.getIcon();
            }
            return this.iIcon;
        }

        public String getLabel() {
            return this.getLabel(true);
        }

        public String getLabelIfAvailable() {
            return this.getLabel(false);
        }

        private String getLabel(boolean bl) {
            ActionData actionData;
            String string = this.iLabel;
            if (string == null && TSToolSetContents.this.fResourceBundle != null) {
                try {
                    string = XMLUtils.getString(TSToolSetContents.this.fResourceBundle, "Tool", this.iName, "Label");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (string == null && (actionData = this.getActionData()) != null) {
                string = actionData.getLabel();
            }
            if (bl) assert (string != null) : "Missing label for tool " + this.iName + ", toolset " + this.iToolSetName;
            return string;
        }

        public String getDescription() {
            ActionData actionData;
            String string = this.iDescription;
            if (string == null && this.iType.hasDescription() && TSToolSetContents.this.fResourceBundle != null) {
                try {
                    string = XMLUtils.getString(TSToolSetContents.this.fResourceBundle, "Tool", this.iName, "Description");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (string == null && (actionData = this.getActionData()) != null) {
                string = actionData.getDescription();
            }
            return string;
        }

        public List<String> getKeywords() {
            if (this.iKeywordList != null) {
                return Collections.unmodifiableList(this.iKeywordList);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (TSToolSetContents.this.fResourceBundle != null) {
                try {
                    TSToolSetContents.addKeywordsToList(arrayList, XMLUtils.getString(TSToolSetContents.this.fResourceBundle, "Tool", this.iName, "Keywords"));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return arrayList;
        }

        public boolean isQuickAccessEligible() {
            return this.iIsQuickAccessEligible && (!this.iType.requiresIconForQuickAccess() || this.iIcon != null);
        }

        public boolean isCommon() {
            return this.iIsCommon;
        }

        public boolean keepPopupsOpen() {
            return this.iKeepPopupsOpen;
        }

        public boolean alphagetizeChildren() {
            return this.iAlphabetizeChildren;
        }

        public CodeType getCodeType() {
            return this.iCodeType;
        }

        public String getCode() {
            return this.iCode;
        }

        boolean hasContextContributors() {
            return this.iHasContextContributors;
        }

        public boolean hasChildren() {
            return this.iChildList != null && !this.iChildList.isEmpty();
        }

        public List<Tool> getChildren() {
            ArrayList<Tool> arrayList = new ArrayList<Tool>(this.iChildList == null ? 0 : this.iChildList.size());
            if (this.iChildList != null) {
                for (Dependency dependency : this.iChildList) {
                    arrayList.add(dependency.iChildTool);
                }
            }
            return arrayList;
        }

        private Tool(String string, String string2, ToolType toolType, ListStyle listStyle, HeaderType headerType, GalleryOptions galleryOptions, Icon icon, String string3, String string4, List<String> list, String string5, String string6, boolean bl, boolean bl2, boolean bl3, boolean bl4, CodeType codeType, String string7) {
            this.iName = string;
            this.iToolSetName = string2;
            this.iType = toolType;
            this.iStyle = listStyle;
            this.iHeaderType = headerType;
            this.iGalleryOptions = galleryOptions;
            this.iIcon = icon;
            this.iLabel = string3;
            this.iDescription = string4;
            this.iKeywordList = list;
            this.iActionId = string5;
            this.iContextId = string6;
            this.iIsQuickAccessEligible = bl;
            this.iIsCommon = bl2;
            this.iKeepPopupsOpen = bl3;
            this.iAlphabetizeChildren = bl4;
            this.iCodeType = codeType;
            this.iCode = string7;
        }

        private Tool(String string, String string2) {
            this.iName = string;
            this.iToolSetName = string2;
            this.iType = string == null ? ToolType.SEPARATOR : ToolType.BUTTON;
            this.iStyle = null;
            this.iHeaderType = null;
            this.iGalleryOptions = null;
            this.iIcon = null;
            this.iLabel = null;
            this.iDescription = null;
            this.iKeywordList = null;
            this.iActionId = null;
            this.iContextId = null;
            this.iIsQuickAccessEligible = false;
            this.iAlphabetizeChildren = false;
            this.iIsCommon = false;
            this.iKeepPopupsOpen = false;
            this.iCodeType = null;
            this.iCode = null;
        }

        private Tool(Tool tool) {
            this.iName = tool.iName;
            this.iToolSetName = tool.iToolSetName;
            this.iType = tool.iType;
            this.iStyle = tool.iStyle;
            this.iHeaderType = tool.iHeaderType;
            this.iGalleryOptions = tool.iGalleryOptions;
            this.iIcon = tool.iIcon;
            this.iLabel = tool.iLabel;
            this.iDescription = tool.iDescription;
            this.iKeywordList = tool.iKeywordList;
            this.iActionId = tool.iActionId;
            this.iContextId = tool.iContextId;
            this.iIsQuickAccessEligible = tool.iIsQuickAccessEligible;
            this.iIsCommon = tool.iIsCommon;
            this.iKeepPopupsOpen = tool.iKeepPopupsOpen;
            this.iAlphabetizeChildren = tool.iAlphabetizeChildren;
            this.iCodeType = tool.iCodeType;
            this.iCode = tool.iCode;
            this.iChildList = tool.iChildList == null ? null : new DependentList(tool.iChildList);
            this.iHasContextContributors = tool.iHasContextContributors;
        }

        public Tool clone() {
            return new Tool(this);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Tool)) {
                return false;
            }
            Tool tool = (Tool)object;
            return (this.iName == tool.iName || this.iName != null && this.iName.equals(tool.iName)) && (this.iToolSetName == tool.iToolSetName || this.iToolSetName != null && this.iToolSetName.equals(tool.iToolSetName));
        }

        public int hashCode() {
            return (this.iName == null ? 0 : this.iName.hashCode() * 31) + (this.iToolSetName == null ? 0 : this.iToolSetName.hashCode());
        }

        private boolean deepEquals(Tool tool) {
            if (!this.equals(tool) || this.iToolSetName == tool.iToolSetName && (this.iType != tool.iType || this.iStyle != tool.iStyle)) {
                return false;
            }
            if (this.hasChildren() != tool.hasChildren()) {
                return false;
            }
            if (this.hasChildren()) {
                if (this.iChildList.size() != tool.iChildList.size()) {
                    return false;
                }
                for (int i = 0; i < this.iChildList.size(); ++i) {
                    Dependency dependency = (Dependency)this.iChildList.get(i);
                    Dependency dependency2 = (Dependency)tool.iChildList.get(i);
                    if (dependency.iChildTool.deepEquals(dependency2.iChildTool)) continue;
                    return false;
                }
            }
            return true;
        }

        public void configure(Action action) {
            action.putValue("Name", this.getLabel());
            action.putValue("buttonIcon", this.getIcon());
            action.putValue("SmallIcon", this.getIcon());
            action.putValue("ShortDescription", this.getDescription());
            action.putValue(TSToolSetContents.SHORTCUT_FREE_DESCRIPTION, this.getDescription());
            if (this.iActionId != null && TSToolSetContents.this.fKeyBindingManager != null && action instanceof ExtendedAction) {
                action.putValue("ActionCommandKey", this.iActionId);
                action.putValue("ActionContext", this.iContextId);
                TSToolSetContents.this.fKeyBindingManager.addListener(this.iActionId, this.iContextId, (KeyBindingManagerListener)action);
            }
        }

        private ActionData getActionData() {
            return TSToolSetContents.this.fKeyBindingManager == null || this.iActionId == null ? null : TSToolSetContents.this.fKeyBindingManager.getActionData(this.iActionId);
        }

        private void addChild(Dependency dependency) {
            if (this.iChildList == null) {
                this.iChildList = new DependentList();
            } else {
                for (Object object : this.iChildList) {
                    if (dependency.iChildTool.getName() == null || !dependency.iChildTool.equals(((Dependency)object).iChildTool)) continue;
                    return;
                }
            }
            if (!TSToolSetContents.this.fName.equals(((Dependency)dependency).iChildTool.iToolSetName)) {
                TSToolSetContents.this.fHasDownwardDependencies = true;
            }
            if (this.iAlphabetizeChildren) {
                String string;
                int n;
                String string2 = dependency.iChildTool.getLabel().toLowerCase(Locale.getDefault());
                for (n = this.iChildList.size(); n > 0 && string2.compareTo((string = ((Dependency)this.iChildList.get(n - 1)).iChildTool.getLabel().toLowerCase(Locale.getDefault())).toLowerCase(Locale.getDefault())) < 0; --n) {
                }
                this.iChildList.add(n, dependency);
            } else {
                Object object;
                int n = -1;
                object = dependency.iReferencePosition;
                if (object == Position.BEGINNING) {
                    n = dependency.iReferenceOffset;
                } else if (object == Position.END) {
                    n = this.iChildList.size() + dependency.iReferenceOffset;
                } else if (dependency.iReferenceToolName != null && dependency.iReferenceToolSetName != null) {
                    int n2;
                    Tool tool = null;
                    for (n2 = 0; n2 < this.iChildList.size(); ++n2) {
                        tool = ((Dependency)this.iChildList.get(n2)).iChildTool;
                        if (dependency.iReferenceToolName.equals(tool.getName()) && dependency.iReferenceToolSetName.equals(tool.getToolSetName())) break;
                        tool = null;
                    }
                    if (tool != null) {
                        n2 += dependency.iReferenceOffset;
                        n = object == Position.BEFORE ? n2 : n2 + 1;
                    }
                }
                if (n != -1) {
                    this.iChildList.add(n, dependency);
                    this.iLastContributionIndex = n;
                } else if (this.iLastContributionIndex != -1 && this.iLastContributionIndex < this.iChildList.size()) {
                    this.iChildList.add(++this.iLastContributionIndex, dependency);
                } else {
                    this.iChildList.addWithPriority(dependency);
                }
            }
        }

        public void matchTemplate(TSToolSetContents tSToolSetContents, Map<String, TSToolSetContents> map) {
            Tool tool;
            DependentList dependentList = new DependentList();
            Tool tool2 = tSToolSetContents.getTool(this.iName, this.iToolSetName);
            if (tool2 != null && tool2.hasChildren()) {
                if (this.iChildList == null) {
                    this.iChildList = new DependentList();
                }
                for (Dependency dependency : tool2.iChildList) {
                    Object object;
                    Object object2;
                    tool = dependency.iChildTool;
                    boolean bl = false;
                    Object object3 = this.iChildList.iterator();
                    while (object3.hasNext()) {
                        object2 = (Dependency)object3.next();
                        object = ((Dependency)object2).iChildTool;
                        if (!tool.equals(object)) continue;
                        object3.remove();
                        if (((Tool)object).hasChildren() || tool.hasChildren()) {
                            ((Tool)object).matchTemplate(tSToolSetContents, map);
                        }
                        dependentList.add(object2);
                        bl = true;
                    }
                    if (bl || (object3 = map.get(tool.iToolSetName)) == null || (object2 = ((TSToolSetContents)object3).getTool(tool.iName)) == null) continue;
                    object = new Dependency(dependency.iParentToolName, dependency.iParentToolSetName);
                    ((Dependency)object).iChildTool = (Tool)object2;
                    dependentList.add(object);
                }
            }
            if (this.iChildList != null) {
                for (Dependency dependency : this.iChildList) {
                    tool = dependency.iChildTool;
                    if (tool.getType() != ToolType.GROUP && tSToolSetContents.getTool(tool.iName, tool.iToolSetName) != null) continue;
                    dependentList.add(dependency);
                }
            }
            if ((tool2.iAlphabetizeChildren || this.iAlphabetizeChildren) && dependentList.size() > 1) {
                Collections.sort(dependentList, new Comparator<Dependency>(){

                    @Override
                    public int compare(Dependency dependency, Dependency dependency2) {
                        String string = dependency.iChildTool.getLabel().toLowerCase(Locale.getDefault());
                        String string2 = dependency2.iChildTool.getLabel().toLowerCase(Locale.getDefault());
                        return string.compareTo(string2);
                    }
                });
            }
            this.iChildList = dependentList.isEmpty() ? null : dependentList;
        }
    }

    public static enum HeaderType {
        TITLE,
        SEPARATOR,
        NONE;

    }

    public static enum CodeType {
        JAVA_ACTION,
        JAVA_METHOD,
        MATLAB;

    }

    public static enum Position {
        BEFORE,
        AFTER,
        BEGINNING,
        END;

    }

    public static enum ToolType {
        BUTTON,
        TOGGLE_BUTTON,
        RADIO_BUTTON,
        CHECK_BOX,
        DROP_DOWN(true, true, true),
        SPLIT_BUTTON(true, true, true),
        COMBO_BOX(true, true, false),
        SPINNER(true, false, false),
        TEXT_FIELD(true, false, false),
        FORMATTED_TEXT(true, false, false),
        TEXT_AREA(true, false, false),
        LABEL(false, false, false),
        GALLERY(true, true, false),
        GROUP(false, true, false),
        SEPARATOR(false, false, false),
        CUSTOM;

        private final boolean iHasDescription;
        private final boolean iCanHaveChildren;
        private final boolean iRequiresIconForQuickAccess;

        private ToolType() {
            this(true, false, true);
        }

        private ToolType(boolean bl, boolean bl2, boolean bl3) {
            this.iHasDescription = bl;
            this.iCanHaveChildren = bl2;
            this.iRequiresIconForQuickAccess = bl3;
        }

        boolean hasDescription() {
            return this.iHasDescription;
        }

        boolean canHaveChildren() {
            return this.iCanHaveChildren;
        }

        boolean requiresIconForQuickAccess() {
            return this.iRequiresIconForQuickAccess;
        }
    }
}

