/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.desktop.client.Client;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWrapper;
import com.mathworks.toolstrip.impl.ToolstripTabContentPanel;
import com.mathworks.toolstrip.plaf.DropDownButtonUI;
import com.mathworks.toolstrip.plaf.IconifiedSectionButton;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.util.StringUtils;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

public class IconifiedSectionButtonUI
extends DropDownButtonUI {
    public static final IconifiedSectionButtonUI DROP_DOWN_BUTTON_UI = new IconifiedSectionButtonUI();

    public static IconifiedSectionButtonUI createUI(JComponent jComponent) {
        return DROP_DOWN_BUTTON_UI;
    }

    @Override
    protected void paintUnArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        int n = rectangle.x + rectangle.width - 1;
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        LAFUtil.drawSectionHeaderBackground(graphics2D, rectangle);
        LAFUtil.drawSectionBorder(graphics2D, abstractButton, n, n2, n3);
    }

    @Override
    protected void paintPressed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = IconifiedSectionButtonUI.getButtonRect(rectangle, n, n2);
        LAFUtil.drawButtonPressedRect(graphics2D, rectangularShape, this.fTheme);
    }

    @Override
    protected void paintArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        LAFUtil.drawSectionHeaderBackground(graphics2D, rectangle);
        int n = rectangle.width;
        int n2 = rectangle.height;
        RectangularShape rectangularShape = IconifiedSectionButtonUI.getButtonRect(rectangle, n, n2);
        graphics2D.setColor(this.fTheme.getArmedBorder());
        graphics2D.draw(rectangularShape);
    }

    private static RectangularShape getButtonRect(Rectangle rectangle, int n, int n2) {
        return new Rectangle2D.Float(rectangle.x, rectangle.y, n - 1, n2 - 1);
    }

    @Override
    protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle, boolean bl) {
        String string = abstractButton.getText();
        graphics2D.setFont(this.fTheme.getSectionTitleFont());
        graphics2D.setColor(this.fTheme.getSectionTitleColor());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        List list = StringUtils.split((String)string, (String)"\n");
        int n = list.size() * fontMetrics.getHeight();
        int n2 = (rectangle.height - n) / 2;
        for (String string2 : list) {
            LAFUtil.drawString(graphics2D, string2, (rectangle.width - fontMetrics.stringWidth(string2)) / 2, n2 + fontMetrics.getAscent());
            n2 += fontMetrics.getHeight();
        }
        ImageIcon imageIcon = ToolstripIcons.COLLAPSE_SECTION_DOWN.getIcon();
        imageIcon.paintIcon(abstractButton, graphics2D, (rectangle.width - imageIcon.getIconWidth()) / 2, rectangle.height - 25);
    }

    @Override
    protected ToolstripButtonUI.ToolstripButtonListener newToolstripButtonListener(AbstractButton abstractButton) {
        return new IconifiedSectionButtonListener(abstractButton);
    }

    class IconifiedSectionButtonListener
    extends DropDownButtonUI.DropDownToolstripButtonListener {
        IconifiedSectionButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ToolstripTab toolstripTab;
            int n;
            super.stateChanged(changeEvent);
            IconifiedSectionButton iconifiedSectionButton = (IconifiedSectionButton)((Object)this.fButton);
            ToolstripSectionComponentWrapper toolstripSectionComponentWrapper = (ToolstripSectionComponentWrapper)iconifiedSectionButton.getParent();
            if (toolstripSectionComponentWrapper != null && (n = (toolstripTab = toolstripSectionComponentWrapper.getTab()).getModel().indexOf((Client)iconifiedSectionButton.getSection())) > 0) {
                ToolstripSectionComponentWrapper toolstripSectionComponentWrapper2 = ((ToolstripTabContentPanel)toolstripTab.getComponent()).getSectionComponent(n - 1);
                JComponent jComponent = toolstripSectionComponentWrapper2.getSectionComponent();
                ButtonModel buttonModel = this.fButton.getModel();
                jComponent.putClientProperty("show.section.border", !buttonModel.isArmed() && !buttonModel.isPressed() && !buttonModel.isSelected());
                jComponent.repaint();
            }
        }
    }
}

