/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures;

import com.mathworks.toolbox.javabuilder.webfigures.WebFigure;
import java.util.HashMap;
import java.util.Map;

public class WebFigureRenderParameters {
    private WebFigure webFigure;
    private double rotation;
    private double elevation;
    private int width;
    private int height;
    private String imageFormat = "png";
    private int cropLeft = 0;
    private int cropRight = 0;
    private int cropTop = 0;
    private int cropBottom = 0;

    public WebFigureRenderParameters(WebFigure webFigure) {
        this.webFigure = webFigure;
        this.rotation = webFigure.getAzimuth();
        this.elevation = webFigure.getElevation();
        this.width = webFigure.getWidth();
        this.height = webFigure.getHeight();
    }

    public WebFigureRenderParameters(WebFigureRenderParameters webFigureRenderParameters) {
        this.webFigure = webFigureRenderParameters.webFigure;
        this.rotation = webFigureRenderParameters.rotation;
        this.elevation = webFigureRenderParameters.elevation;
        this.width = webFigureRenderParameters.width;
        this.height = webFigureRenderParameters.height;
        this.imageFormat = webFigureRenderParameters.imageFormat;
        this.cropLeft = webFigureRenderParameters.cropLeft;
        this.cropBottom = webFigureRenderParameters.cropBottom;
        this.cropRight = webFigureRenderParameters.cropRight;
        this.cropTop = webFigureRenderParameters.cropTop;
    }

    public WebFigure getWebFigure() {
        return this.webFigure;
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getElevation() {
        return this.elevation;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public int getCropLeft() {
        return this.cropLeft;
    }

    public int getCropRight() {
        return this.cropRight;
    }

    public int getCropTop() {
        return this.cropTop;
    }

    public int getCropBottom() {
        return this.cropBottom;
    }

    public void setWebFigure(WebFigure webFigure) {
        this.webFigure = webFigure;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public void setCropLeft(int n) {
        this.cropLeft = n;
    }

    public void setCropRight(int n) {
        this.cropRight = n;
    }

    public void setCropTop(int n) {
        this.cropTop = n;
    }

    public void setCropBottom(int n) {
        this.cropBottom = n;
    }

    public String toString() {
        return "WebFigureRenderParameters( webFigure = " + this.webFigure + ", rotation = " + this.rotation + ", elevation = " + this.elevation + ", width = " + this.width + ", height = " + this.height + ", imageFormat = " + this.imageFormat + ", cropLeft = " + this.cropLeft + ", cropRight = " + this.cropRight + ", cropTop = " + this.cropTop + ", cropBottom = " + this.cropBottom + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WebFigureRenderParameters webFigureRenderParameters = (WebFigureRenderParameters)object;
        if (this.cropBottom != webFigureRenderParameters.cropBottom) {
            return false;
        }
        if (this.cropLeft != webFigureRenderParameters.cropLeft) {
            return false;
        }
        if (this.cropRight != webFigureRenderParameters.cropRight) {
            return false;
        }
        if (this.cropTop != webFigureRenderParameters.cropTop) {
            return false;
        }
        if (Double.compare(webFigureRenderParameters.elevation, this.elevation) != 0) {
            return false;
        }
        if (this.height != webFigureRenderParameters.height) {
            return false;
        }
        if (Double.compare(webFigureRenderParameters.rotation, this.rotation) != 0) {
            return false;
        }
        if (this.width != webFigureRenderParameters.width) {
            return false;
        }
        if (this.imageFormat != null ? !this.imageFormat.equals(webFigureRenderParameters.imageFormat) : webFigureRenderParameters.imageFormat != null) {
            return false;
        }
        return !(this.webFigure != null ? !this.webFigure.equals(webFigureRenderParameters.webFigure) : webFigureRenderParameters.webFigure != null);
    }

    public int hashCode() {
        int n = this.webFigure != null ? this.webFigure.hashCode() : 0;
        long l = this.rotation != 0.0 ? Double.doubleToLongBits(this.rotation) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.elevation != 0.0 ? Double.doubleToLongBits(this.elevation) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + this.width;
        n = 31 * n + this.height;
        n = 31 * n + (this.imageFormat != null ? this.imageFormat.hashCode() : 0);
        n = 31 * n + this.cropLeft;
        n = 31 * n + this.cropRight;
        n = 31 * n + this.cropTop;
        n = 31 * n + this.cropBottom;
        return n;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("rotation", this.getRotation());
        hashMap.put("elevation", this.getElevation());
        hashMap.put("width", this.getWidth());
        hashMap.put("height", this.getHeight());
        hashMap.put("imageFormat", this.getImageFormat());
        hashMap.put("cropLeft", this.getCropLeft());
        hashMap.put("cropRight", this.getCropRight());
        hashMap.put("cropTop", this.getCropTop());
        hashMap.put("cropBottom", this.getCropBottom());
        return hashMap;
    }
}

