/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.lang.reflect.Array;
import org.apache.commons.lang.StringUtils;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static boolean isRectangular(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("'array' cannot be null");
        }
        if (Array.getLength(object) == 0) {
            return true;
        }
        Object object2 = Array.get(object, 0);
        if (object2 == null) {
            return false;
        }
        int n = Array.getLength(object2);
        boolean bl = true;
        for (int i = 1; i < Array.getLength(object) && bl; ++i) {
            Object object3 = Array.get(object, i);
            bl = object3 != null && Array.getLength(object3) == n;
        }
        return bl;
    }

    public static int[] getLengths(Object[][] objectArray) {
        if (!ArrayUtils.isRectangular(objectArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(objectArray);
    }

    public static int[] getLengths(boolean[][] blArray) {
        if (!ArrayUtils.isRectangular(blArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(blArray);
    }

    public static int[] getLengths(byte[][] byArray) {
        if (!ArrayUtils.isRectangular(byArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(byArray);
    }

    public static int[] getLengths(short[][] sArray) {
        if (!ArrayUtils.isRectangular(sArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(sArray);
    }

    public static int[] getLengths(char[][] cArray) {
        if (!ArrayUtils.isRectangular(cArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(cArray);
    }

    public static int[] getLengths(int[][] nArray) {
        if (!ArrayUtils.isRectangular(nArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(nArray);
    }

    public static int[] getLengths(long[][] lArray) {
        if (!ArrayUtils.isRectangular(lArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(lArray);
    }

    public static int[] getLengths(float[][] fArray) {
        if (!ArrayUtils.isRectangular(fArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(fArray);
    }

    public static int[] getLengths(double[][] dArray) {
        if (!ArrayUtils.isRectangular(dArray)) {
            throw new IllegalArgumentException("Input argument must be a rectangular array.");
        }
        return ArrayUtils.getArrayLengths(dArray);
    }

    public static int[] getArrayLengths(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Input argument must be non-null.");
        }
        int n = ArrayUtils.getDimensions(object);
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        for (int i = 1; i < n; ++i) {
            nArray[i] = ArrayUtils.getMaxLength(object, i - 1);
        }
        return nArray;
    }

    public static int getDimensions(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Input argument must be non-null.");
        }
        return StringUtils.countMatches((String)object.getClass().getName(), (String)"[");
    }

    public static int getMaxLength(Object object, int n) {
        assert (object.getClass().isArray());
        int n2 = 0;
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2 = Array.get(object, i);
            assert (object2.getClass().isArray());
            n2 = n == 0 ? Math.max(n2, Array.getLength(object2)) : Math.max(n2, ArrayUtils.getMaxLength(object2, n - 1));
        }
        return n2;
    }

    public static boolean areContentsEqual(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return nArray == null && nArray2 == null;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areContentsEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            return objectArray == null && objectArray2 == null;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] == null || objectArray2[i] == null ? objectArray[i] != null || objectArray2[i] != null : !objectArray[i].equals(objectArray2[i]))) continue;
            return false;
        }
        return true;
    }

    public static final class EmptyPrimitives {
        public static final byte[] BYTE = new byte[0];
        public static final short[] SHORT = new short[0];
        public static final int[] INT = new int[0];
        public static final long[] LONG = new long[0];
        public static final float[] FLOAT = new float[0];
        public static final double[] DOUBLE = new double[0];
        public static final char[] CHAR = new char[0];
        public static final boolean[] BOOLEAN = new boolean[0];

        private EmptyPrimitives() {
        }
    }

    public static final class EmptyObjects {
        public static final String[] STRING = new String[0];
        public static final Object[] OBJECT = new Object[0];
        public static final Class[] CLASS = new Class[0];
        public static final Byte[] BYTE = new Byte[0];
        public static final Short[] SHORT = new Short[0];
        public static final Integer[] INTEGER = new Integer[0];
        public static final Long[] LONG = new Long[0];
        public static final Float[] FLOAT = new Float[0];
        public static final Double[] DOUBLE = new Double[0];
        public static final Character[] CHARACTER = new Character[0];
        public static final Boolean[] BOOLEAN = new Boolean[0];

        private EmptyObjects() {
        }
    }
}

