/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.J2SE14ReadWriteLock;
import com.mathworks.mde.cmdhist.AltHistory;
import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mde.cmdhist.CommandStyleInfo;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.SystemServices;
import com.mathworks.util.CircularBuffer;
import com.mathworks.util.FileUtils;
import com.mathworks.xml.XMLUtils;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DataFormatException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AltHistoryCollection {
    private final CircularBuffer<CommandRecord> fCommands;
    private PrefsProvider fPrefsProvider;
    private int fBatchId = 1;
    private boolean fCommandInProgress;
    private CommandRecordList fRecordList;
    private Thread fCommandSaverThread;
    private final BlockingQueue<CommandRecord> fSaveQueue = new LinkedBlockingQueue<CommandRecord>();
    private final CommandRecord NULL_COMMAND_RECORD = new CommandRecord();
    private Thread fAllSaverThread;
    private volatile boolean fInterruptAllSave;
    private boolean fAllSaveInterrupted;
    private CommandRecord fLastRecordSaved;
    private long fLastRecordPosition = -1L;
    private final Stack<Deletion> fUndoStack = new Stack();
    public static final String COMMAND_FILE_NAME = "History.xml";
    public static final String BACKUP_FILE_NAME = "History.bak";
    private static final int MAX_BATCH_ID = Integer.MAX_VALUE;
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static final String XML_HISTORY_HEADER = "<history>";
    private static final String XML_SESSION_HEADER = "<session>";
    private static final String XML_HISTORY_TERMINATOR = "</history>";
    private static final String XML_SESSION_TERMINATOR = "</session>";
    private static final String XML_COMMAND_TAG = "command";
    private static final String XML_BATCH_ATTRIBUTE = "batch";
    private static final String XML_ERROR_ATTRIBUTE = "error";
    private static final String XML_REPEAT_ATTRIBUTE = "repeat";
    private static final String XML_TIME_STAMP_ATTRIBUTE = "time_stamp";
    private static final String XML_EXECUTION_TIME_ATTRIBUTE = "execution_time";
    private static final String TIME_STAMP_PREFIX = "%-- ";
    private static final String TIME_STAMP_SUFFIX = " --%";
    private static final String CAPACITY_PREFERENCE_KEY = "CommandHistoryCommandCountLimit";
    private static final String SAVE_PREFERENCE_KEY = "CommandHistorySaveLinesR14";
    private static final int COMBINED_HEADER_LENGTH = "<?xml version=\"1.0\" encoding=\"utf-8\"?>".length() + "<history>".length() + "<session>".length() + 3;
    private static final int COMBINED_TERMINATOR_LENGTH = "</session>".length() + "</history>".length() + 2;

    AltHistoryCollection() {
        this(new ProductionPrefsProvider());
        PrefListener prefListener = new PrefListener(){

            public void prefChanged(final PrefEvent prefEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (prefEvent.getPrefKey() == AltHistoryCollection.CAPACITY_PREFERENCE_KEY) {
                            AltHistoryCollection.this.updateCapacity();
                        } else if (prefEvent.getPrefKey() == AltHistoryCollection.SAVE_PREFERENCE_KEY) {
                            AltHistoryCollection.this.handleSavePreferenceChange();
                        }
                    }
                });
            }
        };
        Prefs.addListener((PrefListener)prefListener, (String)CAPACITY_PREFERENCE_KEY);
        Prefs.addListener((PrefListener)prefListener, (String)SAVE_PREFERENCE_KEY);
    }

    public AltHistoryCollection(PrefsProvider prefsProvider) {
        this.fPrefsProvider = prefsProvider;
        this.fCommands = new CircularBuffer(this.fPrefsProvider.getCapacity());
    }

    public void addCommand(String string) {
        this.addCommands(Collections.singletonList(string));
    }

    public void addCommands(List<String> list) {
        if (list.size() == 0) {
            return;
        }
        this.fCommandInProgress = true;
        ArrayList<CommandRecord> arrayList = new ArrayList<CommandRecord>(list.size());
        long l = System.currentTimeMillis();
        for (String object : list) {
            if ("\n".equals(object) || !this.fPrefsProvider.saveQuitAndExit() && ("exit".equals(object) || "quit".equals(object) || object.startsWith("quit "))) continue;
            CommandRecord commandRecord = new CommandRecord(object);
            commandRecord.iBatchId.set(this.fBatchId);
            commandRecord.iTimeIssued = l;
            arrayList.add(commandRecord);
        }
        if (this.fPrefsProvider.saveDuplicates() || !this.areDuplicate(arrayList)) {
            if (this.fRecordList != null) {
                this.fRecordList.beginEvent();
            }
            this.interruptSaveAll();
            for (CommandRecord commandRecord : arrayList) {
                this.addRecord(commandRecord);
            }
            this.restartInterruptedSave();
            if (this.fRecordList != null) {
                this.fRecordList.endEvent();
            }
        } else if (arrayList.size() > 1) {
            --this.fBatchId;
        }
    }

    private boolean areDuplicate(List<CommandRecord> list) {
        int n;
        int n2;
        boolean bl;
        if (list.size() == 1) {
            CommandRecord commandRecord;
            CommandRecord commandRecord2 = list.get(0);
            if (!this.fCommands.isEmpty() && !commandRecord2.iCommandText.trim().equals("end") && (commandRecord = (CommandRecord)this.fCommands.get(this.fCommands.size() - 1)).iBatchId.get() < 0 && commandRecord2.iCommandText.equals(commandRecord.iCommandText)) {
                CommandRecord commandRecord3 = new CommandRecord(commandRecord);
                commandRecord.iRepeatCount.incrementAndGet();
                commandRecord.iTimeIssued = commandRecord2.iTimeIssued;
                commandRecord.iBatchId = commandRecord2.iBatchId;
                commandRecord.iCausedError.set(false);
                if (this.fRecordList != null) {
                    this.fRecordList.changeEvent(this.fCommands.size() - 1, commandRecord3, commandRecord);
                }
                this.interruptSaveAll();
                this.saveRecord(commandRecord);
                this.restartInterruptedSave();
                return true;
            }
        } else if (list.size() > 0 && this.fCommands.size() >= list.size() && (!(bl = this.isInBatch(n2 = (n = this.fCommands.size() - list.size()))) || this.isFirstInBatch(n2))) {
            CommandRecord commandRecord;
            CommandRecord commandRecord4 = (CommandRecord)this.fCommands.get(n2);
            int n3 = commandRecord4.iBatchId.get();
            boolean bl2 = true;
            int n4 = 0;
            while (n4 < list.size() && bl2) {
                commandRecord = list.get(n4);
                CommandRecord commandRecord5 = (CommandRecord)this.fCommands.get(n2);
                if (n3 != commandRecord5.iBatchId.get() || !commandRecord.iCommandText.equals(commandRecord5.iCommandText) || !bl && (commandRecord5.causedError() || commandRecord5.getRepeatCount() > 1)) {
                    bl2 = false;
                }
                ++n4;
                ++n2;
            }
            if (bl2) {
                CommandRecord commandRecord6 = new CommandRecord(commandRecord4);
                commandRecord4.iRepeatCount.incrementAndGet();
                commandRecord4.iTimeIssued = list.get(0).iTimeIssued;
                commandRecord4.iCausedError.set(false);
                if (this.fRecordList != null) {
                    this.fRecordList.changeEvent(n, commandRecord6, commandRecord4);
                }
                if (!bl) {
                    for (n2 = n; n2 < this.fCommands.size(); ++n2) {
                        commandRecord = (CommandRecord)this.fCommands.get(n2);
                        commandRecord6 = new CommandRecord(commandRecord);
                        commandRecord.iBatchId.set(this.fBatchId);
                        if (this.fRecordList == null) continue;
                        this.fRecordList.changeEvent(n2, commandRecord6, commandRecord);
                    }
                    ++this.fBatchId;
                    if (this.fBatchId == Integer.MAX_VALUE) {
                        this.fBatchId = 1;
                    }
                } else {
                    for (n2 = n; n2 < this.fCommands.size(); ++n2) {
                        commandRecord = (CommandRecord)this.fCommands.get(n2);
                        commandRecord6 = new CommandRecord(commandRecord);
                        commandRecord.iCausedError.set(false);
                        if (this.fRecordList == null) continue;
                        this.fRecordList.changeEvent(n2, commandRecord6, commandRecord);
                    }
                }
                this.initiateSaveAll();
                return true;
            }
        }
        return false;
    }

    private void addRecord(CommandRecord commandRecord) {
        if (this.fCommands.size() == this.fCommands.capacity() && this.fRecordList != null) {
            this.fRecordList.removeEvent(0, (CommandRecord)this.fCommands.get(0));
        }
        this.fCommands.add((Object)commandRecord);
        if (this.fRecordList != null) {
            this.fRecordList.addEvent(this.fCommands.size() - 1, commandRecord);
        }
        this.saveRecord(commandRecord);
        this.fUndoStack.clear();
    }

    public void recordCompletion() {
        this.recordCompletion(System.currentTimeMillis());
    }

    public void recordCompletion(long l) {
        CommandRecord commandRecord;
        if (this.fCommands.isEmpty() || !this.fCommandInProgress) {
            return;
        }
        this.fCommandInProgress = false;
        ++this.fBatchId;
        if (this.fBatchId == Integer.MAX_VALUE) {
            this.fBatchId = 1;
        }
        int n = this.fCommands.size() - 1;
        CommandRecord commandRecord2 = (CommandRecord)this.fCommands.get(n);
        long l2 = commandRecord2.iTimeIssued;
        int n2 = 1;
        for (int i = this.fCommands.size() - 2; i >= 0 && (commandRecord = (CommandRecord)this.fCommands.get(i)).iBatchId.get() == commandRecord2.iBatchId.get(); --i) {
            ++n2;
            if (commandRecord.iTimeIssued <= 0L) continue;
            l2 = commandRecord.iTimeIssued;
        }
        if (l2 > 0L) {
            CommandRecord commandRecord3 = new CommandRecord(commandRecord2);
            commandRecord2.iExecutionTime.set(l - l2);
            if (n2 == 1) {
                commandRecord2.iBatchId.set(-1);
                --this.fBatchId;
            }
            if (this.fRecordList != null) {
                this.fRecordList.changeEvent(n, commandRecord3, commandRecord2);
            }
            this.interruptSaveAll();
            this.saveRecord(commandRecord2);
            this.restartInterruptedSave();
        }
    }

    public void recordContinuation() {
        if (this.fCommands.isEmpty() || !this.fCommandInProgress) {
            return;
        }
        ((CommandRecord)this.fCommands.get(this.fCommands.size() - 1)).iTimeIssued = 0L;
    }

    public void recordError(String string) {
        CommandRecord commandRecord;
        if (this.fCommands.isEmpty() || !this.fCommandInProgress) {
            return;
        }
        int n = 0;
        int n2 = -1;
        for (int i = this.fCommands.size() - 1; i >= 0 && (commandRecord = (CommandRecord)this.fCommands.get(i)).iTimeIssued >= 0L && (n2 == -1 || n2 == commandRecord.iBatchId.get()); --i) {
            CommandRecord commandRecord2 = new CommandRecord(commandRecord);
            commandRecord.iCausedError.set(true);
            commandRecord.iErrorMessage = string;
            n2 = commandRecord.iBatchId.get();
            ++n;
            if (this.fRecordList != null) {
                this.fRecordList.changeEvent(i, commandRecord2, commandRecord);
            }
            if (n2 == -1) break;
        }
        if (n > 1) {
            this.initiateSaveAll();
        }
    }

    public void setCausedError(int[] nArray, boolean bl) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        boolean bl2 = false;
        for (int n : nArray) {
            if (this.isInBatch(n)) {
                int n2 = this.getBatchEnd(n);
                for (int i = this.getBatchStart(n); i <= n2; ++i) {
                    bl2 |= this.setCausedError(i, bl);
                }
                continue;
            }
            bl2 = this.setCausedError(n, bl);
        }
        if (bl2) {
            this.initiateSaveAll();
        }
    }

    private boolean setCausedError(int n, boolean bl) {
        CommandRecord commandRecord = (CommandRecord)this.fCommands.get(n);
        if (commandRecord.causedError() == bl) {
            return false;
        }
        CommandRecord commandRecord2 = new CommandRecord(commandRecord);
        commandRecord.setCausedError(bl);
        if (this.fRecordList != null) {
            this.fRecordList.changeEvent(n, commandRecord2, commandRecord);
        }
        return true;
    }

    public void addTimeStamp() {
        this.interruptSaveAll();
        this.addRecord(new CommandRecord());
        this.restartInterruptedSave();
    }

    public void deleteEmptySessions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 1;
        for (int i = this.fCommands.size() - 1; i >= 0; --i) {
            if (((CommandRecord)this.fCommands.get(i)).isTimeStamp()) {
                if (n == 0) {
                    arrayList.add(i);
                    continue;
                }
                n = 0;
                continue;
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = nArray.length - 1;
        for (Integer n3 : arrayList) {
            nArray[n2--] = n3;
        }
        this.delete(nArray);
    }

    public void delete(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Deletion deletion = new Deletion();
        deletion.iDeletedIndicies = nArray;
        this.interruptSaveAll();
        deletion.iDeletedRecords = this.fCommands.remove(nArray);
        this.fUndoStack.push(deletion);
        if (this.fRecordList != null) {
            this.fRecordList.beginEvent();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.fRecordList.removeEvent(nArray[i], deletion.iDeletedRecords.get(i));
            }
            this.fRecordList.endEvent();
        }
        this.initiateSaveAll();
    }

    public boolean anythingToUndo() {
        return !this.fUndoStack.isEmpty();
    }

    public void undoLastDeletion() {
        if (this.fUndoStack.isEmpty()) {
            return;
        }
        Deletion deletion = this.fUndoStack.pop();
        this.interruptSaveAll();
        this.fCommands.insert(deletion.iDeletedRecords, deletion.iDeletedIndicies);
        if (this.fRecordList != null) {
            this.fRecordList.beginEvent();
            for (int i = 0; i < deletion.iDeletedIndicies.length; ++i) {
                this.fRecordList.addEvent(deletion.iDeletedIndicies[i], deletion.iDeletedRecords.get(i));
            }
            this.fRecordList.endEvent();
        }
        this.initiateSaveAll();
    }

    public void clear() {
        if (!this.fCommands.isEmpty()) {
            this.interruptSaveAll();
            this.fCommands.clear();
            if (this.fRecordList != null) {
                this.fRecordList.clear();
            }
            this.fUndoStack.clear();
            this.initiateSaveAll();
        }
    }

    public boolean isEmpty() {
        return this.fCommands.isEmpty();
    }

    boolean isFull() {
        return this.fCommands.size() == this.fCommands.capacity();
    }

    public String[] getAllCommands() {
        String[] stringArray = new String[this.fCommands.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((CommandRecord)this.fCommands.get(i)).getCommandText();
        }
        return stringArray;
    }

    public String[] getSessionCommands() {
        int n = 0;
        if (!this.fCommands.isEmpty()) {
            for (int i = this.fCommands.size() - 1; i >= 0 && !((CommandRecord)this.fCommands.get(i)).isTimeStamp(); --i) {
                ++n;
            }
        }
        String[] stringArray = new String[n];
        int n2 = this.fCommands.size() - n;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((CommandRecord)this.fCommands.get(n2 + i)).getCommandText();
        }
        return stringArray;
    }

    public CommandRecordList getCommandRecordList() {
        if (this.fRecordList == null) {
            this.fRecordList = new CommandRecordList();
        }
        return this.fRecordList;
    }

    public boolean isInBatch(int n) {
        CommandRecord commandRecord = (CommandRecord)this.fCommands.get(n);
        int n2 = commandRecord.iBatchId.get();
        return n2 >= 0 && (n > 1 && ((CommandRecord)this.fCommands.get(n - 1)).iBatchId.get() == n2 || n < this.fCommands.size() - 1 && ((CommandRecord)this.fCommands.get(n + 1)).iBatchId.get() == n2);
    }

    public boolean isFirstInBatch(int n) {
        return n < 1 || ((CommandRecord)this.fCommands.get(n)).iBatchId.get() != ((CommandRecord)this.fCommands.get(n - 1)).iBatchId.get();
    }

    public boolean isLastInBatch(int n) {
        return n >= this.fCommands.size() - 1 || ((CommandRecord)this.fCommands.get(n)).iBatchId.get() != ((CommandRecord)this.fCommands.get(n + 1)).iBatchId.get();
    }

    public int getBatchStart(int n) {
        int n2 = ((CommandRecord)this.fCommands.get(n)).iBatchId.get();
        int n3 = n - 1;
        while (n3 >= 0 && ((CommandRecord)this.fCommands.get(n3)).iBatchId.get() == n2) {
            n = n3--;
        }
        return n;
    }

    public int getBatchEnd(int n) {
        int n2 = ((CommandRecord)this.fCommands.get(n)).iBatchId.get();
        int n3 = n + 1;
        while (n3 < this.fCommands.size() && ((CommandRecord)this.fCommands.get(n3)).iBatchId.get() == n2) {
            n = n3++;
        }
        return n;
    }

    private void saveRecord(CommandRecord commandRecord) {
        if (this.fPrefsProvider.saveCommands() && !this.fAllSaveInterrupted) {
            if (this.fCommandSaverThread == null) {
                this.startCommandSaverThread();
            }
            this.fSaveQueue.offer(commandRecord);
        }
    }

    private void startCommandSaverThread() {
        CommandSaver commandSaver = this.fLastRecordSaved == null ? new CommandSaver() : new CommandSaver(this.fLastRecordSaved, this.fLastRecordPosition);
        this.fCommandSaverThread = new Thread((Runnable)commandSaver, "History Command Saver");
        this.fCommandSaverThread.setPriority(1);
        this.fCommandSaverThread.setDaemon(true);
        this.fCommandSaverThread.start();
    }

    private void stopCommandSaverThread() {
        if (this.fCommandSaverThread != null) {
            this.fSaveQueue.offer(this.NULL_COMMAND_RECORD);
            try {
                this.fCommandSaverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fCommandSaverThread = null;
        }
    }

    void initiateSaveAll() {
        if (!this.fPrefsProvider.saveCommands()) {
            return;
        }
        this.stopCommandSaverThread();
        this.stopAllSaverThread();
        this.startAllSaverThread();
    }

    private void startAllSaverThread() {
        this.fInterruptAllSave = false;
        this.fAllSaveInterrupted = false;
        this.fLastRecordSaved = null;
        this.fLastRecordPosition = -1L;
        this.fAllSaverThread = new Thread((Runnable)new AllSaver(), "History All Saver");
        this.fAllSaverThread.setDaemon(true);
        this.fAllSaverThread.start();
    }

    private void stopAllSaverThread() {
        if (this.fAllSaverThread != null) {
            this.fInterruptAllSave = true;
            try {
                this.fAllSaverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fAllSaverThread = null;
        }
    }

    private void interruptSaveAll() {
        if (this.fAllSaverThread != null) {
            this.stopAllSaverThread();
            this.fAllSaveInterrupted = true;
        }
    }

    private void restartInterruptedSave() {
        if (this.fAllSaveInterrupted) {
            this.startAllSaverThread();
        }
    }

    public void flushSave() {
        if (this.fAllSaverThread != null) {
            try {
                this.fAllSaverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fAllSaverThread = null;
        }
        this.stopCommandSaverThread();
    }

    public void saveCommands() {
        this.saveCommands(this.fPrefsProvider.getCommandFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCommands(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.saveCommands(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(MessageFormat.format(AltHistory.sRes.getString("message.error_opening_file"), file));
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCommands(OutputStream outputStream) {
        boolean bl = Thread.currentThread() == this.fAllSaverThread;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
            outputStreamWriter.write(XML_HEADER);
            outputStreamWriter.write(10);
            outputStreamWriter.write(XML_HISTORY_HEADER);
            outputStreamWriter.write(10);
            if (!this.fCommands.isEmpty()) {
                int n;
                outputStreamWriter.write(XML_SESSION_HEADER);
                outputStreamWriter.write(10);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "utf-8");
                for (n = this.fCommands.size(); n > 0 && ((CommandRecord)this.fCommands.get(n - 1)).isTimeStamp(); --n) {
                }
                for (int i = 0; !(i >= n || bl && this.fInterruptAllSave); ++i) {
                    CommandRecord commandRecord = (CommandRecord)this.fCommands.get(i);
                    if (commandRecord.iIsTimeStamp && i > 0) {
                        outputStreamWriter.write(XML_SESSION_TERMINATOR);
                        outputStreamWriter.write(10);
                        outputStreamWriter.write(XML_SESSION_HEADER);
                        outputStreamWriter.write(10);
                    }
                    Document document = documentBuilder.newDocument();
                    Element element = commandRecord.toXML(document);
                    document.appendChild(element);
                    StringWriter stringWriter = new StringWriter();
                    transformer.transform(XMLUtils.transformSourceFactory((Object)document), XMLUtils.transformResultFactory((Object)stringWriter));
                    if (i == n - 1 && bl) {
                        this.fLastRecordSaved = commandRecord;
                        outputStreamWriter.flush();
                        this.fLastRecordPosition = this.fPrefsProvider.getCommandFile().length();
                    }
                    outputStreamWriter.write(stringWriter.getBuffer().toString().trim());
                    outputStreamWriter.write(10);
                }
                outputStreamWriter.write(XML_SESSION_TERMINATOR);
                outputStreamWriter.write(10);
            }
            outputStreamWriter.write(XML_HISTORY_TERMINATOR);
            outputStreamWriter.write(10);
        }
        catch (Exception exception) {
            System.out.println(AltHistory.sRes.getString("message.error_saving"));
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean recallCommands() {
        File file = this.fPrefsProvider.getCommandFile();
        return file.exists() ? this.recallCommands(file, false) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recallCommands(File file, boolean bl) {
        boolean bl2 = file.equals(this.fPrefsProvider.getCommandFile());
        boolean bl3 = true;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bl3 = this.recallCommands(fileInputStream, bl, !bl2);
        }
        catch (Exception exception) {
            bl3 = false;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recallCommands(InputStream inputStream, boolean bl, boolean bl2) {
        this.interruptSaveAll();
        if (!bl) {
            this.fCommands.clear();
            this.fUndoStack.clear();
            this.fBatchId = 0;
        }
        boolean bl3 = true;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
            bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            if (string == null) {
                throw new DataFormatException("File is empty");
            }
            if (!string.startsWith(XML_HEADER)) {
                throw new DataFormatException("Missing XML header");
            }
            string = bufferedReader.readLine();
            if (!string.startsWith(XML_HISTORY_HEADER)) {
                throw new DataFormatException("Missing history header");
            }
            boolean bl4 = true;
            int n = 0;
            string = bufferedReader.readLine();
            while (string != null) {
                if (string.startsWith(XML_SESSION_HEADER) || string.startsWith(XML_SESSION_TERMINATOR)) {
                    bl4 = true;
                } else if (!string.startsWith(XML_HISTORY_TERMINATOR)) {
                    try {
                        SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                        StringReader stringReader = new StringReader(string);
                        SimpleElement simpleElement = simpleDOMParser.parse((Reader)stringReader);
                        CommandRecord commandRecord = new CommandRecord((SimpleElement)simpleElement.getFirstChild());
                        if (commandRecord.isTimeStamp()) {
                            if (n == 0 && !this.fCommands.isEmpty()) {
                                this.fCommands.remove(new int[]{this.fCommands.size() - 1});
                            }
                            n = 0;
                        } else {
                            ++n;
                            if (bl4) {
                                CommandRecord commandRecord2 = new CommandRecord(TIME_STAMP_PREFIX + AltHistory.sRes.getString("message.unknown_date") + TIME_STAMP_SUFFIX);
                                commandRecord2.iIsTimeStamp = true;
                                this.fCommands.add((Object)commandRecord2);
                            }
                        }
                        bl4 = false;
                        this.fCommands.add((Object)commandRecord);
                        if (commandRecord.iBatchId.get() > 0) {
                            this.fBatchId = commandRecord.iBatchId.get();
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println(AltHistory.sRes.getString("message.error_parsing") + ": " + string);
                        bl3 = false;
                    }
                }
                string = bufferedReader.readLine();
            }
            if (n == 0 && !this.fCommands.isEmpty()) {
                this.fCommands.remove(new int[]{this.fCommands.size() - 1});
            }
        }
        catch (Exception exception) {
            bl3 = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        ++this.fBatchId;
        if (this.fRecordList != null) {
            this.fRecordList.fireRepopulatedEvent();
        }
        if (bl2) {
            this.initiateSaveAll();
        }
        return bl3;
    }

    public void updateCapacity() {
        int n;
        int n2 = this.fPrefsProvider.getCapacity();
        if (n2 == this.fCommands.capacity()) {
            return;
        }
        CommandRecord[] commandRecordArray = null;
        if (n2 < this.fCommands.size()) {
            int n3 = n = this.fPrefsProvider.isTesting() ? 0 : MJOptionPane.showConfirmDialog(null, (Object)AltHistory.sRes.getString("message.reduced_capacity"), (String)AltHistory.sRes.getString("title.capacity_change"), (int)0, (int)2);
            if (n == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CmdHistoryPrefs.setCommandCapacity(AltHistoryCollection.this.fCommands.capacity());
                    }
                });
                return;
            }
            if (this.fRecordList != null) {
                int n4 = this.fCommands.size() - n2;
                commandRecordArray = new CommandRecord[n4];
                for (int i = 0; i < n4; ++i) {
                    commandRecordArray[i] = (CommandRecord)this.fCommands.get(i);
                }
            }
        }
        this.interruptSaveAll();
        this.fCommands.setCapacity(n2);
        if (commandRecordArray != null) {
            this.fRecordList.beginEvent();
            for (n = commandRecordArray.length - 1; n >= 0; --n) {
                this.fRecordList.removeEvent(n, commandRecordArray[n]);
            }
            this.fRecordList.endEvent();
        }
        this.initiateSaveAll();
    }

    public void handleSavePreferenceChange() {
        if (this.fPrefsProvider.saveCommands()) {
            this.initiateSaveAll();
        } else {
            this.flushSave();
        }
    }

    private boolean isRecordAtPosition(RandomAccessFile randomAccessFile, CommandRecord commandRecord, long l) {
        try {
            randomAccessFile.seek(l);
            int n = (int)(randomAccessFile.length() - l);
            byte[] byArray = new byte[n];
            int n2 = randomAccessFile.read(byArray);
            String string = new String(byArray, 0, n2, "UTF-8");
            int n3 = string.indexOf(10);
            String string2 = n3 < 0 ? string : string.substring(0, n3);
            SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
            StringReader stringReader = new StringReader(string2);
            SimpleElement simpleElement = simpleDOMParser.parse((Reader)stringReader);
            CommandRecord commandRecord2 = new CommandRecord((SimpleElement)simpleElement.getFirstChild());
            return commandRecord.iCommandText.equals(commandRecord2.iCommandText);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isAtEnd(RandomAccessFile randomAccessFile) {
        try {
            return randomAccessFile.getFilePointer() + (long)COMBINED_TERMINATOR_LENGTH >= randomAccessFile.length();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void writeHistoryHeader(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes(XML_HEADER);
        randomAccessFile.write(10);
        randomAccessFile.writeBytes(XML_HISTORY_HEADER);
        randomAccessFile.write(10);
    }

    private void writeHistoryTerminator(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes(XML_HISTORY_TERMINATOR);
        randomAccessFile.write(10);
    }

    private void writeSessionHeader(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes(XML_SESSION_HEADER);
        randomAccessFile.write(10);
    }

    private void writeSessionTerminator(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBytes(XML_SESSION_TERMINATOR);
        randomAccessFile.write(10);
    }

    static interface CommandRecordListListener
    extends ListEventListener<CommandRecord> {
        public void listCleared(CommandRecordList var1);

        public void listRepopulated(CommandRecordList var1);
    }

    class CommandRecordList
    extends AbstractEventList<CommandRecord> {
        CommandRecordList() {
            this.readWriteLock = new J2SE14ReadWriteLock();
        }

        public int size() {
            return AltHistoryCollection.this.fCommands.size();
        }

        public CommandRecord get(int n) {
            return (CommandRecord)AltHistoryCollection.this.fCommands.get(n);
        }

        void beginEvent() {
            this.updates.beginEvent(true);
        }

        void endEvent() {
            this.updates.commitEvent();
        }

        void addEvent(int n, CommandRecord commandRecord) {
            this.updates.beginEvent();
            this.updates.elementInserted(n, (Object)commandRecord);
            this.updates.commitEvent();
        }

        void removeEvent(int n, CommandRecord commandRecord) {
            this.updates.beginEvent();
            this.updates.elementDeleted(n, (Object)commandRecord);
            this.updates.commitEvent();
        }

        void changeEvent(int n, CommandRecord commandRecord, CommandRecord commandRecord2) {
            this.updates.beginEvent();
            this.updates.elementUpdated(n, (Object)commandRecord, (Object)commandRecord2);
            this.updates.commitEvent();
        }

        void fireRepopulatedEvent() {
            for (ListEventListener listEventListener : this.updates.getListEventListeners()) {
                if (!(listEventListener instanceof CommandRecordListListener)) continue;
                ((CommandRecordListListener)listEventListener).listRepopulated(this);
            }
        }

        public void clear() {
            super.clear();
            for (ListEventListener listEventListener : this.updates.getListEventListeners()) {
                if (!(listEventListener instanceof CommandRecordListListener)) continue;
                ((CommandRecordListListener)listEventListener).listCleared(this);
            }
        }
    }

    private static class Deletion {
        int[] iDeletedIndicies;
        List<CommandRecord> iDeletedRecords;

        private Deletion() {
        }
    }

    private class AllSaver
    implements Runnable {
        private AllSaver() {
        }

        @Override
        public void run() {
            AltHistoryCollection.this.saveCommands();
            final Thread thread = Thread.currentThread();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AltHistoryCollection.this.fAllSaverThread == thread) {
                        AltHistoryCollection.this.fAllSaverThread = null;
                    }
                }
            });
        }
    }

    private class CommandSaver
    implements Runnable {
        private CommandRecord iLastRecordSaved;
        private long iLastRecordPosition;
        private int iRepeatDecrement;

        private CommandSaver() {
        }

        private CommandSaver(CommandRecord commandRecord, long l) {
            this.iLastRecordSaved = commandRecord;
            this.iLastRecordPosition = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            RandomAccessFile randomAccessFile = null;
            DocumentBuilder documentBuilder = null;
            Transformer transformer = null;
            while (!bl) {
                try {
                    CommandRecord commandRecord = (CommandRecord)AltHistoryCollection.this.fSaveQueue.take();
                    boolean bl3 = false;
                    if (commandRecord == AltHistoryCollection.this.NULL_COMMAND_RECORD) {
                        bl = true;
                        continue;
                    }
                    File file = AltHistoryCollection.this.fPrefsProvider.getCommandFile();
                    long l = 0L;
                    if (randomAccessFile != null) {
                        l = randomAccessFile.length();
                    } else {
                        boolean bl4 = file.exists();
                        randomAccessFile = new RandomAccessFile(file, "rw");
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.setOutputProperty("encoding", "utf-8");
                        if (bl4) {
                            long l2 = randomAccessFile.length();
                            if (l2 < (long)(COMBINED_HEADER_LENGTH + COMBINED_TERMINATOR_LENGTH)) {
                                randomAccessFile.setLength(0L);
                                bl4 = false;
                            } else {
                                l = l2 - (long)COMBINED_TERMINATOR_LENGTH;
                                randomAccessFile.seek(l);
                            }
                        }
                        if (!bl4) {
                            bl3 = true;
                            AltHistoryCollection.this.writeHistoryHeader(randomAccessFile);
                            AltHistoryCollection.this.writeSessionHeader(randomAccessFile);
                            l = randomAccessFile.length();
                        }
                    }
                    if (!bl3 && commandRecord.iIsTimeStamp) {
                        AltHistoryCollection.this.writeSessionTerminator(randomAccessFile);
                        AltHistoryCollection.this.writeSessionHeader(randomAccessFile);
                        this.iLastRecordSaved = commandRecord;
                        this.iRepeatDecrement = 0;
                    } else if (commandRecord == this.iLastRecordSaved) {
                        if (AltHistoryCollection.this.isRecordAtPosition(randomAccessFile, commandRecord, this.iLastRecordPosition) && AltHistoryCollection.isAtEnd(randomAccessFile)) {
                            l = this.iLastRecordPosition;
                        } else {
                            this.iRepeatDecrement = commandRecord.getRepeatCount() - 1;
                        }
                        randomAccessFile.seek(l);
                        if (this.iRepeatDecrement > 0) {
                            commandRecord = new CommandRecord(commandRecord);
                            commandRecord.iRepeatCount.addAndGet(-this.iRepeatDecrement);
                        }
                    } else {
                        this.iLastRecordSaved = commandRecord;
                        this.iRepeatDecrement = 0;
                    }
                    Document document = documentBuilder.newDocument();
                    Element element = commandRecord.toXML(document);
                    document.appendChild(element);
                    this.iLastRecordPosition = l;
                    StringWriter stringWriter = new StringWriter();
                    transformer.transform(XMLUtils.transformSourceFactory((Object)document), XMLUtils.transformResultFactory((Object)stringWriter));
                    randomAccessFile.write(stringWriter.getBuffer().toString().trim().getBytes(Charset.forName("UTF-8")));
                    randomAccessFile.write(10);
                }
                catch (Exception exception) {
                    System.out.println(AltHistory.sRes.getString("message.error_saving"));
                    exception.printStackTrace();
                    bl2 = true;
                    bl = true;
                }
                finally {
                    if (randomAccessFile == null || !bl && AltHistoryCollection.this.fSaveQueue.peek() != null) continue;
                    try {
                        if (!bl2) {
                            AltHistoryCollection.this.writeSessionTerminator(randomAccessFile);
                            AltHistoryCollection.this.writeHistoryTerminator(randomAccessFile);
                            randomAccessFile.setLength(randomAccessFile.getFilePointer());
                        }
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                    randomAccessFile = null;
                    documentBuilder = null;
                    transformer = null;
                }
            }
        }
    }

    public class CommandRecord {
        private final String iCommandText;
        private boolean iIsTimeStamp;
        private long iTimeIssued = -1L;
        private String iErrorMessage;
        private CommandStyleInfo iStyleInfo;
        boolean iMatches;
        private AtomicInteger iBatchId = new AtomicInteger(-1);
        private AtomicBoolean iCausedError = new AtomicBoolean(false);
        private AtomicLong iExecutionTime = new AtomicLong(-1L);
        private AtomicInteger iRepeatCount = new AtomicInteger(1);

        private CommandRecord() {
            this.iTimeIssued = System.currentTimeMillis();
            this.iCommandText = this.formatTimeStamp(this.iTimeIssued);
            this.iIsTimeStamp = true;
        }

        private CommandRecord(String string) {
            this.iCommandText = string;
        }

        private CommandRecord(CommandRecord commandRecord) {
            this.iCommandText = commandRecord.iCommandText;
            this.iIsTimeStamp = commandRecord.iIsTimeStamp;
            this.iTimeIssued = commandRecord.iTimeIssued;
            this.iStyleInfo = commandRecord.iStyleInfo;
            this.iErrorMessage = commandRecord.iErrorMessage;
            this.iBatchId.set(commandRecord.iBatchId.get());
            this.iCausedError.set(commandRecord.iCausedError.get());
            this.iExecutionTime.set(commandRecord.iExecutionTime.get());
            this.iRepeatCount.set(commandRecord.iRepeatCount.get());
        }

        public String getCommandText() {
            return this.iCommandText;
        }

        public boolean isComment() {
            return this.iCommandText != null && this.iCommandText.length() > 0 && this.iCommandText.charAt(0) == '%';
        }

        public boolean isTimeStamp() {
            return this.iIsTimeStamp;
        }

        public int getRepeatCount() {
            return this.iRepeatCount.get();
        }

        public boolean causedError() {
            return this.iCausedError.get();
        }

        public String getErrorMessage() {
            return this.iErrorMessage;
        }

        private void setCausedError(boolean bl) {
            this.iCausedError.set(bl);
        }

        long getExecutionTime() {
            return this.iExecutionTime.get();
        }

        CommandStyleInfo getStyleInfo() {
            if (this.iStyleInfo == null) {
                this.iStyleInfo = new CommandStyleInfo(this.iCommandText);
            }
            return this.iStyleInfo;
        }

        private String formatTimeStamp(long l) {
            return AltHistoryCollection.TIME_STAMP_PREFIX + SystemServices.formatDateTime((Date)new Date(l)) + AltHistoryCollection.TIME_STAMP_SUFFIX;
        }

        private Element toXML(Document document) {
            Element element = document.createElement(AltHistoryCollection.XML_COMMAND_TAG);
            if (this.iBatchId.get() >= 0) {
                element.setAttribute(AltHistoryCollection.XML_BATCH_ATTRIBUTE, Integer.toString(this.iBatchId.get()));
            }
            if (this.iRepeatCount.get() > 1) {
                element.setAttribute(AltHistoryCollection.XML_REPEAT_ATTRIBUTE, Integer.toString(this.iRepeatCount.get()));
            }
            if (this.iCausedError.get()) {
                element.setAttribute(AltHistoryCollection.XML_ERROR_ATTRIBUTE, "true");
            }
            if (this.iExecutionTime.get() >= 0L) {
                element.setAttribute(AltHistoryCollection.XML_EXECUTION_TIME_ATTRIBUTE, Long.toString(this.iExecutionTime.get()));
            }
            if (this.iIsTimeStamp && this.iTimeIssued >= 0L) {
                element.setAttribute(AltHistoryCollection.XML_TIME_STAMP_ATTRIBUTE, Long.toHexString(this.iTimeIssued));
            }
            Text text = document.createTextNode(this.iCommandText);
            element.appendChild(text);
            return element;
        }

        private CommandRecord(SimpleElement simpleElement) {
            String string;
            String string2;
            String string3;
            String string4 = simpleElement.getAttribute(AltHistoryCollection.XML_TIME_STAMP_ATTRIBUTE);
            if (string4 != null) {
                this.iIsTimeStamp = true;
                this.iTimeIssued = Long.parseLong(string4, 16);
                this.iCommandText = this.formatTimeStamp(this.iTimeIssued);
            } else {
                this.iCommandText = simpleElement.getText();
                this.iIsTimeStamp = this.iCommandText.startsWith(AltHistoryCollection.TIME_STAMP_PREFIX) && this.iCommandText.endsWith(AltHistoryCollection.TIME_STAMP_SUFFIX);
            }
            String string5 = simpleElement.getAttribute(AltHistoryCollection.XML_BATCH_ATTRIBUTE);
            if (string5 != null) {
                this.iBatchId.set(Integer.parseInt(string5));
            }
            if ((string3 = simpleElement.getAttribute(AltHistoryCollection.XML_REPEAT_ATTRIBUTE)) != null) {
                this.iRepeatCount.set(Integer.parseInt(string3));
            }
            if ("true".equals(string2 = simpleElement.getAttribute(AltHistoryCollection.XML_ERROR_ATTRIBUTE))) {
                this.iCausedError.set(true);
            }
            this.iExecutionTime.set((string = simpleElement.getAttribute(AltHistoryCollection.XML_EXECUTION_TIME_ATTRIBUTE)) == null ? -1L : Long.parseLong(string));
        }
    }

    private static class ProductionPrefsProvider
    implements PrefsProvider {
        private ProductionPrefsProvider() {
        }

        @Override
        public int getCapacity() {
            return CmdHistoryPrefs.getCommandCapacity();
        }

        @Override
        public boolean saveCommands() {
            return CmdHistoryPrefs.getNumCommandsToSave() != -1;
        }

        @Override
        public boolean saveDuplicates() {
            return CmdHistoryPrefs.getSaveDuplicates();
        }

        @Override
        public boolean saveQuitAndExit() {
            return CmdHistoryPrefs.getSaveExitQuit();
        }

        @Override
        public File getCommandFile() {
            return new File(FileUtils.getPreferencesDirectory(), AltHistoryCollection.COMMAND_FILE_NAME);
        }

        @Override
        public boolean isTesting() {
            return false;
        }
    }

    public static interface PrefsProvider {
        public int getCapacity();

        public boolean saveCommands();

        public boolean saveDuplicates();

        public boolean saveQuitAndExit();

        public File getCommandFile();

        public boolean isTesting();
    }
}

