/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.AltHistory;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.FontPrefsComponent;
import com.mathworks.services.Prefs;
import java.util.ResourceBundle;

public class CmdHistoryPrefs
implements FontPrefsComponent {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    public static final int NEVER_SAVE = -1;
    public static final int SAVE_QUIT = -2;
    static final int SAVE_ON_QUIT = 1;
    static final int SAVE_ON_NLINES = 2;
    static final int SAVE_ON_MASK = 3;
    static final int SAVE_DUPLICATES = 4;
    static final int SAVE_EXITQUIT = 8;
    static final int DEFAULT_OPTIONS = 2;
    static final String COMMAND_HISTORY = "CommandHistory";
    static final String HISTORY_OPTIONS = "HistoryOptionsR14";
    static final String SAVE_LINES = "SaveLinesR14";
    static final String SHOW_DELETE_CONFIRM = "DeleteConfirm";
    static final String MATCH_CASE_KEY = "MatchCase";
    static final String MATCH_ANYWHERE_KEY = "MatchAnywhere";
    static final String FILTER_MATCHES_KEY = "FilterMatches";
    static final String SHOW_EXECUTION_TIME_KEY = "ShowExecutionTime";
    static final String SHOW_TIME_WHEN_DOCKED_KEY = "ShowExecutionTimeWhenDocked";
    static final String SHOW_MATCH_TOOL_BAR_KEY = "ShowMatchBar";
    static final String SHOW_MATCH_BAR_WHEN_DOCKED_KEY = "ShowMatchBarWhenDocked";
    static final String SHOW_MATCH_INDICATOR_BAR_KEY = "ShowMachIndicatorBar";
    static final String SHOW_MESSAGE_WHEN_EMPTY = "ShowMessageWhenEmpty";
    static final String COMMAND_CAPACITY_PREFERENCE_KEY = "CommandCountLimit";
    static final int DEFAULT_COMMAND_CAPACITY = 25000;
    static final int MAX_COMMAND_CAPACITY = 1000000;
    static final int DEFAULT_SAVENCMDS = 1;
    private static int sSaveNCmds = Prefs.getIntegerPref((String)"CommandHistorySaveLinesR14", (int)1);
    private static int sHistoryOptions = Prefs.getIntegerPref((String)"CommandHistoryHistoryOptionsR14", (int)2);

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(sRes.getString("chpp.delete_dialog"), "CommandHistoryDeleteConfirm", AltHistory.TITLE, true)};
    }

    public String getDisplayName() {
        return sRes.getString("title");
    }

    public String getFontPrefsTagName() {
        return COMMAND_HISTORY;
    }

    public FontPrefs.FontType getDefaultFont() {
        return FontPrefs.FontType.CODE;
    }

    public static int getNumCommandsToSave() {
        int n = -1;
        int n2 = CmdHistoryPrefs.getHistoryOptions();
        if ((n2 & 1) == 1) {
            n = -2;
        } else if ((n2 & 2) == 2) {
            n = sSaveNCmds;
        }
        return n;
    }

    public static boolean getSaveDuplicates() {
        int n = CmdHistoryPrefs.getHistoryOptions();
        return (n & 4) == 4;
    }

    public static boolean getSaveExitQuit() {
        int n = CmdHistoryPrefs.getHistoryOptions();
        return (n & 8) == 8;
    }

    static int getHistoryOptions() {
        return sHistoryOptions;
    }

    static void setHistoryOptions(int n) {
        if (n != sHistoryOptions) {
            Prefs.setIntegerPref((String)"CommandHistoryHistoryOptionsR14", (int)n);
            sHistoryOptions = n;
        }
    }

    static int getSaveNLines() {
        return sSaveNCmds;
    }

    static void setSaveNLines(int n) {
        if (n != sSaveNCmds) {
            sSaveNCmds = n;
            Prefs.setIntegerPref((String)"CommandHistorySaveLinesR14", (int)n);
        }
    }

    static boolean getMatchCase() {
        return Prefs.getBooleanPref((String)"CommandHistoryMatchCase", (boolean)false);
    }

    static void setMatchCase(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryMatchCase", (boolean)bl);
    }

    static boolean getMatchAnywhere() {
        return Prefs.getBooleanPref((String)"CommandHistoryMatchAnywhere", (boolean)false);
    }

    static void setMatchAnywhere(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryMatchAnywhere", (boolean)bl);
    }

    static boolean getFilterMatches() {
        return Prefs.getBooleanPref((String)"CommandHistoryFilterMatches", (boolean)false);
    }

    static void setFilterMatches(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryFilterMatches", (boolean)bl);
    }

    static boolean getShowExecutionTime() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowExecutionTime", (boolean)false);
    }

    static void setShowExecutionTime(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryShowExecutionTime", (boolean)bl);
    }

    static boolean getShowExecutionTimeWhenDocked() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowExecutionTimeWhenDocked", (boolean)false);
    }

    static void setShowExecutionTimeWhenDocked(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryShowExecutionTimeWhenDocked", (boolean)bl);
    }

    static boolean getShowMatchToolBar() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowMatchBar", (boolean)false);
    }

    static void setShowMatchToolBar(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryShowMatchBar", (boolean)bl);
    }

    static boolean getShowMatchBarWhenDocked() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowMatchBarWhenDocked", (boolean)false);
    }

    static void setShowMatchBarWhenDocked(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryShowMatchBarWhenDocked", (boolean)bl);
    }

    static boolean getShowMatchIndicatorBar() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowMachIndicatorBar", (boolean)false);
    }

    static void setShowMatchIndicatorBar(boolean bl) {
        Prefs.setBooleanPref((String)"CommandHistoryShowMachIndicatorBar", (boolean)bl);
    }

    static boolean getShowMessageWhenEmpty() {
        return Prefs.getBooleanPref((String)"CommandHistoryShowMessageWhenEmpty", (boolean)true);
    }

    static void setCommandCapacity(int n) {
        Prefs.setIntegerPref((String)"CommandHistoryCommandCountLimit", (int)n);
    }

    static int getCommandCapacity() {
        int n = Prefs.getIntegerPref((String)"CommandHistoryCommandCountLimit", (int)25000);
        return n <= 0 ? 25000 : (n > 1000000 ? 1000000 : n);
    }
}

