/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mde.desk.ContributedTools;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

class ContributedToolsLoader {
    private static boolean sLoadInitiated = false;
    private static ContributedTools sContributedTools = null;
    private static List<DoneListener> sDoneListeners = new ArrayList<DoneListener>();

    private ContributedToolsLoader() {
    }

    static void load(final DoneListener doneListener) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContributedToolsLoader.load(doneListener);
                }
            });
        } else if (sContributedTools != null) {
            doneListener.loadingDone(sContributedTools);
        } else {
            sDoneListeners.add(doneListener);
            if (!sLoadInitiated) {
                sLoadInitiated = true;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final ContributedTools contributedTools = new ContributedTools();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TSRegistry tSRegistry = MLDesktop.getInstance().getToolstripRegistry();
                                for (TSToolSetContents tSToolSetContents : contributedTools.getContentList()) {
                                    tSRegistry.addToolSetContents(tSToolSetContents);
                                }
                                for (TSToolSet tSToolSet : contributedTools.getToolSetList()) {
                                    tSRegistry.addToolSet(tSToolSet);
                                }
                                sContributedTools = contributedTools;
                                ContributedToolsLoader.notifyDoneListeners();
                            }
                        });
                    }
                }, "ContributedToolsLoader");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    private static void notifyDoneListeners() {
        for (DoneListener doneListener : sDoneListeners) {
            doneListener.loadingDone(sContributedTools);
        }
    }

    static interface DoneListener {
        public void loadingDone(ContributedTools var1);
    }
}

