/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mwswing.AdjacentButton;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class EditorPrefsGeneralPanel
extends MJPanel {
    public static final String OPEN_FILES_ON_BREAKPOINT_CHECKBOX = "OpenFilesOnBreakpoint";
    private static final int BUILTIN_RADIO_ACTIVE = 1;
    private static final int UNREGISTERED_RADIO_ACTIVE = 2;
    private static EditorPrefsGeneralPanel sPrefsPanel;
    private MJRadioButton fUseBuiltinEditor;
    private MJRadioButton fUseUnregisteredEditor;
    private MJTextField fUserDefinedEditorTextField;
    private MJButton fUserDefinedEditorBrowseButton;
    private MJSpinner fMRUSize;
    private MJCheckBox fReopenFiles;
    private MJCheckBox fSaveOnBlurCheckBox;
    private MJCheckBox fAutoReloadFromDisc;
    private MJCheckBox fAutoTerminateFile;
    private MJCheckBox fOpenFilesOnBreakpoint;

    private EditorPrefsGeneralPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.general.Editor")));
        mJPanel.setName("Editor");
        boolean bl = EditorOptions.getBuiltinEditor();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fUseBuiltinEditor = new MJRadioButton(EditorUtils.lookup("pref.general.BuiltinEditor").trim(), bl);
        buttonGroup.add((AbstractButton)this.fUseBuiltinEditor);
        this.fUseBuiltinEditor.setName("BuiltinEditor");
        String string = EditorUtils.lookup("pref.general.OtherEditor");
        this.fUseUnregisteredEditor = new MJRadioButton(string, !bl);
        buttonGroup.add((AbstractButton)this.fUseUnregisteredEditor);
        this.fUseUnregisteredEditor.setName("OtherEditor");
        BuiltinItemListener builtinItemListener = new BuiltinItemListener();
        this.fUseBuiltinEditor.addItemListener((ItemListener)builtinItemListener);
        this.fUseUnregisteredEditor.addItemListener((ItemListener)builtinItemListener);
        this.fUserDefinedEditorTextField = new MJTextField(EditorOptions.getOtherEditorTextFieldEntry(), 10);
        this.fUserDefinedEditorTextField.setName("UserEditorTextField");
        this.fUserDefinedEditorTextField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.general.acc.OtherEditorText"));
        this.fUserDefinedEditorBrowseButton = new AdjacentButton(EditorUtils.lookup("pref.Browse"), (Component)this.fUserDefinedEditorTextField);
        this.fUserDefinedEditorBrowseButton.addActionListener((ActionListener)new FileChooserButtonListener());
        this.fUserDefinedEditorBrowseButton.setName("OtherEditorBrowseButton");
        this.fUserDefinedEditorBrowseButton.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.general.acc.OtherEditorBrowse"));
        if (bl) {
            this.fUserDefinedEditorTextField.setEnabled(false);
            this.fUserDefinedEditorBrowseButton.setEnabled(false);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        int n = 6;
        int n2 = 5;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        mJPanel.add((Component)this.fUseBuiltinEditor, (Object)gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        mJPanel.add((Component)this.fUseUnregisteredEditor, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        mJPanel.add((Component)this.fUserDefinedEditorTextField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        mJPanel.add((Component)this.fUserDefinedEditorBrowseButton, (Object)gridBagConstraints);
        if (bl) {
            this.fUseBuiltinEditor.setSelected(true);
        } else {
            this.fUseUnregisteredEditor.setSelected(true);
        }
        int n3 = EditorOptions.getMRUSize();
        if (n3 < 0 || n3 > 12) {
            n3 = 8;
        }
        this.fMRUSize = new MJSpinner(new SpinnerNumberModel(n3, 0, 12, 1)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 4;
                return dimension;
            }
        };
        this.fMRUSize.setDefaultEditorAccessibleName("Number of entries spinner");
        this.fMRUSize.setName("MRUSpinner");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.general.MRU")));
        mJPanel2.setName("MRU");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, n, n2, n);
        MJLabel mJLabel = new MJLabel(EditorUtils.lookup("pref.general.MRUNumber"));
        mJLabel.setName("NumEntriesLabel");
        mJPanel2.add((Component)mJLabel, (Object)gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        mJPanel2.add((Component)this.fMRUSize, (Object)gridBagConstraints2);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.general.OpeningFiles")));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, n2, 0);
        this.fReopenFiles = new MJCheckBox(EditorUtils.lookup("pref.general.Reopen"), EditorOptions.isReopenFilesUponStart());
        this.fReopenFiles.setName("ReopenPreviousCheckbox");
        mJPanel3.add((Component)this.fReopenFiles, (Object)gridBagConstraints2);
        this.fOpenFilesOnBreakpoint = new MJCheckBox(EditorUtils.lookup("pref.general.OpenOnBreakpoint"), MatlabDebugServices.isGraphicalDebuggingEnabled());
        this.fOpenFilesOnBreakpoint.setName(OPEN_FILES_ON_BREAKPOINT_CHECKBOX);
        gridBagConstraints2.gridy = 1;
        mJPanel3.add((Component)this.fOpenFilesOnBreakpoint, (Object)gridBagConstraints2);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(EditorUtils.lookup("pref.general.AutomaticFileChanges")));
        this.fSaveOnBlurCheckBox = new MJCheckBox(EditorUtils.lookup("pref.general.AutoSaveOnBlur"));
        this.fSaveOnBlurCheckBox.setName("SaveOnBlurCheckbox");
        this.fSaveOnBlurCheckBox.setSelected(EditorOptions.isSaveOnBlur());
        gridBagConstraints2.gridy = 0;
        mJPanel4.add((Component)this.fSaveOnBlurCheckBox, (Object)gridBagConstraints2);
        this.fAutoReloadFromDisc = new MJCheckBox(EditorUtils.lookup("pref.general.AutoReloadFromDisc"), EditorOptions.isAutoReloadFilesFromDisc());
        this.fAutoReloadFromDisc.setName("AutoReloadFilesFromDisc");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        mJPanel4.add((Component)this.fAutoReloadFromDisc, (Object)gridBagConstraints2);
        this.fAutoTerminateFile = new MJCheckBox(EditorUtils.lookup("pref.general.AutoTerminateFile"), EditorOptions.isAutoTerminateLastLine());
        this.fAutoTerminateFile.setName("AutoTerminateFile");
        gridBagConstraints2.gridy = 2;
        mJPanel4.add((Component)this.fAutoTerminateFile, (Object)gridBagConstraints2);
        this.setLayout((LayoutManager)new MGridLayout(4, 1, n, n2, 131072));
        this.add((Component)mJPanel);
        this.add((Component)mJPanel2);
        this.add((Component)mJPanel3);
        this.add((Component)mJPanel4);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new EditorPrefsGeneralPanel();
        sPrefsPanel.setName("EditorPrefsGeneralPanel");
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        String string = this.fUserDefinedEditorTextField.getText().trim();
        switch (this.activeRadioButton()) {
            case 1: {
                EditorOptions.setBuiltinEditor(true);
                EditorOptions.setOtherEditor("");
                break;
            }
            case 2: {
                EditorOptions.setBuiltinEditor(false);
                EditorOptions.setOtherEditor(string);
                break;
            }
            default: {
                EditorOptions.setBuiltinEditor(true);
                EditorOptions.setOtherEditor("");
            }
        }
        EditorOptions.setOtherEditorTextFieldEntry(string);
        EditorOptions.setReopenFilesUponStart(this.fReopenFiles.isSelected());
        EditorOptions.setMRUSize((Integer)this.fMRUSize.getValue());
        EditorOptions.setAutoReloadFilesFromDisc(this.fAutoReloadFromDisc.isSelected());
        EditorOptions.setAutoTerminateLastLine(this.fAutoTerminateFile.isSelected());
        EditorOptions.setGraphicalDebugging(this.fOpenFilesOnBreakpoint.isSelected());
        EditorOptions.setSaveOnBlur(this.fSaveOnBlurCheckBox.isSelected());
    }

    public static boolean validatePrefsPanel() {
        return sPrefsPanel == null || sPrefsPanel.validateOptions();
    }

    private boolean validateOptions() {
        boolean bl = true;
        if (this.activeRadioButton() == 2 && this.fUserDefinedEditorTextField.getText().trim().length() == 0) {
            DialogFactory.showErrorMessage((Component)((Object)this), EditorUtils.lookup("pref.general.OtherEditorErr"));
            bl = false;
        }
        return bl;
    }

    private int activeRadioButton() {
        if (this.fUseBuiltinEditor.isSelected()) {
            return 1;
        }
        if (this.fUseUnregisteredEditor.isSelected()) {
            return 2;
        }
        return 1;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env__editor_prefs"};
    }

    private class FileChooserButtonListener
    implements ActionListener {
        private FileChooserButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            mJFileChooserPerPlatform.setDialogTitle(EditorUtils.lookup("pref.general.FileChooserTitle"));
            mJFileChooserPerPlatform.setFileMustExist(true);
            mJFileChooserPerPlatform.showOpenDialog((Component)((Object)EditorPrefsGeneralPanel.this));
            if (mJFileChooserPerPlatform.getState() == 0 && mJFileChooserPerPlatform.getSelectedFile() != null) {
                EditorPrefsGeneralPanel.this.fUserDefinedEditorTextField.setText(mJFileChooserPerPlatform.getSelectedFile().getPath());
            }
        }
    }

    private class BuiltinItemListener
    implements ItemListener {
        private BuiltinItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (EditorPrefsGeneralPanel.this.fUseUnregisteredEditor.isSelected()) {
                EditorPrefsGeneralPanel.this.fUserDefinedEditorTextField.setEnabled(true);
                EditorPrefsGeneralPanel.this.fUserDefinedEditorBrowseButton.setEnabled(true);
            } else {
                EditorPrefsGeneralPanel.this.fUserDefinedEditorTextField.setEnabled(false);
                EditorPrefsGeneralPanel.this.fUserDefinedEditorBrowseButton.setEnabled(false);
            }
        }
    }
}

