/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorView;
import com.mathworks.mde.editor.RedrawTimer;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.util.Log;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUpdater;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;

public class EditorStatusBar
extends MJStatusBar {
    private final MJStatusBar.Field fMiscField;
    private final MJStatusBar.LabeledField fRowColStatusValue;
    private final MJStatusBar.Field fFunctionStatusLabel;
    private EditorView fEditorView;
    private STPInterface fSyntaxPane;
    private static final String UI_PREFIX = "ToolTip";
    private final CaretListener fCaretListener;
    private final DocumentListener fDocumentListener;
    private final Color fMiscBackgroundColor;
    private final Observer fSearchObserver;
    private final RedrawTimer fRedrawTimer = new RedrawTimer(new FunctionNameListener());
    public static final String SCRIPT_NAME = EditorUtils.lookup("statusBar.Script");
    private final MTreeUpdater.MTreeListener fTreeListener;
    private String fTextToAppend;

    EditorStatusBar(EditorView editorView) {
        this.fEditorView = editorView;
        this.fSyntaxPane = this.fEditorView.getSyntaxTextPane();
        this.fCaretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                EditorStatusBar.this.updateStatusInfo(true);
            }
        };
        this.fSyntaxPane.addCaretListener(this.fCaretListener);
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EditorStatusBar.this.updateStatusInfo(false);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EditorStatusBar.this.updateStatusInfo(false);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.fSyntaxPane.getDocument().addDocumentListener(this.fDocumentListener);
        this.fSearchObserver = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                if (object instanceof String) {
                    EditorStatusBar.this.setMiscField((String)object);
                }
            }
        };
        this.fSyntaxPane.addIncSearchObserver(this.fSearchObserver);
        String[] stringArray = new String[]{EditorUtils.lookup("statusBar.Line") + " ", EditorUtils.lookup("statusBar.Col") + " "};
        int[] nArray = new int[]{35, 30};
        this.fRowColStatusValue = new MJStatusBar.LabeledField(stringArray, nArray, true);
        int n = 0;
        for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
            n = Math.max(n, new MJLabel((String)editorLanguage.getDescription()).getPreferredSize().width);
        }
        this.fFunctionStatusLabel = new MJStatusBar.Field(Math.max(180, n), true);
        this.fMiscField = new MJStatusBar.Field(250, true);
        this.fMiscBackgroundColor = this.fMiscField.getBackground();
        this.fMiscField.setVisible(false);
        this.add((Component)this.fMiscField);
        this.add((Component)this.fFunctionStatusLabel);
        this.add((Component)this.fRowColStatusValue);
        this.setName("EditorStatusBar");
        this.updateStatusInfo(true);
        this.fSyntaxPane.setClientStatusBar((MJStatusBar)this);
        this.fTreeListener = new MTreeUpdater.MTreeListener(){

            public void treeUpdated(MTree mTree) {
                EditorStatusBar.this.setStatusBarTextToFunction(mTree);
            }
        };
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.fSyntaxPane)) {
            MTreeUpdater.startUpdates((STPBaseInterface)this.fSyntaxPane, (MTreeUpdater.UpdateInterval)MTreeUpdater.UpdateInterval.CARET, (MTreeUpdater.MTreeListener)this.fTreeListener);
        }
    }

    void setTextToAppend(String string) {
        this.fTextToAppend = string;
    }

    private void setMiscField(String string) {
        if (string.length() != 0) {
            Color color = UIManager.getColor("ToolTip.background");
            Color color2 = UIManager.getColor("ToolTip.foreground");
            this.fMiscField.setBackground(color);
            this.fMiscField.setForeground(color2);
            String string2 = string.substring(0, 13);
            String string3 = string.substring(13, string.length());
            String string4 = string3.length() > 30 ? string2 + "..." + string3.substring(string3.length() - 30) : string2 + string3;
            this.fMiscField.setText(string4);
            this.fMiscField.setVisible(true);
        } else {
            this.fMiscField.setVisible(false);
            this.fMiscField.setBackground(this.fMiscBackgroundColor);
            this.fMiscField.setText("");
        }
    }

    private void updateStatusInfo(boolean bl) {
        if (this.fSyntaxPane != null && this.fEditorView != null) {
            if (bl) {
                this.fRedrawTimer.queueUpdate();
            } else {
                this.fRedrawTimer.restart();
            }
            try {
                int n = this.fSyntaxPane.getSelectionDot();
                int n2 = this.fSyntaxPane.getLineFromPos(n);
                int n3 = this.fSyntaxPane.getLineStart(n2);
                int n4 = this.fSyntaxPane.getTotalWidthInChars(n3, n);
                this.fRowColStatusValue.setValue(0, n2 + 1);
                this.fRowColStatusValue.setValue(1, n4 + 1);
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    private static String getStatusFunctionPrefix(MTree mTree) {
        String string = SCRIPT_NAME;
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (node.getType().isClass()) {
                string = MTreeUtils.getClassNameNode((MTree.Node)node).getText();
                break;
            }
            if (!node.getType().isFunction()) continue;
            string = node.getFunctionName().getText();
            break;
        }
        return string;
    }

    public static String getStatusText(MTree mTree, int n, BaseDocument baseDocument, String string) {
        String string2 = EditorStatusBar.getStatusFunctionPrefix(mTree);
        List list = mTree.isEmpty() ? Collections.emptyList() : MTreeUtils.getPathToPosition((MTree)mTree, (int)n, (BaseDocument)baseDocument);
        return EditorStatusBar.getStringForFunctionPath(string2, list, string);
    }

    private static String getStringForFunctionPath(String string, List<MTree.Node> list, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!list.isEmpty() && list.get(0).getType().equals((Object)MTree.NodeType.FUNCTION) && list.get(0).getFunctionName().getText().equals(string)) {
            list = list.subList(1, list.size());
        }
        for (MTree.Node node : list) {
            if (!node.getType().equals((Object)MTree.NodeType.FUNCTION)) continue;
            stringBuilder.append(" / ").append(node.getFunctionName().getText());
        }
        if (string2 != null) {
            stringBuilder.append(" ").append(string2);
        }
        return stringBuilder.toString();
    }

    private void setStatusBarTextToFunction(MTree mTree) {
        if (this.fFunctionStatusLabel.getWidth() > 0) {
            String string = EditorStatusBar.getStatusText(mTree, this.fSyntaxPane.getCaretPosition(), (BaseDocument)this.fSyntaxPane.getDocument(), this.fTextToAppend);
            Insets insets = this.fFunctionStatusLabel.getBorder().getBorderInsets((Component)this.fFunctionStatusLabel);
            int n = this.fFunctionStatusLabel.getWidth() - (insets.left + insets.right);
            String string2 = SimpleStringTrimmer.getSharedBeginningTrimmer().shortenString(string, this.fFunctionStatusLabel.getFontMetrics(this.fFunctionStatusLabel.getFont()), n);
            this.fFunctionStatusLabel.setText(string2);
            this.fFunctionStatusLabel.setToolTipText(!string.equals(string2) ? string : null);
        }
    }

    void cleanup() {
        assert (this.fSyntaxPane != null) : "Cleanup should not be called twice, fSyntaxPane is already null.";
        if (SyntaxTextPaneUtilities.isMCode((STPInterface)this.fSyntaxPane)) {
            MTreeUpdater.stopUpdates((STPBaseInterface)this.fSyntaxPane, (MTreeUpdater.UpdateInterval)MTreeUpdater.UpdateInterval.CARET, (MTreeUpdater.MTreeListener)this.fTreeListener);
        }
        this.fSyntaxPane.removeIncSearchObserver(this.fSearchObserver);
        this.fSyntaxPane.removeCaretListener(this.fCaretListener);
        this.fSyntaxPane.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fSyntaxPane.setClientStatusBar(null);
        this.fEditorView = null;
        this.fSyntaxPane = null;
    }

    private class FunctionNameListener
    implements ActionListener {
        private FunctionNameListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorStatusBar.this.fSyntaxPane != null && EditorStatusBar.this.fEditorView != null && !SyntaxTextPaneUtilities.isMCode((STPInterface)EditorStatusBar.this.fEditorView.getSyntaxTextPane())) {
                EditorStatusBar.this.fFunctionStatusLabel.setText(EditorLanguageUtils.findLanguage((String)EditorStatusBar.this.fSyntaxPane.getContentType()).getDescription());
            }
        }
    }
}

