/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.mde.cmdwin.LoadNativeCmdWin;
import com.mathworks.mvm.eventmgr.FirableMvmEvent;
import com.mathworks.mvm.eventmgr.prompt.InputRequester;

public final class DebugLoopEvent
implements FirableMvmEvent {
    private final WhichLoop fLoop;
    private final LoopState fState;

    private static native WhichLoop getCurrentStateNative();

    public static WhichLoop getCurrentState() {
        LoadNativeCmdWin.loadNativeCmdWin();
        return DebugLoopEvent.getCurrentStateNative();
    }

    public DebugLoopEvent(WhichLoop whichLoop, LoopState loopState) {
        this.fLoop = whichLoop;
        this.fState = loopState;
        assert (this.fState != null);
    }

    public WhichLoop getWhichLoop() {
        return this.fLoop;
    }

    public LoopState getState() {
        return this.fState;
    }

    public static String getStaticEventType() {
        LoadNativeCmdWin.loadNativeCmdWin();
        return DebugLoopEvent.nativeGetCppEventType();
    }

    public boolean equals(Object object) {
        return object instanceof DebugLoopEvent && this.equals((DebugLoopEvent)object);
    }

    public boolean equals(DebugLoopEvent debugLoopEvent) {
        return debugLoopEvent != null && this.getWhichLoop() == debugLoopEvent.getWhichLoop() && this.getState() == debugLoopEvent.getState();
    }

    public int hashCode() {
        int n = this.fLoop == null ? 0 : this.fLoop.hashCode();
        int n2 = this.fState == null ? 0 : this.fState.hashCode();
        return n ^ n2;
    }

    public String toString() {
        String string = this.fLoop == null ? "null" : this.fLoop.toString();
        String string2 = this.fState == null ? "null" : this.fState.toString();
        return DebugLoopEvent.class.getSimpleName() + ": " + string + " " + string2;
    }

    private static native String nativeGetCppEventType();

    private static native DebugLoopEvent nativeFactory(long var0);

    private static native long nativeFactory(DebugLoopEvent var0);

    public static enum WhichLoop {
        MATLAB_DEBUG(InputRequester.DEBUG_PROMPT),
        MATLAB_KEYBOARD(InputRequester.KEYBOARD_PROMPT),
        SIMULINK(InputRequester.SIMULINK_DEBUG_PROMPT),
        STATEFLOW(InputRequester.SF_EML_DEBUG_PROMPT),
        SIMEVENTS(InputRequester.SIMEVENTS_DEBUG_PROMPT);

        private final int fCppValue;

        private WhichLoop(int n2) {
            this.fCppValue = n2;
        }

        private WhichLoop(InputRequester inputRequester) {
            this(inputRequester.getNativeValue());
        }

        static WhichLoop fromCppValue(int n) {
            for (WhichLoop whichLoop : WhichLoop.values()) {
                if (whichLoop.fCppValue != n) continue;
                return whichLoop;
            }
            return null;
        }
    }

    public static enum LoopState {
        ENTERED,
        EXITED;

    }
}

