/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import java.util.StringTokenizer;

public class MatlabBreakpointParseUtils {
    private static final String LINE_STRING_IN_ENGLISH = "Line:";

    private MatlabBreakpointParseUtils() {
    }

    public static boolean doesErrorMessageContainLineNumber(String string) {
        return MatlabBreakpointParseUtils.findStringInErrorMessage(MatlabBreakpointUtils.lookup("errorMessage.line"), LINE_STRING_IN_ENGLISH, string) >= 0;
    }

    public static int getLineNumberFromErrorMessage(String string) {
        MatlabBreakpointParseUtils.checkErrorMessageHasLineAndColumnNumber(string);
        int n = MatlabBreakpointParseUtils.findStringInErrorMessage(MatlabBreakpointUtils.lookup("errorMessage.line"), LINE_STRING_IN_ENGLISH, string);
        String string2 = string.substring(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        stringTokenizer.nextToken();
        return Integer.valueOf(stringTokenizer.nextToken());
    }

    private static int findStringInErrorMessage(String string, String string2, String string3) {
        int n = string3.indexOf(string);
        return n >= 0 ? n : string3.indexOf(string2);
    }

    private static void checkErrorMessageHasLineAndColumnNumber(String string) {
        if (!MatlabBreakpointParseUtils.doesErrorMessageContainLineNumber(string)) {
            throw new IllegalArgumentException("The given string does not contain a line number.");
        }
    }
}

