/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.breakpoints.MatlabDebugInterestRegistrant;
import com.mathworks.services.message.MWMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;

final class MatlabDebugInterestNotifier {
    private MatlabDebugInterestRegistrant fDbStopRegistrant;
    private MatlabDebugInterestRegistrant fDbAddRegistrant;
    private MatlabDebugInterestRegistrant fBpDeleteRegistrant;
    private MatlabDebugInterestRegistrant fBpClearRegistrant;
    private final RegistrationListener fRegistrationListener;
    private List<DebugListener> fDebugListeners = new ArrayList<DebugListener>();

    MatlabDebugInterestNotifier(RegistrationListener registrationListener) {
        Validate.notNull((Object)registrationListener, (String)"The given registration listener cannot be null.");
        this.fRegistrationListener = registrationListener;
        if (Matlab.isMatlabAvailable()) {
            this.fDbStopRegistrant = new MatlabDebugInterestRegistrant(MatlabDebugInterestRegistrant.EventType.BREAKPOINT_HIT, this.createBreakpointHitHandler());
            this.fDbAddRegistrant = new MatlabDebugInterestRegistrant(MatlabDebugInterestRegistrant.EventType.BREAKPOINT_ADDED, this.createBreakpointsAddedHandler());
            this.fBpDeleteRegistrant = new MatlabDebugInterestRegistrant(MatlabDebugInterestRegistrant.EventType.BREAKPOINT_REMOVED, this.createBreakpointsRemovedHandler());
            this.fBpClearRegistrant = new MatlabDebugInterestRegistrant(MatlabDebugInterestRegistrant.EventType.BREAKPOINTS_CLEARED, this.createBreakPointsClearedHandler());
            this.createInterestRegistrationWaitingThread().start();
        }
    }

    private Thread createInterestRegistrationWaitingThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MatlabDebugInterestNotifier.this.fDbStopRegistrant.waitForRegistration();
                MatlabDebugInterestNotifier.this.fDbAddRegistrant.waitForRegistration();
                MatlabDebugInterestNotifier.this.fBpDeleteRegistrant.waitForRegistration();
                MatlabDebugInterestNotifier.this.fBpClearRegistrant.waitForRegistration();
                MatlabDebugInterestNotifier.this.fRegistrationListener.registrationComplete();
            }
        }, "MatlabDebugInterestNotifier");
        thread.setDaemon(true);
        return thread;
    }

    public void dispose() {
        this.fDbStopRegistrant.dispose();
        this.fDbAddRegistrant.dispose();
        this.fBpDeleteRegistrant.dispose();
        this.fBpClearRegistrant.dispose();
        this.fDebugListeners.clear();
    }

    private MatlabDebugInterestRegistrant.MessageHandler createBreakpointsAddedHandler() {
        return new MatlabDebugInterestRegistrant.MessageHandler(){

            @Override
            public void handleMessage(MWMessage mWMessage) {
                MWMessage[] mWMessageArray = (MWMessage[])mWMessage.get((Object)"result");
                Collection<MatlabBreakpoint> collection = MatlabBreakpointUtils.extractBreakpoints(mWMessageArray);
                MatlabDebugInterestNotifier.this.fireBreakpointsAdded(collection);
            }
        };
    }

    private MatlabDebugInterestRegistrant.MessageHandler createBreakpointsRemovedHandler() {
        return new MatlabDebugInterestRegistrant.MessageHandler(){

            @Override
            public void handleMessage(MWMessage mWMessage) {
                MWMessage[] mWMessageArray = (MWMessage[])mWMessage.get((Object)"result");
                Collection<MatlabBreakpoint> collection = MatlabBreakpointUtils.extractBreakpoints(mWMessageArray);
                MatlabDebugInterestNotifier.this.fireBreakpointsRemoved(collection);
            }
        };
    }

    private MatlabDebugInterestRegistrant.MessageHandler createBreakpointHitHandler() {
        return new MatlabDebugInterestRegistrant.MessageHandler(){

            @Override
            public void handleMessage(MWMessage mWMessage) {
                String string = (String)mWMessage.get((Object)"string");
                Integer n = (Integer)mWMessage.get((Object)"lineno") - 1;
                String string2 = (String)mWMessage.get((Object)"value");
                File file = MatlabBreakpointUtils.convertStringPathToFile(string);
                if (string != null) {
                    MatlabDebugInterestNotifier.this.fireBreakpointHit(n, file);
                }
                if (string != null && string2 != null) {
                    MatlabDebugInterestNotifier.this.fireErrorInBreakpointCondition(n, file, string2);
                }
            }
        };
    }

    private MatlabDebugInterestRegistrant.MessageHandler createBreakPointsClearedHandler() {
        return new MatlabDebugInterestRegistrant.MessageHandler(){

            @Override
            public void handleMessage(MWMessage mWMessage) {
                MatlabDebugInterestNotifier.this.fireBreakpointsCleared();
            }
        };
    }

    public void addDebugListener(DebugListener debugListener) {
        this.fDebugListeners.add(debugListener);
    }

    public void removeDebugListener(DebugListener debugListener) {
        this.fDebugListeners.remove(debugListener);
    }

    private void fireBreakpointsAdded(final Collection<MatlabBreakpoint> collection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DebugListener debugListener : MatlabDebugInterestNotifier.this.fDebugListeners) {
                    debugListener.breakpointsAdded(collection);
                }
            }
        });
    }

    private void fireBreakpointsRemoved(final Collection<MatlabBreakpoint> collection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DebugListener debugListener : MatlabDebugInterestNotifier.this.fDebugListeners) {
                    debugListener.breakpointsRemoved(collection);
                }
            }
        });
    }

    private void fireBreakpointHit(final int n, final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DebugListener debugListener : MatlabDebugInterestNotifier.this.fDebugListeners) {
                    debugListener.breakpointHit(n, file);
                }
            }
        });
    }

    private void fireErrorInBreakpointCondition(final int n, final File file, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DebugListener debugListener : MatlabDebugInterestNotifier.this.fDebugListeners) {
                    debugListener.errorInBreakpointExpression(n, file, string);
                }
            }
        });
    }

    private void fireBreakpointsCleared() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DebugListener debugListener : MatlabDebugInterestNotifier.this.fDebugListeners) {
                    debugListener.breakpointsCleared();
                }
            }
        });
    }

    public static interface RegistrationListener {
        public void registrationComplete();
    }
}

