/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.editordataservice;

import com.mathworks.mde.cmdwin.CmdWinExecuteServices;
import com.mathworks.mde.editor.EditorMatlab;
import com.mathworks.mde.editor.RealMatlab;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;

public class MatlabExecutionService {
    private final MessageService fMessageService;
    private static final String EXECUTION_EVAL = "/editor/executionservice/executionEval";
    private static final String AUTHORING_EVAL = "/editor/executionservice/authoringEval";
    private final EditorMatlab fMatlab;
    private final CmdWinExecuteServices fCmdWinExecuteServices;
    private final Subscriber fExecutionEvalSubscriber = this.createExecutionEvalSubscriber();
    private final Subscriber fAuthoringEvalSubscriber = this.createAuthoringEvalSubscriber();

    public MatlabExecutionService(MessageService messageService, EditorMatlab editorMatlab) {
        this.fMessageService = messageService;
        this.fMatlab = editorMatlab;
        this.fCmdWinExecuteServices = new CmdWinExecuteServices();
        this.fMessageService.subscribe(AUTHORING_EVAL, this.fAuthoringEvalSubscriber);
        this.fMessageService.subscribe(EXECUTION_EVAL, this.fExecutionEvalSubscriber);
    }

    public MatlabExecutionService() {
        this(MessageServiceFactory.getMessageService(), new RealMatlab());
    }

    private Subscriber createExecutionEvalSubscriber() {
        return new Subscriber(){

            public void handle(Message message) {
                MatlabExecutionService.this.executionEval(MatlabExecutionService.getCodeFromMessage(message));
            }
        };
    }

    private static String getCodeFromMessage(Message message) {
        return (String)message.getData();
    }

    private Subscriber createAuthoringEvalSubscriber() {
        return new Subscriber(){

            public void handle(Message message) {
                MatlabExecutionService.this.authoringEval(MatlabExecutionService.getCodeFromMessage(message));
            }
        };
    }

    private void executionEval(String string) {
        this.fMatlab.evalConsoleOutput(string);
    }

    private void authoringEval(String string) {
        this.fCmdWinExecuteServices.executeCommand(string);
    }

    public void dispose() {
        this.fMessageService.unsubscribe(EXECUTION_EVAL, this.fExecutionEvalSubscriber);
        this.fMessageService.unsubscribe(AUTHORING_EVAL, this.fAuthoringEvalSubscriber);
    }
}

