/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorToolBarGroupID;
import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.matlab.api.toolbars.ToolBarBuilder;
import com.mathworks.matlab.api.toolbars.ToolBarContributor;
import com.mathworks.matlab.api.toolbars.ToolBarGroupID;
import com.mathworks.matlab.api.toolbars.ToolBars;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabDebugActions;
import com.mathworks.mde.editor.plugins.matlab.MatlabMenuContributor;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.debug.DebugActions;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ToolTipProvider;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.PickerButton;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import com.mathworks.widgets.toolbars.ToolBarItems;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class MatlabToolBarContributor
implements ToolBarContributor {
    public static final String RUN_TOOLBAR_BUTTON_NAME = "runButton";
    public static final String PUBLISH_TOOLBAR_BUTTON_NAME = "publishButton";
    private static final EditorAction RUN_ACTION = new EditorAction("run-from-toolbar");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MatlabToolBarContributor.class.getPackage().getName() + ".resources.RES_matlab");

    public void contributeToEditorGroup(ToolBars<ToolBarContributor.ToolBarItem> toolBars) {
        MatlabToolBarContributor.contribute(toolBars, MatlabToolBarContributor.createDummyPickerButton(RUN_ACTION, RUN_TOOLBAR_BUTTON_NAME), MatlabToolBarContributor.createDummyPickerButton(MatlabMenuContributor.PUBLISH, PUBLISH_TOOLBAR_BUTTON_NAME));
        ToolBarBuilder toolBarBuilder = toolBars.getBuilder(EditorUtils.MAIN_TOOLBAR_ID);
        toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createActionToolBarItem((String)"set-clear-breakpoint", (Action)MatlabDebugActions.createSetClearBreakpointAction(null)), ToolBarItems.createActionToolBarItem((String)"clear-all-breakpoints", (Action)MatlabToolBarContributor.createDummyClearAllBreakpointsAction())});
    }

    private static ToolBarContributor.ToolBarItem createDummyPickerButton(EditorAction editorAction, String string) {
        MJAbstractAction mJAbstractAction = editorAction.createDummyAction();
        PickerButton pickerButton = new PickerButton((AbstractAction)mJAbstractAction);
        String string2 = BUNDLE.getString("toolbar.item." + string);
        pickerButton.setEnabled(false);
        pickerButton.setToolTipText(string2);
        pickerButton.setDropDownToolTipText(BUNDLE.getString("tooltip." + string + ".dropDown"));
        return ToolBarItems.createComponentToolBarItem((String)editorAction.getActionId(), (String)string2, (Component)pickerButton, (Icon)mJAbstractAction.getButtonOnlyIcon());
    }

    public void contributeToEditor(ToolBars<ToolBarContributor.ToolBarItem> toolBars, Editor editor) {
        MJAbstractAction mJAbstractAction;
        ToolBarBuilder toolBarBuilder = toolBars.getBuilder(EditorUtils.MAIN_TOOLBAR_ID);
        if (editor.getStorageLocation() instanceof FileStorageLocation || editor.getStorageLocation() instanceof FutureFileStorageLocation) {
            mJAbstractAction = (MJAbstractAction)DebugActions.getClearAllBkptsAction();
            toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createActionToolBarItem((String)mJAbstractAction.getActionID(), (Action)mJAbstractAction)});
        }
        if (MatlabPluginUtils.isMatlabCodeFileOrBuffer(editor)) {
            new MatlabToolBarContribution(editor).contributeToolBarItems((ToolBars<ToolBarContributor.ToolBarItem>)toolBars);
            mJAbstractAction = MatlabDebugActions.createSetClearBreakpointAction(editor);
            toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new ToolBarContributor.ToolBarItem[]{ToolBarItems.createActionToolBarItem((String)mJAbstractAction.getActionID(), (Action)mJAbstractAction)});
        }
    }

    public void layoutItems(ToolBars<String> toolBars) {
        ToolBarBuilder toolBarBuilder = toolBars.getBuilder(EditorUtils.MAIN_TOOLBAR_ID);
        toolBarBuilder.addToFront((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new String[]{"stop-from-toolbar"});
        toolBarBuilder.addToFront((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, (Object[])new String[]{RUN_ACTION.getActionId()});
        toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.OUTPUT_GROUP, (Object[])new String[]{MatlabMenuContributor.PUBLISH.getActionId()});
    }

    public static ToolTipProvider createToolTipProvider(final Editor editor, final AbstractFileConfiguration.Type<?> type) {
        return new ToolTipProvider(){

            public String getToolTipText() {
                return MatlabToolBarContributor.getToolTipText(editor, type);
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return this.getToolTipText();
            }
        };
    }

    private static String getToolTipText(Editor editor, AbstractFileConfiguration.Type<?> type) {
        String string;
        if (!editor.isOpen() || !StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) {
            return null;
        }
        MatlabPluginUtils.assertIsOrWillBeBackedByFile(editor);
        String string2 = string = type.equals((Object)RunConfiguration.TYPE) ? RUN_TOOLBAR_BUTTON_NAME : PUBLISH_TOOLBAR_BUTTON_NAME;
        String string3 = editor.isBuffer() ? BUNDLE.getString("tooltip." + string + ".SaveAndExecute") : (editor.isDirty() ? MessageFormat.format(BUNDLE.getString("tooltip." + string + ".SaveDynamic"), MatlabToolBarContributor.getExpression(editor, type)) : MessageFormat.format(BUNDLE.getString("tooltip." + string), MatlabToolBarContributor.getExpression(editor, type)));
        if (type.equals((Object)RunConfiguration.TYPE)) {
            string3 = KeyStrokeUtils.appendShortcut((String)string3, (ExtendedAction)MatlabMenuContributor.RUN_OR_CONTINUE.getAction());
        } else if (type.equals((Object)PublishConfiguration.TYPE)) {
            string3 = KeyStrokeUtils.appendShortcut((String)string3, (ExtendedAction)MatlabMenuContributor.PUBLISH.getAction());
        }
        return string3;
    }

    private static String getExpression(Editor editor, AbstractFileConfiguration.Type<?> type) {
        File file = MatlabPluginUtils.getBackingFile(editor);
        String string = "";
        if (type.equals((Object)RunConfiguration.TYPE)) {
            RunConfiguration runConfiguration = (RunConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, type);
            string = runConfiguration.getMatlabExpressionToRun();
        } else if (type.equals((Object)PublishConfiguration.TYPE)) {
            string = ConfigurationUtils.getConfigurationNameOrFileName((File)file, type);
        }
        return string;
    }

    private static <N> void contribute(ToolBars<N> toolBars, N n, N n2) {
        ToolBarBuilder toolBarBuilder = toolBars.getBuilder(EditorUtils.MAIN_TOOLBAR_ID);
        toolBarBuilder.addToFront((ToolBarGroupID)EditorToolBarGroupID.RUN_DEBUG_GROUP, new Object[]{n});
        toolBarBuilder.add((ToolBarGroupID)EditorToolBarGroupID.OUTPUT_GROUP, new Object[]{n2});
    }

    private static MJAbstractAction createDummyClearAllBreakpointsAction() {
        return new MJAbstractAction(){
            {
                MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "clear-all-breakpoints", (ExtendedAction)this);
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
    }

    private static class MatlabToolBarContribution {
        private final Editor fEditor;
        private final EditorAction.ObservableAction fRunAction;
        private final PickerButton fRunButton;
        private final EditorAction.ObservableAction fPublishAction;
        private final PickerButton fPublishButton;
        private final DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = this.createDebuggerManagerStateListener();

        private MatlabToolBarContribution(Editor editor) {
            this.fEditor = editor;
            this.fRunAction = this.createAction(RUN_ACTION, RunConfiguration.TYPE);
            this.fRunButton = this.createToolBarButton((AbstractAction)((Object)this.fRunAction), RunConfiguration.TYPE, MatlabToolBarContributor.RUN_TOOLBAR_BUTTON_NAME);
            this.fPublishAction = this.createAction(MatlabMenuContributor.PUBLISH, PublishConfiguration.TYPE);
            this.fPublishButton = this.createToolBarButton((AbstractAction)((Object)this.fPublishAction), PublishConfiguration.TYPE, MatlabToolBarContributor.PUBLISH_TOOLBAR_BUTTON_NAME);
            this.listenToDebugMode();
            this.updateActionStates();
        }

        private EditorAction.ObservableAction createAction(EditorAction editorAction, final AbstractFileConfiguration.Type<?> type) {
            EditorAction.ObservableAction observableAction = editorAction.getAction();
            observableAction.setObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    MatlabPluginUtils.executeDefaultConfiguration(MatlabToolBarContribution.this.fEditor, type);
                }
            });
            return observableAction;
        }

        private PickerButton createToolBarButton(AbstractAction abstractAction, AbstractFileConfiguration.Type<?> type, String string) {
            assert (abstractAction != null) : "action cannot be null";
            PickerButton pickerButton = new PickerButton(abstractAction);
            pickerButton.setPopupMenuCustomizer((PopupMenuCustomizer)MatlabPluginUtils.createMenuCustomizer(this.fEditor, type));
            pickerButton.setName(string);
            pickerButton.setDropDownToolTipText(BUNDLE.getString("tooltip." + string + ".dropDown"));
            pickerButton.setToolTipProvider(MatlabToolBarContributor.createToolTipProvider(this.fEditor, type));
            return pickerButton;
        }

        private void listenToDebugMode() {
            new SelfRemovingEditorEventListener(this.fEditor){
                {
                    DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)MatlabToolBarContribution.this.fDebuggerManagerStateListener);
                }

                public void cleanup() {
                    DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)MatlabToolBarContribution.this.fDebuggerManagerStateListener);
                }
            };
        }

        private DebuggerManager.DebuggerManagerStateListener createDebuggerManagerStateListener() {
            return new DebuggerManager.DebuggerManagerStateListener(){

                public void stateUpdated(DebuggerManager.DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
                    MatlabToolBarContribution.this.updateActionStates();
                }
            };
        }

        private void updateActionStates() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MatlabToolBarContribution.this.fRunAction.setEnabled(!DebuggerManager.isDebugging());
                }
            });
        }

        private void contributeToolBarItems(ToolBars<ToolBarContributor.ToolBarItem> toolBars) {
            MatlabToolBarContributor.contribute(toolBars, ToolBarItems.createComponentToolBarItem((String)RUN_ACTION.getActionId(), (String)"Unused", (Component)this.fRunButton, (Icon)this.fRunAction.getButtonOnlyIcon()), ToolBarItems.createComponentToolBarItem((String)MatlabMenuContributor.PUBLISH.getActionId(), (String)"Unused", (Component)this.fPublishButton, (Icon)this.fPublishAction.getButtonOnlyIcon()));
        }
    }
}

