/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.evaluation;

import com.mathworks.mde.embeddedoutputs.OutputDataType;
import com.mathworks.mde.embeddedoutputs.evaluation.EvalCanceledException;
import com.mathworks.mde.embeddedoutputs.evaluation.InterruptManager;
import com.mathworks.mde.embeddedoutputs.evaluation.OutputEventSupport;
import com.mathworks.mde.embeddedoutputs.outputhandlers.TextOutputData;
import com.mathworks.mde.embeddedoutputs.parser.Parser;
import com.mathworks.mde.embeddedoutputs.variables.VariableManager;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MvmCancellationException;
import com.mathworks.mvm.exec.MvmCompileException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.mvm.exec.MvmRuntimeException;
import com.mathworks.util.Log;
import com.mathworks.util.ThreadUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class EvaluationManager {
    private final String fUniqueId;
    private final MVM fMvm;
    private final Parser fParser;
    private final VariableManager fVariableManager;
    private final ExecutorService fExecutorService;

    public EvaluationManager(String string, MVM mVM) {
        this.fMvm = mVM;
        this.fUniqueId = string;
        this.fParser = new Parser();
        this.fVariableManager = new VariableManager(string, mVM);
        this.fExecutorService = ThreadUtils.newSingleDaemonThreadExecutor((String)"evalParser");
    }

    public List<OutputDataType> evalCode(String string, int n) throws EvalCanceledException {
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        FutureEvalResult futureEvalResult = this.fMvm.eval(string, (Writer)stringWriter, (Writer)stringWriter2);
        this.clearVariables(n);
        return this.handleFutureResult((FutureResult<Object>)futureEvalResult, n, stringWriter);
    }

    private void clearVariables(int n) {
        this.fVariableManager.closeVariables(this.fParser.getRegionToMatrixCache(n));
        this.fParser.clearVariables(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OutputDataType> handleFutureResult(FutureResult<Object> futureResult, int n, StringWriter stringWriter) throws EvalCanceledException {
        InterruptManager.addInterruptableFuture(this.fUniqueId, futureResult);
        ArrayList<OutputDataType> arrayList = new ArrayList<OutputDataType>();
        OutputEventSupport outputEventSupport = new OutputEventSupport(this.fMvm);
        try {
            Object object;
            boolean bl = false;
            try {
                futureResult.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (MvmCancellationException mvmCancellationException) {
                throw new EvalCanceledException();
            }
            catch (MvmExecutionException mvmExecutionException) {
                object = mvmExecutionException.getMvmCause();
                if (object instanceof MvmCompileException || object instanceof MvmRuntimeException) {
                    String string = object.getLocalizedMessage();
                    String string2 = string.replaceFirst("Error: ", "");
                    arrayList.add(new OutputDataType("error", new TextOutputData(string2)));
                    bl = true;
                } else {
                    Log.logException((Exception)((Object)mvmExecutionException));
                }
            }
            finally {
                InterruptManager.removeInterruptableFuture(this.fUniqueId, futureResult);
            }
            List<OutputDataType> list = outputEventSupport.getOutputs();
            object = stringWriter.toString();
            if (!((String)object).isEmpty()) {
                object = EvaluationManager.filterOutputString((String)object, list);
                if (bl) {
                    arrayList.add(new OutputDataType("text", new TextOutputData((String)object)));
                } else {
                    arrayList.addAll(this.parseOutputsOnSeperateThread((String)object, n));
                }
            }
            arrayList.addAll(list);
        }
        finally {
            outputEventSupport.dispose();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OutputDataType> parseOutputsOnSeperateThread(final String string, final int n) {
        Future<Object> future = this.fExecutorService.submit(new Callable<List<OutputDataType>>(){

            @Override
            public List<OutputDataType> call() {
                return EvaluationManager.this.fParser.parseOutputString(string, n, EvaluationManager.this.fVariableManager);
            }
        });
        try {
            InterruptManager.addInterruptableFuture(this.fUniqueId, future);
            List list = (List)future.get();
            return list;
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            InterruptManager.removeInterruptableFuture(this.fUniqueId, future);
        }
        return new ArrayList<OutputDataType>();
    }

    private static String filterOutputString(String string, List<OutputDataType> list) {
        String string2 = string;
        for (OutputDataType outputDataType : list) {
            if (!outputDataType.getType().equals("warning")) continue;
            TextOutputData textOutputData = (TextOutputData)outputDataType.getOutputData();
            String string3 = "Warning: " + textOutputData.text + "\n";
            string2 = string2.replace(string3, "");
        }
        return string2;
    }

    public void dispose() {
        this.fVariableManager.dispose();
    }
}

