/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import java.util.concurrent.TimeUnit;

final class ConnectorFactory {
    private static ConnectorState sConnectorState = ConnectorState.NOT_STARTED;
    private static String sPort;
    private static final String START_CONNECTOR_CODE = "internal.examples.setup";

    ConnectorFactory() {
    }

    public static synchronized void start() {
        if (sConnectorState.equals((Object)ConnectorState.RUNNING) || sConnectorState.equals((Object)ConnectorState.STARTING)) {
            return;
        }
        sConnectorState = ConnectorState.STARTING;
        new MatlabWorker<Object>(){

            public Object runOnMatlabThread() throws Exception {
                return 1.feval((String)ConnectorFactory.START_CONNECTOR_CODE, (Object[])new Object[0], (int)1);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                sPort = (String)object;
                sConnectorState = ConnectorState.RUNNING;
            }

            protected void handleException(Exception exception, boolean bl) {
                sConnectorState = ConnectorState.FAILED;
                super.handleException(exception, bl);
            }
        }.start();
    }

    public static boolean isRunning() {
        boolean bl = sConnectorState.equals((Object)ConnectorState.RUNNING);
        if (!bl) {
            return false;
        }
        try {
            MessageServiceFactory.getMessageService();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return false;
        }
        return true;
    }

    public static String getConnectorURL() {
        assert (ConnectorFactory.isRunning()) : "Connector url does not exist because the connector is not running.";
        return "http://localhost:" + sPort + "/";
    }

    public static void runWhenReady(final Runnable runnable) {
        if (ConnectorFactory.isRunning()) {
            runnable.run();
        } else {
            MJUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ConnectorFactory.runWhenReady(runnable);
                }
            }, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    static {
        ConnectorFactory.start();
    }

    public static enum ConnectorState {
        FAILED,
        NOT_STARTED,
        STARTING,
        RUNNING;

    }
}

