/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples;

import com.mathworks.html.UrlBuilder;
import com.mathworks.html.WebUrl;
import com.mathworks.mde.examples.ConnectorFactory;
import com.mathworks.mde.examples.ExampleGalleryEvent;
import com.mathworks.mde.examples.ExampleGalleryEventListener;
import com.mathworks.mde.examples.ExampleGalleryMessage;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ExampleGalleryPage {
    private static final String EXAMPLE_GALLERY_LOCAL_PAGE = "matlab/toolbox/matlab/helptools/examplegallery/index.html";
    private final List<ExampleGalleryEventListener> fEventListener = new ArrayList<ExampleGalleryEventListener>();
    private String fUniqueKey;
    private static final String EVENT_CHANNEL_PREFIX = "/example/events/";
    private final String fEventChannel;
    private Subscriber fEventSusbscriber;

    ExampleGalleryPage(String string) {
        this.fUniqueKey = string;
        this.fEventChannel = EVENT_CHANNEL_PREFIX + this.fUniqueKey;
        this.fEventSusbscriber = new Subscriber(){

            public void handle(Message message) {
                if (message.getData() instanceof Map) {
                    Map map = (Map)message.getData();
                    ExampleGalleryEvent exampleGalleryEvent = new ExampleGalleryEvent(map);
                    for (ExampleGalleryEventListener exampleGalleryEventListener : ExampleGalleryPage.this.fEventListener) {
                        exampleGalleryEventListener.eventFired(exampleGalleryEvent);
                    }
                }
            }
        };
        ConnectorFactory.runWhenReady(new Runnable(){

            @Override
            public void run() {
                ExampleGalleryPage.this.addSubscribers();
            }
        });
    }

    private void addSubscribers() {
        MessageServiceFactory.getMessageService().subscribe(this.fEventChannel, this.fEventSusbscriber);
    }

    public void dispose() {
        MessageServiceFactory.getMessageService().unsubscribe(this.fEventChannel, this.fEventSusbscriber);
    }

    public String getLocalPageUrl() {
        try {
            UrlBuilder urlBuilder = new WebUrl(ConnectorFactory.getConnectorURL() + EXAMPLE_GALLERY_LOCAL_PAGE).toUrlBuilder();
            urlBuilder.addParameter("id", new String[]{this.fUniqueKey});
            return urlBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    void addEventListener(ExampleGalleryEventListener exampleGalleryEventListener) {
        this.fEventListener.add(exampleGalleryEventListener);
    }

    void removeEventListener(ExampleGalleryEventListener exampleGalleryEventListener) {
        this.fEventListener.remove(exampleGalleryEventListener);
    }

    public void publish(ExampleGalleryMessage exampleGalleryMessage) {
        MessageServiceFactory.getMessageService().publish(this.fEventChannel, (Object)exampleGalleryMessage);
    }
}

