/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.mlservices.scc.MWSccManager;
import com.mathworks.mlwidgets.mlservices.scc.SccFileListener;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.FileEvent;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public final class SourceControlActionProvider
implements ActionProvider {
    private static final ActionDefinition SCM_MENU_PLACEHOLDER = new ActionDefinition("scmMenu", CoreMenuSection.DIFF_SCM.getSection(), "scmMenu");
    private final SccAdapter fAdapter = new SccAdapter();

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !this.isMWSourceControlEnabled() && (fileSystemEntry == null || fileSystemEntry.isReal());
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(SCM_MENU_PLACEHOLDER).setMenuComponentProvider(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                MJMenu mJMenu = MWSccManager.getSccMenu((SccFileProvider)SourceControlActionProvider.this.fAdapter);
                SourceControlActionProvider.this.fAdapter.setInput(actionInput);
                return mJMenu;
            }
        });
    }

    private boolean isMWSourceControlEnabled() {
        try {
            SettingPath settingPath = new SettingPath(MvmContext.get(), new String[]{"shared", "matlab", "desktop", "currentfolder", "sourcecontrol"});
            Setting setting = new Setting(settingPath, Boolean.class, "Enabled");
            return (Boolean)setting.get();
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static class SccAdapter
    implements SccFileProvider {
        private SccFileListener fFileListener;
        private String[] fSelectedFiles;
        private Frame fFrame;

        public SccAdapter() {
            MWSccManager.registerSccFileProvider((SccFileProvider)this);
        }

        public void installSccFileListener(SccFileListener sccFileListener) {
            this.fFileListener = sccFileListener;
        }

        public void uinstallSccFileListener() {
            this.fFileListener = null;
        }

        public String[] getSelectedFiles() {
            return (String[])this.fSelectedFiles.clone();
        }

        public Frame getFrame(String string) {
            return this.fFrame;
        }

        public boolean save(String string) {
            File file = new File(string);
            FileStorageLocation fileStorageLocation = new FileStorageLocation(file);
            EditorApplication editorApplication = MLEditorServices.getEditorApplication();
            Editor editor = editorApplication.getEditor((StorageLocation)fileStorageLocation);
            editor.negotiateSave();
            return true;
        }

        void setInput(ActionInput actionInput) {
            this.fFrame = WindowUtils.getFrameForComponent((Component)actionInput.getComponent());
            this.fSelectedFiles = new String[actionInput.getSelection().size()];
            List list = actionInput.getSelection();
            for (int i = 0; i < this.fSelectedFiles.length; ++i) {
                this.fSelectedFiles[i] = ((FileSystemEntry)list.get(i)).getLocation().toString();
            }
            if (this.fFileListener != null) {
                this.fFileListener.fileSelectionChanged(new FileEvent((Object)this, 7));
            }
        }
    }
}

