/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpBrowserPrefs;
import com.mathworks.mde.help.HelpBrowserStateManager;
import com.mathworks.mde.help.HelpNavigator;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.SearchHistoryEventDispatcher;
import com.mathworks.mde.help.SearchHistoryListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.ContentsDataEvent;
import com.mathworks.mlwidgets.help.ContentsDataListener;
import com.mathworks.mlwidgets.help.search.DocSearchEngine;
import com.mathworks.mlwidgets.help.search.SuggestionObserver;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SearchTextFieldHint;
import com.mathworks.widgets.SearchTextFieldIntelliHints;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class SearchInputPanel
extends MJPanel {
    private static final SearchTextFieldHint.Category SUGGESTIONS_CATEGORY;
    private static final int MAX_SUGGESTIONS = 10;
    private static final Pattern INVALID_SUGGESTION_INPUT_PATTERN;
    private final SearchTextField fSearchTextField;
    private final SearchTextFieldIntelliHints fIntelliHints;
    private final HelpNavigator fHelpNavigator;
    private boolean fInToolBar;
    private boolean fLastHistoryEmpty = true;
    private String fSuppressHintsForText = null;

    SearchInputPanel(HelpNavigator helpNavigator) {
        this.fHelpNavigator = helpNavigator;
        this.setLayout(new BorderLayout());
        this.fSearchTextField = new SearchTextField(HelpUtils.getLocalizedString((String)"search.search_for_doc"), (PopupMenuCustomizer)new SearchPopupMenuCustomizer());
        this.fIntelliHints = new SearchTextFieldIntelliHints(this.fSearchTextField);
        this.fIntelliHints.showCategoryHeaders();
        this.loadSearchHistoryForHints();
        this.fSearchTextField.addSearchTextFieldListener((SearchTextField.Listener)new SearchActionListener());
        this.fSearchTextField.getComponent().setName("HelpSearchField");
        this.add(this.fSearchTextField.getComponent(), "Center");
        ContentsData.addContentsDataListener((ContentsDataListener)new SearchFieldContentsDataListener(), (boolean)true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        SearchHistoryEventDispatcher.getInstance().addSearchHistoryListener(new SearchInputSearchHistoryListener());
    }

    void configureForHelpNavigator() {
        this.fInToolBar = false;
        this.setBackground(this.fHelpNavigator.getBackground());
    }

    void configureForToolBar() {
        this.fInToolBar = true;
    }

    public Dimension getPreferredSize() {
        if (this.fInToolBar) {
            Dimension dimension = this.fSearchTextField.getComponent().getPreferredSize();
            return new Dimension(250, dimension.height);
        }
        return super.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.fInToolBar) {
            return this.getPreferredSize();
        }
        return super.getMaximumSize();
    }

    void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            this.fSuppressHintsForText = string;
        }
        this.fIntelliHints.hideHintsPopup();
        if (!string.equals(this.getText())) {
            this.fSearchTextField.setSearchText(string);
            this.fIntelliHints.addCurrentTextAsHint();
        }
    }

    String getText() {
        return this.fSearchTextField.getSearchText();
    }

    public boolean requestFocusInWindow() {
        this.fSearchTextField.requestFocus();
        return true;
    }

    private void loadSearchHistoryForHints() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SearchInputPanel.this.fIntelliHints.addHints(SearchTextFieldHint.createHints((List)SearchInputPanel.getPersistedSearchHistory()));
            }
        }, "Load Search History");
        thread.start();
    }

    private static List<String> getPersistedSearchHistory() {
        List<String> list = HelpBrowserStateManager.getInstance().getSearchHistory();
        return SearchInputPanel.needsTruncating(list) ? SearchInputPanel.truncateSearchHistory(list) : list;
    }

    private void clearSearchTextFieldHistory() {
        this.fIntelliHints.removeAllHintsInCategory(SearchTextFieldHint.RECENT_SEARCHES_CATEGORY);
    }

    List<String> getSearchTextFieldHistory() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.fIntelliHints.getHints();
        for (SearchTextFieldHint searchTextFieldHint : list) {
            if (!searchTextFieldHint.getCategory().equals((Object)SearchTextFieldHint.RECENT_SEARCHES_CATEGORY)) continue;
            arrayList.add(searchTextFieldHint.getDisplayString());
        }
        return arrayList;
    }

    private static boolean needsTruncating(List<String> list) {
        return list != null && list.size() > HelpBrowserPrefs.getSearchHistoryMaximumSize();
    }

    private static List<String> truncateSearchHistory(List<String> list) {
        if (list == null) {
            return null;
        }
        int n = HelpBrowserPrefs.getSearchHistoryMaximumSize();
        int n2 = list.size();
        while (n2 > n) {
            list.remove(n2 - 1);
            n2 = list.size();
        }
        return list;
    }

    private void truncateSearchTextFieldHistoryIfNeeded() {
        List<String> list = this.getSearchTextFieldHistory();
        if (SearchInputPanel.needsTruncating(list)) {
            list = SearchInputPanel.truncateSearchHistory(list);
        }
        this.fIntelliHints.removeAllHintsInCategory(SearchTextFieldHint.RECENT_SEARCHES_CATEGORY);
        this.fIntelliHints.addHints(SearchTextFieldHint.createHints(list));
    }

    private boolean shouldShowHintsForSearchText(String string) {
        return !string.equals(this.fSuppressHintsForText) && SearchInputPanel.validateSearchTextForSuggestions(string);
    }

    private static boolean validateSearchTextForSuggestions(String string) {
        return string != null && string.length() > 0 && !INVALID_SUGGESTION_INPUT_PATTERN.matcher(string).find();
    }

    private void addSuggestions(Collection<String> collection) {
        ArrayList<SearchTextFieldHint> arrayList = new ArrayList<SearchTextFieldHint>();
        for (String string : collection) {
            arrayList.add(new SearchTextFieldHint(string, SUGGESTIONS_CATEGORY));
        }
        this.fIntelliHints.addHints(arrayList);
        this.fIntelliHints.showHintsPopup();
    }

    static {
        INVALID_SUGGESTION_INPUT_PATTERN = Pattern.compile("\\b\\w\\b|[^\\w\\s]");
        String string = HelpUtils.getLocalizedString((String)"search.suggestions_category");
        SUGGESTIONS_CATEGORY = new SearchTextFieldHint.Category(string, 2, SearchTextFieldHint.STARTS_WITH_MATCHER);
    }

    private class SearchPopupMenuCustomizer
    implements PopupMenuCustomizer {
        private ProductFilterAction fProductFilterAction = new ProductFilterAction();
        private HelpAction fHelpAction = new HelpAction();
        private ShowIntelliHintsPopupAction fShowIntelliHintsPopupAction = new ShowIntelliHintsPopupAction();

        private SearchPopupMenuCustomizer() {
        }

        public void customize(JPopupMenu jPopupMenu) {
            jPopupMenu.removeAll();
            jPopupMenu.add(new JMenuItem(this.fShowIntelliHintsPopupAction));
            if (Matlab.isMatlabAvailable()) {
                jPopupMenu.add(new JMenuItem(this.fProductFilterAction));
                jPopupMenu.add(new JMenuItem(this.fHelpAction));
            }
            this.fShowIntelliHintsPopupAction.setEnabled(!SearchInputPanel.this.getSearchTextFieldHistory().isEmpty());
        }

        private class HelpAction
        extends AbstractAction {
            private HelpAction() {
                super(HelpUtils.getLocalizedString((String)"search.menu.help_on_search"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.displayTopic(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh"), "matlab_env_helpsearch_tips", false);
            }
        }

        private class ProductFilterAction
        extends AbstractAction {
            private ProductFilterAction() {
                super(HelpUtils.getLocalizedString((String)"search.menu.filter_by_product") + "...");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLPrefsDialogServices.showPrefsDialog((String)HelpUtils.getLocalizedString((String)"help.title"));
            }
        }

        private class ShowIntelliHintsPopupAction
        extends AbstractAction {
            private ShowIntelliHintsPopupAction() {
                super(HelpUtils.getLocalizedString((String)"search.menu.show_history"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchInputPanel.this.fSearchTextField.setSearchText("");
                SearchInputPanel.this.fIntelliHints.showHintsPopup();
            }
        }
    }

    private class SearchFieldContentsDataListener
    implements ContentsDataListener {
        private SearchFieldContentsDataListener() {
        }

        public void contentsChanged(ContentsDataEvent contentsDataEvent) {
            switch (contentsDataEvent.getType()) {
                case CONTENTS_POPULATED: {
                    this.setTextFieldEnabled(true);
                    break;
                }
                case CONTENTS_CLEARED: {
                    this.setTextFieldEnabled(false);
                    break;
                }
            }
        }

        private void setTextFieldEnabled(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchInputPanel.this.fSearchTextField.setEnabled(bl);
                }
            });
        }
    }

    private class SearchFieldSuggestionObserver
    implements SuggestionObserver {
        private SearchFieldSuggestionObserver() {
        }

        public void suggestionsFound(final String string, final Collection<String> collection) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (string.equals(SearchInputPanel.this.getText())) {
                        SearchInputPanel.this.fIntelliHints.removeAllHintsInCategory(SUGGESTIONS_CATEGORY);
                        if (!collection.isEmpty() && SearchInputPanel.this.shouldShowHintsForSearchText(string)) {
                            SearchInputPanel.this.addSuggestions(collection);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class SearchActionListener
    implements SearchTextField.Listener {
        private String iLastSuggestionText = null;

        private SearchActionListener() {
        }

        public void search(String string) {
            SearchInputPanel.this.fHelpNavigator.docSearch(string, null);
            SearchInputPanel.this.truncateSearchTextFieldHistoryIfNeeded();
            if (!SearchInputPanel.this.getSearchTextFieldHistory().isEmpty() && SearchInputPanel.this.fLastHistoryEmpty) {
                SearchHistoryEventDispatcher.getInstance().searchHistoryAdded();
            }
        }

        public void searchTextChanged(String string) {
            boolean bl = SearchInputPanel.this.shouldShowHintsForSearchText(string);
            if (bl) {
                this.iLastSuggestionText = string;
                DocSearchEngine.getInstance().suggestCommonTerms(string, (SuggestionObserver)new SearchFieldSuggestionObserver(), 10);
            }
            if (!this.shouldKeepPreviousSuggestions(string) || !bl) {
                SearchInputPanel.this.fIntelliHints.removeAllHintsInCategory(SUGGESTIONS_CATEGORY);
            }
            if (string.length() > 0) {
                SearchInputPanel.this.fSuppressHintsForText = null;
            }
        }

        private boolean shouldKeepPreviousSuggestions(String string) {
            if (this.iLastSuggestionText != null) {
                if (string.startsWith(this.iLastSuggestionText)) {
                    return true;
                }
                int n = this.iLastSuggestionText.length();
                return this.iLastSuggestionText.substring(0, n - 1).equals(string);
            }
            return true;
        }

        public void searchCleared() {
            SearchInputPanel.this.fIntelliHints.removeAllHintsInCategory(SUGGESTIONS_CATEGORY);
        }
    }

    private class SearchInputSearchHistoryListener
    implements SearchHistoryListener {
        private SearchInputSearchHistoryListener() {
        }

        @Override
        public void searchHistoryChanged(SearchHistoryEventDispatcher.SearchHistoryEvent searchHistoryEvent) {
            if (searchHistoryEvent == null) {
                return;
            }
            switch (searchHistoryEvent) {
                case SEARCH_HISTORY_ADDED: {
                    SearchInputPanel.this.fLastHistoryEmpty = false;
                    break;
                }
                case SEARCH_HISTORY_CLEARED: {
                    SearchInputPanel.this.fLastHistoryEmpty = true;
                    SearchInputPanel.this.clearSearchTextFieldHistory();
                    break;
                }
                case SEARCH_HISTORY_SIZE_CHANGED: {
                    SearchInputPanel.this.truncateSearchTextFieldHistoryIfNeeded();
                }
            }
        }
    }
}

