/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mde.licensing.borrowing.comparator.MatlabeticalComparator;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.view.BorrowTableFormat;
import com.mathworks.mde.licensing.borrowing.view.BorrowView;
import com.mathworks.mde.licensing.borrowing.view.CenterRenderer;
import com.mathworks.mde.licensing.borrowing.view.FeatureColViewUtil;
import com.mathworks.mde.licensing.borrowing.view.ScrollPaneComponentAdapter;
import com.mathworks.mde.licensing.borrowing.view.SelectableFeature;
import com.mathworks.mde.licensing.borrowing.view.SelectableFeatureImpl;
import com.mathworks.mde.licensing.borrowing.view.SubPanelView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.ListColorUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BorrowViewImpl
implements BorrowView,
SubPanelView {
    public static final String NUMDAYS_SPINNER_NAME = "NumDaysSpinner";
    public static final String DATESTRING_LABEL_NAME = "DateString";
    public static final String BORROW_BUTTON_NAME = "BorrowButton";
    public static final String BORROWFEATURE_PANEL_NAME = "BorrowFeaturePanel";
    public static final String BORROW_TABLE_NAME = "BorrowTable";
    public static final String TABLE_SCROLLPANE_NAME = "TableScrollPane";
    private Collection<SelectableFeature> fSelectableFeatures = new LinkedList<SelectableFeature>();
    EventList<SelectableFeature> featureTableList;
    private BorrowController fController;
    private JPanel contentPanel;
    private MJButton fBorrowButton;
    private MJLabel fDateString = new MJLabel();
    private MJSpinner fNumDaysSpinner;
    private SpinnerNumberModel fSpinnerModel;
    private MJTable borrowTable;
    private BorrowTableFormat borrowFormat;
    private EventTableModel fFeatureTableModel;
    private MatlabeticalComparator featureComparator;
    private int fBorrowForDays = 1;
    private final int fInitDays = 1;
    private final int fMinDays = 1;
    private final int fMaxDays = 30;
    private final int fStepValue = 1;
    private final int NUM_ROWS_TO_DISPLAY = 7;
    private ResourceBundle fResBundle;
    private final Observer fFeatureObserver;
    private final ActionListener fButtonListener;

    public BorrowViewImpl(BorrowController borrowController, ResourceBundle resourceBundle) {
        this.fController = borrowController;
        this.fResBundle = resourceBundle;
        this.fFeatureObserver = new FeatureSelectionObserver();
        this.fButtonListener = new BorrowButtonListener();
        this.createComponents();
    }

    private void createComponents() {
        this.fNumDaysSpinner = new MJSpinner();
        this.fNumDaysSpinner.setName(NUMDAYS_SPINNER_NAME);
        this.fSpinnerModel = new SpinnerNumberModel(1, 1, 30, 1);
        this.fDateString.setName(DATESTRING_LABEL_NAME);
        this.borrowTable = new MJTable();
        this.borrowTable.setName(BORROW_TABLE_NAME);
        this.featureTableList = new BasicEventList();
        this.borrowFormat = new BorrowTableFormat(this.fResBundle);
        this.featureComparator = new MatlabeticalComparator();
    }

    private void createFeatureTableList() {
        for (SelectableFeature feature : this.fSelectableFeatures) {
            feature.deleteObservers();
        }
        this.fSelectableFeatures.clear();
        Collection<Feature> collection = this.fController.getFlexFeatures();
        for (Feature feature : collection) {
            this.fSelectableFeatures.add(new SelectableFeatureImpl(false, feature));
        }
        for (SelectableFeature selectableFeature : this.fSelectableFeatures) {
            selectableFeature.addObserver(this.fFeatureObserver);
        }
        if (!this.featureTableList.isEmpty()) {
            this.featureTableList.clear();
        }
        this.featureTableList.addAll(this.fSelectableFeatures);
        Iterator<Feature> iterator = new SortedList(this.featureTableList, (Comparator)this.featureComparator);
        if (this.fFeatureTableModel == null || this.featureTableList == null) {
            this.fFeatureTableModel = new EventTableModel(iterator, (TableFormat)this.borrowFormat);
        }
    }

    private JPanel buildSubPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new ColumnSpec((Size)Sizes.DLUX7), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0), new ColumnSpec((Size)Sizes.DLUX3), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)10)), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY9), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY4), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY9)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(this.fResBundle.getString("borrowbyname.title"), cellConstraints.xyw(1, 1, 9));
        panelBuilder.addLabel(this.fResBundle.getString("borrow.period.text"), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.createNumberSpinner(), cellConstraints.xy(3, 3));
        this.updateBorrowDateString();
        panelBuilder.add((Component)this.fDateString, cellConstraints.xy(5, 3));
        JComponent jComponent = this.createTable();
        panelBuilder.add((Component)jComponent, cellConstraints.xyw(1, 5, 9));
        this.createButtons();
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)this.fBorrowButton);
        panelBuilder.add((Component)jPanel, cellConstraints.xyw(9, 7, 1));
        return panelBuilder.getPanel();
    }

    private JComponent createNumberSpinner() {
        this.fNumDaysSpinner.setModel((SpinnerModel)this.fSpinnerModel);
        JComponent jComponent = this.fNumDaysSpinner.getEditor();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JFormattedTextField)focusEvent.getSource()).getCaret().setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ((JFormattedTextField)focusEvent.getSource()).getCaret().setVisible(false);
            }
        });
        this.fNumDaysSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                Integer n = (Integer)jSpinner.getValue();
                BorrowViewImpl.this.fBorrowForDays = n;
                BorrowViewImpl.this.updateBorrowDateString();
            }
        });
        return this.fNumDaysSpinner;
    }

    private JComponent createTable() {
        this.createFeatureTableList();
        EventSelectionModel eventSelectionModel = new EventSelectionModel(this.featureTableList);
        eventSelectionModel.setSelectionMode(0);
        this.borrowTable.setModel((TableModel)this.fFeatureTableModel);
        this.borrowTable.setSelectionModel((ListSelectionModel)eventSelectionModel);
        this.borrowTable.getTableHeader().setReorderingAllowed(false);
        FeatureColViewUtil.sizeTableColumnsToContents((JTable)this.borrowTable);
        TableColumnModel tableColumnModel = this.borrowTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        TableColumn tableColumn2 = tableColumnModel.getColumn(2);
        tableColumn2.setMaxWidth(tableColumn2.getMinWidth());
        CenterRenderer centerRenderer = new CenterRenderer();
        TableColumn tableColumn3 = this.borrowTable.getColumnModel().getColumn(2);
        tableColumn3.setCellRenderer(centerRenderer);
        ListColorUtils.setupForList((JTable)this.borrowTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.borrowTable);
        jScrollPane.setName(TABLE_SCROLLPANE_NAME);
        int n = 7 * this.borrowTable.getRowHeight();
        this.borrowTable.setPreferredScrollableViewportSize(new Dimension(0, n));
        this.borrowTable.getParent().setBackground(this.borrowTable.getBackground());
        jScrollPane.addComponentListener(new ScrollPaneComponentAdapter(this.borrowTable));
        return jScrollPane;
    }

    @Override
    public Collection<Feature> getSelectedFeatures() {
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        for (SelectableFeature selectableFeature : this.fSelectableFeatures) {
            if (!selectableFeature.getSelected()) continue;
            linkedList.add(selectableFeature);
        }
        return linkedList;
    }

    @Override
    public void enableBorrowButton() {
        this.fBorrowButton.setEnabled(true);
    }

    @Override
    public void disableBorrowButton() {
        this.fBorrowButton.setEnabled(false);
    }

    @Override
    public JPanel createSubPanelView() {
        this.contentPanel = this.buildSubPanel();
        this.contentPanel.setName(BORROWFEATURE_PANEL_NAME);
        return this.contentPanel;
    }

    @Override
    public int getNumDaysSelected() {
        return this.fBorrowForDays;
    }

    private void createButtons() {
        this.fBorrowButton = new MJButton(this.fResBundle.getString("button.borrow"));
        this.fBorrowButton.setName(BORROW_BUTTON_NAME);
        this.fBorrowButton.setMnemonic(66);
        this.fBorrowButton.addActionListener(this.fButtonListener);
        this.fBorrowButton.setEnabled(false);
    }

    private void updateBorrowDateString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fResBundle.getString("borrow.date.string.until");
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{this.getDisplayDateString()};
        stringBuffer.append(messageFormat.format(objectArray));
        this.fDateString.setText(stringBuffer.toString());
        this.fDateString.revalidate();
        this.fDateString.repaint();
    }

    private String getDisplayDateString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, this.fBorrowForDays - 1);
        Date date = calendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        String string = dateFormat.format(date);
        return string;
    }

    private class FeatureSelectionObserver
    implements Observer {
        private FeatureSelectionObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (object == null && observable instanceof SelectableFeature) {
                SelectableFeature selectableFeature = (SelectableFeature)((Object)observable);
                BorrowViewImpl.this.fController.borrowableFeatureSelected(selectableFeature.getSelected());
            }
        }
    }

    private class BorrowButtonListener
    implements ActionListener {
        private BorrowButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BorrowViewImpl.this.contentPanel.setCursor(Cursor.getPredefinedCursor(3));
                BorrowViewImpl.this.fController.performBorrowAction();
            }
            finally {
                BorrowViewImpl.this.contentPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

