/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.workspace;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.PlotableClientBase;
import com.mathworks.mde.workspace.WorkspaceBrowserResources;
import com.mathworks.mde.workspace.WorkspaceFontPrefs;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceModel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceDialogs;
import com.mathworks.mlwidgets.workspace.WorkspaceTable;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WorkspaceBrowser
extends PlotableClientBase {
    private static WorkspaceBrowser sThis = null;
    private static final String PREF_KEY = "WB_2014b_1";
    private static final String NAME = "Workspace";
    private static final String ACCESSIBLE_NAME = "Table of variables in MATLAB's current workspace";
    private WorkspaceTable fWorkspaceTable = null;
    private MJScrollPane fScrollPane = null;
    private MatlabWorkspaceModel fMwm;
    private static final int COLUMN_WIDTH_MAJOR = 130;
    private static final int COLUMN_WIDTH_MINOR = 50;
    private static final String[] ESA = new String[0];
    private static final LocalChangeListener sChangeListener = new LocalChangeListener();

    public static WorkspaceBrowser getInstance() {
        assert (SwingUtilities.isEventDispatchThread()) : "This method (used by desktop) must be called on the EDT.";
        if (sThis == null) {
            sThis = new WorkspaceBrowser();
        }
        return sThis;
    }

    public static void invoke() {
        MLDesktop.getInstance().showWorkspaceBrowser();
    }

    static void setGraphableNames(final String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        WorkspaceBrowser.invoke();
        if (sThis != null) {
            WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
            workspaceTable.clearSelection();
            int[] nArray = new int[workspaceTable.getRowCount()];
            for (int i = 0; i < workspaceTable.getRowCount(); ++i) {
                nArray[i] = i;
            }
            String[] stringArray2 = workspaceTable.getVariableNames(nArray);
            block1: for (String string : stringArray) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string.equals(stringArray2[i])) continue;
                    workspaceTable.changeSelection(i, workspaceTable.getPrimaryFieldIndex(), true, false);
                    continue block1;
                }
            }
        } else {
            final WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
            workspaceTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    WorkspaceBrowser.setGraphableNames(stringArray);
                    workspaceTable.getModel().removeTableModelListener(this);
                }
            });
        }
    }

    private WorkspaceBrowser() {
        this.setName(NAME);
        this.setLayout(new BorderLayout());
        this.fMwm = new MatlabWorkspaceModel();
        int[] nArray = new int[]{this.fMwm.NAME(), this.fMwm.VALUE()};
        RecordlistTable.setInitialShownColumns((String)PREF_KEY, (int[])nArray, (int)this.fMwm.getFieldCount());
        RecordlistTable.setInitialShownColumnWidths((String)PREF_KEY, (int[])new int[]{130, 130});
        this.fWorkspaceTable = new WorkspaceTable((IRecordlistModel)this.fMwm, PREF_KEY);
        this.fWorkspaceTable.setName("WorkspaceTable");
        this.fWorkspaceTable.getAccessibleContext().setAccessibleName(ACCESSIBLE_NAME);
        this.fWorkspaceTable.setDeletionObserver(WorkspaceDialogs.getDefaultDeletionObserver((IGenericNameSupplier)this.fMwm, (Component)((Object)this)));
        this.fWorkspaceTable.setEditingObserver(WorkspaceDialogs.getDefaultEditingObserver((IGenericNameSupplier)this.fMwm, (Component)((Object)this)));
        this.fWorkspaceTable.addChronSelectionChangeListener((ChangeListener)new PlottingSelectionListener());
        this.fScrollPane = new MJScrollPane((Component)this.fWorkspaceTable);
        this.fScrollPane.setName("WorkspaceScrollPane");
        this.fScrollPane.getAccessibleContext().setAccessibleName(ACCESSIBLE_NAME);
        this.add((Component)this.fScrollPane, "Center");
        this.fScrollPane.getViewport().addMouseListener(this.fWorkspaceTable.getOffTableMouseListener());
        this.setOpaque(false);
        this.setColors();
        this.setBounds(10, 10, 200, 200);
        this.setMultipleInstances(false);
        this.setContextMenu(this.createTitleBarMenu());
        this.setContextActions(this.getContextActions());
        this.fWorkspaceTable.setNoSelectionPopupMenu(this.createNoSelectionMenu());
        new DropTarget((Component)((Object)this), this.fWorkspaceTable.getDropTargetListener());
        WSBPrefs wSBPrefs = new WSBPrefs();
        this.fWorkspaceTable.setFont(FontPrefs.getFontForComponent((String)WorkspaceFontPrefs.DISPLAY_NAME));
        FontPrefs.addFontListener((String)WorkspaceFontPrefs.DISPLAY_NAME, (FontListener)wSBPrefs);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)wSBPrefs);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)wSBPrefs);
        this.fWorkspaceTable.addChronSelectionChangeListener((ChangeListener)sChangeListener);
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (desktop != null) {
            desktop.addClientListener((Component)((Object)this), (DTClientListener)new DTCL());
        }
    }

    private JMenu createTitleBarMenu() {
        MJMenu mJMenu = new MJMenu();
        for (JMenuItem jMenuItem : this.getNoSelectionMenuItems()) {
            if (jMenuItem == null) {
                mJMenu.addSeparator();
                continue;
            }
            mJMenu.add(jMenuItem);
        }
        return mJMenu;
    }

    private Action[] getContextActions() {
        MJAbstractAction mJAbstractAction;
        MJAbstractAction mJAbstractAction2;
        MJAbstractAction mJAbstractAction3;
        MJAbstractAction mJAbstractAction4;
        ArrayList<MJAbstractAction> arrayList = new ArrayList<MJAbstractAction>();
        MJAbstractAction mJAbstractAction5 = this.fWorkspaceTable.getAction(0);
        if (mJAbstractAction5 != null) {
            ContextTargetingManager.setToolName((Action)mJAbstractAction5, (String)DTMenuMergeTag.COPY.toString());
            arrayList.add(mJAbstractAction5);
        }
        if ((mJAbstractAction4 = this.fWorkspaceTable.getAction(200)) != null) {
            ContextTargetingManager.setToolName((Action)mJAbstractAction4, (String)DTMenuMergeTag.PASTE.toString());
            arrayList.add(mJAbstractAction4);
        }
        if ((mJAbstractAction3 = this.fWorkspaceTable.getAction(20)) != null) {
            ContextTargetingManager.setToolName((Action)mJAbstractAction3, (String)DTMenuMergeTag.DELETE.toString());
            arrayList.add(mJAbstractAction3);
        }
        if ((mJAbstractAction2 = this.fWorkspaceTable.getAction(140)) != null) {
            ContextTargetingManager.setToolName((Action)mJAbstractAction2, (String)DTMenuMergeTag.PRINT.toString());
            arrayList.add(mJAbstractAction2);
        }
        if ((mJAbstractAction = this.fWorkspaceTable.getAction(130)) != null) {
            ContextTargetingManager.setToolName((Action)mJAbstractAction, (String)DTMenuMergeTag.PAGE_SETUP.toString());
            arrayList.add(mJAbstractAction);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private MJPopupMenu createNoSelectionMenu() {
        JMenuItem jMenuItem2;
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        for (JMenuItem jMenuItem2 : this.getNoSelectionMenuItems()) {
            if (jMenuItem2 == null) {
                mJPopupMenu.addSeparator();
                continue;
            }
            mJPopupMenu.add(jMenuItem2);
        }
        mJPopupMenu.addSeparator();
        MJAbstractAction mJAbstractAction = this.fWorkspaceTable.getAction(140);
        if (mJAbstractAction != null) {
            mJPopupMenu.add((Action)mJAbstractAction);
        }
        if ((jMenuItem2 = this.fWorkspaceTable.getAction(130)) != null) {
            mJPopupMenu.add((Action)((Object)jMenuItem2));
        }
        return mJPopupMenu;
    }

    private List<JMenuItem> getNoSelectionMenuItems() {
        MJAbstractAction mJAbstractAction;
        JMenu jMenu;
        MJAbstractAction mJAbstractAction2;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        MJAbstractAction mJAbstractAction3 = this.fWorkspaceTable.getAction(10);
        if (mJAbstractAction3 != null) {
            arrayList.add((JMenuItem)new MJMenuItem((Action)mJAbstractAction3));
            arrayList.add(null);
        }
        if ((mJAbstractAction2 = this.fWorkspaceTable.getAction(120)) != null) {
            arrayList.add((JMenuItem)new MJMenuItem((Action)mJAbstractAction2));
        }
        arrayList.add((JMenuItem)new MJMenuItem((Action)((Object)new ClearWorkspaceAction())));
        MJAbstractAction mJAbstractAction4 = this.fWorkspaceTable.getAction(15);
        if (mJAbstractAction4 != null) {
            arrayList.add((JMenuItem)new MJMenuItem((Action)mJAbstractAction4));
        }
        arrayList.add(null);
        JMenu jMenu2 = WorkspaceBrowser.createShowColumnsMenu((RecordlistTable)this.fWorkspaceTable);
        if (jMenu2 != null) {
            arrayList.add(jMenu2);
        }
        if ((jMenu = WorkspaceBrowser.createSortMenu((RecordlistTable)this.fWorkspaceTable)) != null) {
            arrayList.add(jMenu);
        }
        arrayList.add(null);
        MJAbstractAction mJAbstractAction5 = this.fWorkspaceTable.getAction(200);
        if (mJAbstractAction5 != null) {
            arrayList.add((JMenuItem)new MJMenuItem((Action)mJAbstractAction5));
        }
        if ((mJAbstractAction = this.fWorkspaceTable.getAction(50)) != null) {
            MJMenuItem mJMenuItem = new MJMenuItem((Action)mJAbstractAction);
            arrayList.add((JMenuItem)mJMenuItem);
        }
        return arrayList;
    }

    private static JMenu createShowColumnsMenu(RecordlistTable recordlistTable) {
        MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray = recordlistTable.getShowHideMenuItems();
        MJMenu mJMenu = null;
        if (mJCheckBoxMenuItemArray.length > 0) {
            mJMenu = new MJMenu(WorkspaceBrowserResources.getResource("menu.view.choose"));
            mJMenu.setName("ChooseColumns");
            for (int i = 0; i < mJCheckBoxMenuItemArray.length; ++i) {
                mJMenu.add((JMenuItem)mJCheckBoxMenuItemArray[i]);
            }
        }
        return mJMenu;
    }

    private static JMenu createSortMenu(RecordlistTable recordlistTable) {
        MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray = recordlistTable.getSortMenuItems();
        MJMenu mJMenu = null;
        if (mJCheckBoxMenuItemArray.length > 0) {
            mJMenu = new MJMenu(WorkspaceBrowserResources.getResource("menu.view.sort"));
            mJMenu.setName("SortColumns");
            for (int i = 0; i < mJCheckBoxMenuItemArray.length; ++i) {
                mJMenu.add((JMenuItem)mJCheckBoxMenuItemArray[i]);
            }
            MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray2 = recordlistTable.getSortDirectionMenuItems();
            if (mJCheckBoxMenuItemArray2.length > 0) {
                mJMenu.addSeparator();
                for (int i = 0; i < mJCheckBoxMenuItemArray2.length; ++i) {
                    mJMenu.add((JMenuItem)mJCheckBoxMenuItemArray2[i]);
                }
            }
        }
        return mJMenu;
    }

    private void setColors() {
        Color color = ColorPrefs.getTextColor();
        Color color2 = ColorPrefs.getBackgroundColor();
        JViewport jViewport = this.fScrollPane.getViewport();
        this.fWorkspaceTable.setForeground(color);
        ((Component)jViewport).setForeground(color);
        this.fWorkspaceTable.setBackground(color2);
        ((Component)jViewport).setBackground(color2);
    }

    public void requestFocus() {
        this.fWorkspaceTable.requestFocus();
    }

    public static void refresh() {
        WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
        if (workspaceTable != null) {
            workspaceTable.refresh();
        }
    }

    static String[] getGraphableNames() {
        WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
        if (workspaceTable != null) {
            return workspaceTable.getGraphableNames();
        }
        return ESA;
    }

    static String[] getGraphableClasses() {
        WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
        if (workspaceTable != null) {
            return workspaceTable.getGraphableClasses();
        }
        return ESA;
    }

    static String[] getGraphableSizes() {
        WorkspaceTable workspaceTable = WorkspaceBrowser.getWorkspaceTable();
        if (workspaceTable != null) {
            return workspaceTable.getGraphableSizes();
        }
        return ESA;
    }

    static void addChronSelectionChangeListener(ChangeListener changeListener) {
        WorkspaceBrowser.sChangeListener.addChronSelectionChangeListener(changeListener);
    }

    static void removeChronSelectionChangeListener(ChangeListener changeListener) {
        WorkspaceBrowser.sChangeListener.removeChronSelectionChangeListener(changeListener);
    }

    private static WorkspaceTable getWorkspaceTable() {
        if (sThis != null) {
            return WorkspaceBrowser.sThis.fWorkspaceTable;
        }
        return null;
    }

    private class PlottingSelectionListener
    implements ChangeListener,
    Runnable {
        private boolean iIsPending;
        private VariableInfo[] iSelectedVariables = new VariableInfo[0];

        private PlottingSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.iIsPending) {
                this.iIsPending = true;
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            int n;
            Object object;
            Object[] objectArray;
            if (this.iSelectedVariables.length == 2 && (objectArray = WorkspaceBrowser.this.getVariablesToPlot()).length == 2 && objectArray[0] == this.iSelectedVariables[1].fName && objectArray[1] == this.iSelectedVariables[0].fName) {
                object = this.iSelectedVariables[0];
                this.iSelectedVariables[0] = this.iSelectedVariables[1];
                this.iSelectedVariables[1] = object;
            }
            objectArray = WorkspaceBrowser.this.fWorkspaceTable.getSelectedRowsChron();
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (objectArray == null) {
                object = new VariableInfo[]{};
            } else {
                object = new VariableInfo[objectArray.length];
                stringArray = WorkspaceBrowser.this.fWorkspaceTable.getVariableNames((int[])objectArray);
                stringArray2 = WorkspaceBrowser.this.fWorkspaceTable.getVariableClasses((int[])objectArray);
                String[] stringArray3 = WorkspaceBrowser.this.fWorkspaceTable.getVariableDims((int[])objectArray);
                for (n = 0; n < objectArray.length; ++n) {
                    object[n] = new VariableInfo(stringArray[n], stringArray2[n], stringArray3[n]);
                }
            }
            int n2 = n = ((VariableInfo[])object).length != this.iSelectedVariables.length ? 1 : 0;
            if (n == 0 && ((VariableInfo[])object).length > 0) {
                Object[] objectArray2 = (VariableInfo[])this.iSelectedVariables.clone();
                Object[] objectArray3 = (VariableInfo[])object.clone();
                Arrays.sort(objectArray2);
                Arrays.sort(objectArray3);
                assert (objectArray != null);
                for (int i = 0; i < objectArray.length && n == 0; ++i) {
                    n = !((VariableInfo)objectArray2[i]).fName.equals(((VariableInfo)objectArray3[i]).fName) || !((VariableInfo)objectArray2[i]).fClass.equals(((VariableInfo)objectArray3[i]).fClass) || !((VariableInfo)objectArray2[i]).fDims.equals(((VariableInfo)objectArray3[i]).fDims) ? 1 : 0;
                }
            }
            if (n != 0) {
                this.iSelectedVariables = object;
                WorkspaceBrowser.this.setVariablesToPlot(stringArray, stringArray2);
            }
            this.iIsPending = false;
        }
    }

    private static class VariableInfo
    implements Comparable<VariableInfo> {
        private String fName;
        private String fClass;
        private String fDims;

        private VariableInfo(String string, String string2, String string3) {
            this.fName = string;
            this.fClass = string2;
            this.fDims = string3;
        }

        public boolean equals(Object object) {
            return object instanceof VariableInfo && this.fName.equals(((VariableInfo)object).fName);
        }

        public int hashCode() {
            return this.fName.hashCode();
        }

        @Override
        public int compareTo(VariableInfo variableInfo) {
            return this.fName.compareTo(variableInfo.fName);
        }
    }

    static class ClearWorkspaceAction
    extends MJAbstractAction {
        ClearWorkspaceAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "clear-workspace", (ExtendedAction)this);
            this.setComponentName("ClearWorkspace");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.clearAllVariables((boolean)true, (Frame)ClearWorkspaceAction.getFrame((ActionEvent)actionEvent));
        }
    }

    private class DTCL
    extends DTClientAdapter {
        private DTCL() {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            WorkspaceBrowser.this.fMwm.registerInterests();
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            WorkspaceBrowser.this.fWorkspaceTable.savePrefs();
            WorkspaceBrowser.this.fWorkspaceTable.clearSelection();
            WorkspaceBrowser.this.fMwm.unregisterInterests();
        }
    }

    private class WSBPrefs
    implements PrefListener,
    FontListener {
        private WSBPrefs() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("ColorsText") || string.equals("ColorsBackground")) {
                WorkspaceBrowser.this.setColors();
            }
        }

        public void fontChanged(Font font) {
            WorkspaceBrowser.this.fWorkspaceTable.setFont(font);
        }
    }

    private static class LocalChangeListener
    implements ChangeListener {
        private final List<ChangeListener> iSListeners = new Vector<ChangeListener>();

        private LocalChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ChangeEvent changeEvent2 = new ChangeEvent(this);
            for (ChangeListener changeListener : this.iSListeners) {
                changeListener.stateChanged(changeEvent2);
            }
        }

        private void addChronSelectionChangeListener(ChangeListener changeListener) {
            this.iSListeners.add(changeListener);
        }

        private void removeChronSelectionChangeListener(ChangeListener changeListener) {
            this.iSListeners.remove(changeListener);
        }
    }
}

