/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableAngleValue
extends AnimatableNumberValue {
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected short unit;

    public AnimatableAngleValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableAngleValue(AnimationTarget animationTarget, float f, short s) {
        super(animationTarget, f);
        this.unit = s;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableAngleValue animatableAngleValue;
        AnimatableAngleValue animatableAngleValue2 = animatableValue == null ? new AnimatableAngleValue(this.target) : (AnimatableAngleValue)animatableValue;
        float f2 = this.value;
        short s = this.unit;
        if (animatableValue2 != null) {
            animatableAngleValue = (AnimatableAngleValue)animatableValue2;
            if (animatableAngleValue.unit != s) {
                f2 = AnimatableAngleValue.rad(f2, s);
                f2 += f * (AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit) - f2);
                s = 3;
            } else {
                f2 += f * (animatableAngleValue.value - f2);
            }
        }
        if (animatableValue3 != null) {
            animatableAngleValue = (AnimatableAngleValue)animatableValue3;
            if (animatableAngleValue.unit != s) {
                f2 += (float)n * AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit);
                s = 3;
            } else {
                f2 += (float)n * animatableAngleValue.value;
            }
        }
        if (animatableAngleValue2.value != f2 || animatableAngleValue2.unit != s) {
            animatableAngleValue2.value = f2;
            animatableAngleValue2.unit = s;
            animatableAngleValue2.hasChanged = true;
        }
        return animatableAngleValue2;
    }

    public short getUnit() {
        return this.unit;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableAngleValue animatableAngleValue = (AnimatableAngleValue)animatableValue;
        return Math.abs(AnimatableAngleValue.rad(this.value, this.unit) - AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit));
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableAngleValue(this.target, 0.0f, 1);
    }

    @Override
    public String getCssText() {
        return super.getCssText() + UNITS[this.unit];
    }

    public static float rad(float f, short s) {
        switch (s) {
            case 3: {
                return f;
            }
            case 4: {
                return (float)Math.PI * f / 200.0f;
            }
        }
        return (float)Math.PI * f / 180.0f;
    }
}

