/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs;

import com.mathworks.storage.provider.ProviderChannel;
import com.mathworks.storage.provider.ProviderErrorCode;
import com.mathworks.storage.provider.ProviderException;
import com.mathworks.storage.provider.StorageURI;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;

public final class HDFSProviderChannel
implements ProviderChannel {
    private FSDataInputStream inputstream_;
    private FSDataOutputStream outputstream_;
    private FileStatus metadata_;
    private StorageURI location_;

    public static HDFSProviderChannel openReadOnly(FSDataInputStream fis, FileStatus fileMetadata, StorageURI uri) throws ProviderException {
        return new HDFSProviderChannel(fis, fileMetadata, uri);
    }

    public static ProviderChannel openForWrite(FSDataOutputStream fos, FileStatus fileMetadata, StorageURI uri) throws ProviderException {
        return new HDFSProviderChannel(fos, fileMetadata, uri);
    }

    private HDFSProviderChannel(FSDataInputStream fis, FileStatus fileMetadata, StorageURI uri) {
        this.inputstream_ = fis;
        this.outputstream_ = null;
        this.metadata_ = fileMetadata;
        this.location_ = uri;
    }

    private HDFSProviderChannel(FSDataOutputStream fos, FileStatus fileMetadata, StorageURI uri) {
        this.inputstream_ = null;
        this.outputstream_ = fos;
        this.metadata_ = fileMetadata;
        this.location_ = uri;
    }

    private HDFSProviderChannel(FSDataInputStream fis, FSDataOutputStream fos, FileStatus fileMetadata, StorageURI uri) {
        this.inputstream_ = fis;
        this.outputstream_ = fos;
        this.metadata_ = fileMetadata;
        this.location_ = uri;
    }

    public int read(ByteBuffer dst) throws ProviderException {
        try {
            boolean hasArray = dst.hasArray();
            int capacity = dst.capacity();
            byte[] buffer = hasArray ? dst.array() : new byte[capacity];
            int retval = this.inputstream_.read(buffer);
            if (!hasArray) {
                dst.put(buffer);
            }
            return retval;
        }
        catch (Exception e) {
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }

    public int write(ByteBuffer src) throws ProviderException {
        try {
            this.outputstream_.write(src.array(), 0, src.array().length);
            return this.outputstream_.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }

    public long position() throws ProviderException {
        try {
            if (this.inputstream_ != null) {
                return this.inputstream_.getPos();
            }
            if (this.outputstream_ != null) {
                return this.outputstream_.getPos();
            }
            return 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }

    public void position(long newPosition) throws ProviderException {
        try {
            if (this.inputstream_ != null) {
                this.inputstream_.seek(newPosition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }

    public long size() throws ProviderException {
        return this.metadata_.getLen();
    }

    public void close() throws ProviderException {
        try {
            if (this.outputstream_ != null) {
                this.outputstream_.close();
            }
            if (this.inputstream_ != null) {
                this.inputstream_.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProviderException(ProviderErrorCode.ResourceNotFound, this.location_);
        }
    }
}

