/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.mlx;

import com.mathworks.services.mlx.MlxFile;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FilenameUtils;

public class MlxFileUtils {
    private MlxFileUtils() {
    }

    public static MlxFile read(File file) throws IOException {
        String string = null;
        String string2 = MlxFileUtils.nativeReadRichTextMlxFile(file.getAbsolutePath());
        try {
            string = MlxFileUtils.nativeReadRichTextOutputMlxFile(file.getAbsolutePath());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new MlxFile(string2, string);
    }

    public static void write(File file, MlxFile mlxFile) throws IOException {
        try {
            MlxFileUtils.nativeWriteRichTextMlxFile(file.getAbsolutePath(), mlxFile.getDocument());
            MlxFileUtils.nativeWriteRichTextOutputMlxFile(file.getAbsolutePath(), mlxFile.getOutput());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static boolean isMlxEnabled() {
        if (MlxFileUtils.isMlxAvailable()) {
            try {
                Setting<Boolean> setting = MlxFileUtils.getMlxFilterSetting();
                return setting.get();
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    private static Setting<Boolean> getMlxFilterSetting() {
        SettingPath settingPath = SettingUtils.getSettingPath("matlab", "desktop");
        return SettingUtils.getSetting(settingPath, Boolean.class, "EnableMlxSupport");
    }

    public static void setMlxEnabled(boolean bl) {
        assert (MlxFileUtils.isMlxAvailable()) : "The MLX feature is only supported when mlx is available.  Call isMlxAvailable() before calling this method.";
        try {
            Setting<Boolean> setting = MlxFileUtils.getMlxFilterSetting();
            setting.set((Boolean)bl, SettingLevel.SESSION);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isMlxAvailable() {
        return true;
    }

    public static boolean isMlxFile(String string) {
        return MlxFileUtils.fileHasMlxExtension(string);
    }

    private static boolean fileHasMlxExtension(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return FilenameUtils.isExtension((String)string, (String)"mlx");
    }

    public static boolean isMlxExtensionFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return FilenameUtils.isExtension((String)string, (String)"mlx");
    }

    public static String getCode(File file) throws IOException {
        MlxFileUtils.assertIsMlxFile(file);
        try {
            return MlxFileUtils.nativeReadMlxFile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static void writeCode(File file, String string) throws IOException {
        MlxFileUtils.assertIsMlxFile(file);
        try {
            MlxFileUtils.nativeWriteMlxFile(file.getAbsolutePath(), string);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static void writeCode(File file, Document document) throws IOException {
        boolean bl = file.exists();
        StringWriter stringWriter = new StringWriter();
        try {
            FileUtils.writeDocumentContents((Document)document, (Writer)stringWriter);
            MlxFileUtils.writeCode(file, stringWriter.toString());
            FileUtils.notifyFileSystemOfFileChange((File)file, (boolean)bl);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    public static void createEmptyMlxFile(File file) throws IOException {
        MlxFileUtils.writeCode(file, "");
    }

    public static boolean isPlainTextMlx(File file) {
        try {
            String string = file.getAbsolutePath();
            return MlxFileUtils.isMlxFile(string) && MlxFileUtils.nativeIsPlainCode(string);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static Setting<Boolean> getEnableRichScriptSupportSetting() throws SettingNotFoundException, SettingTypeException {
        SettingPath settingPath = SettingUtils.getSettingPath("matlab", "desktop");
        return SettingUtils.getSetting(settingPath, Boolean.class, "EnableRichScriptSupport");
    }

    public static boolean isRichScriptEnabled() {
        try {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void assertIsMlxFile(File file) {
        assert (MlxFileUtils.isMlxFile(file.getAbsolutePath())) : "File " + file.getAbsolutePath() + " is not an MLX file.";
    }

    private static native void nativeWriteMlxFile(String var0, String var1);

    private static native void nativeWriteRichTextOutputMlxFile(String var0, String var1);

    private static native void nativeWriteRichTextMlxFile(String var0, String var1);

    private static native String nativeReadRichTextOutputMlxFile(String var0);

    private static native String nativeReadMlxFile(String var0);

    private static native String nativeReadRichTextMlxFile(String var0);

    private static native boolean nativeIsPlainCode(String var0);

    static {
        try {
            System.loadLibrary("nativeservices");
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
    }
}

