/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class SettingTypeException
extends SettingException {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.mathworks.services.settings.resources.RES_Settings");
    private final Class<?> fActualType;
    private final Class<?> fExpectedType;

    public SettingTypeException(String string) {
        super(string);
        this.fActualType = null;
        this.fExpectedType = null;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, Class<?> clazz2) {
        super(MessageFormat.format(RESOURCE.getString("SettingTypeError"), setting.fullPath(), SettingTypeException.getTypeName(clazz2), SettingTypeException.getTypeName(clazz)));
        this.fActualType = clazz;
        this.fExpectedType = clazz2;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        super(MessageFormat.format(RESOURCE.getString("SettingCompositeTypeError"), setting.fullPath(), SettingTypeException.getTypeName(clazz), SettingTypeException.getTypeName(clazz3), SettingTypeException.getTypeName(clazz2)));
        this.fActualType = clazz2;
        this.fExpectedType = clazz3;
    }

    public SettingTypeException(Setting<?> setting) {
        super(MessageFormat.format(RESOURCE.getString("SettingNodeTypeError"), setting.fullPath(), setting.isNodeExpected() ? "node" : "key", setting.isNodeExpected() ? "key" : "node"));
        this.fActualType = null;
        this.fExpectedType = null;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, String string) {
        super(MessageFormat.format(RESOURCE.getString("SettingKeyValueError"), setting.fullPath(), SettingTypeException.getTypeName(clazz), string));
        this.fActualType = setting.getType();
        this.fExpectedType = setting.getType();
    }

    public Class<?> getActualType() {
        return this.fActualType;
    }

    public Class<?> getExpectedType() {
        return this.fExpectedType;
    }

    static String getTypeName(Class<?> clazz) {
        if (clazz == null) {
            return "unknown";
        }
        String string = clazz.getName();
        if (clazz.isArray()) {
            String string2;
            int n = string.lastIndexOf(91) + 1;
            if (string.charAt(n) == 'L') {
                assert (string.charAt(string.length() - 1) == ';');
                string2 = string.substring(n + 1, string.length() - 1);
            } else {
                assert (string.length() == n + 1);
                switch (string.charAt(n)) {
                    case 'Z': {
                        string2 = "boolean";
                        break;
                    }
                    case 'B': {
                        string2 = "byte";
                        break;
                    }
                    case 'C': {
                        string2 = "char";
                        break;
                    }
                    case 'D': {
                        string2 = "double";
                        break;
                    }
                    case 'F': {
                        string2 = "float";
                        break;
                    }
                    case 'I': {
                        string2 = "int";
                        break;
                    }
                    case 'J': {
                        string2 = "long";
                        break;
                    }
                    case 'S': {
                        string2 = "short";
                        break;
                    }
                    default: {
                        string2 = string.substring(n, string.length());
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            while (n-- > 0) {
                stringBuilder.append("[]");
            }
            string = stringBuilder.toString();
        }
        if (string.startsWith("java.lang.")) {
            string = string.substring("java.lang.".length());
        } else if (string.startsWith("com.mathworks.util.types.")) {
            string = string.substring("com.mathworks.util.types.".length());
        }
        return string;
    }
}

