/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.compare.concr.ComparisonUtilities;
import com.mathworks.comparisons.compare.concr.ListComparisonGenerator;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceUtilities;
import com.mathworks.comparisons.util.UserCancellationException;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class AsynchronousComparison
implements Runnable,
ComparisonUtilities.UserInterrupt {
    private ComparisonSource fLeft;
    private ComparisonSource fRight;
    private ListComparisonGenerator fParent;
    private Element fElement;
    private volatile boolean fCancelComparison = false;

    AsynchronousComparison(ListComparisonGenerator listComparisonGenerator, ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Element element) {
        assert (!(ComparisonSourceUtilities.isFolder(comparisonSource) ^ ComparisonSourceUtilities.isFolder(comparisonSource2)));
        this.fLeft = comparisonSource;
        this.fRight = comparisonSource2;
        this.fParent = listComparisonGenerator;
        this.fElement = element;
    }

    @Override
    public boolean isCancelled() {
        return this.fCancelComparison;
    }

    public void cancel() {
        this.fCancelComparison = true;
    }

    @Override
    public void run() {
        assert (!SwingUtilities.isEventDispatchThread());
        String string = "skipped";
        if (!this.isCancelled()) {
            this.fParent.updateReport(ComparisonSourceUtilities.getName(this.fLeft), "comparing", this.fElement);
            try {
                boolean bl = ComparisonSourceUtilities.isFolder(this.fLeft) ? ComparisonUtilities.compareFolders(this.fLeft, this.fRight, this) : ComparisonUtilities.compareFiles(this.fLeft, this.fRight, this);
                string = bl ? "yes" : "no";
            }
            catch (UserCancellationException userCancellationException) {
                assert (this.isCancelled());
            }
            catch (Exception exception) {
                String string2 = exception.getMessage();
                if (string2 == null || string2.length() == 0) {
                    System.out.println(exception);
                }
                System.out.println(string2);
            }
        }
        this.fParent.updateReport(ComparisonSourceUtilities.getName(this.fLeft), string, this.fElement);
    }
}

