/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.prefs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class PreferenceManager {
    private static final String MAP_SEP = "|";
    private static final String ITEM_SEP = ";";

    public abstract String getString();

    public abstract void setString(String var1);

    public String[] getStringArray() {
        String string = this.getString();
        if (string.trim().length() == 0) {
            return new String[0];
        }
        return string.split(ITEM_SEP);
    }

    public Collection<String> getStringCollection() {
        return Arrays.asList(this.getStringArray());
    }

    public void setStringArray(String[] stringArray) {
        this.setString(PreferenceManager.convertStringArray(stringArray));
    }

    public void setStringCollection(Collection<String> collection) {
        this.setString(PreferenceManager.convertStringCollection(collection));
    }

    protected static String convertStringCollection(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(ITEM_SEP);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected static String convertStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        return PreferenceManager.convertStringCollection(Arrays.asList(stringArray));
    }

    public Map<String, String> getStringMap() {
        String string = this.getString();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.trim().length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(ITEM_SEP)) {
                String[] stringArray2 = string2.split("\\|");
                if (stringArray2.length != 2) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return hashMap;
    }

    public void setStringMap(Map<String, String> map) {
        this.setString(PreferenceManager.convertStringMap(map));
    }

    protected static String convertStringMap(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (String string : map.keySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(ITEM_SEP);
                }
                stringBuilder.append(string);
                stringBuilder.append(MAP_SEP);
                stringBuilder.append(map.get(string));
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, Collection<String>> getStringCollectionMap() {
        String[] stringArray;
        LinkedHashMap<String, Collection<String>> linkedHashMap = new LinkedHashMap<String, Collection<String>>();
        String string = this.getString();
        for (String string2 : stringArray = string.split("\\|")) {
            String[] stringArray2 = string2.split(ITEM_SEP);
            if (stringArray2.length < 2) continue;
            String string3 = stringArray2[0];
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 1; i < stringArray2.length; ++i) {
                linkedList.add(stringArray2[i]);
            }
            linkedHashMap.put(string3, linkedList);
        }
        return linkedHashMap;
    }

    public void setStringCollectionMap(Map<String, Collection<String>> map) {
        this.setString(PreferenceManager.convertStringCollectionMap(map));
    }

    protected static String convertStringCollectionMap(Map<String, Collection<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (String string : map.keySet()) {
                stringBuilder.append(string);
                for (String string2 : map.get(string)) {
                    stringBuilder.append(ITEM_SEP);
                    stringBuilder.append(string2);
                }
                stringBuilder.append(MAP_SEP);
            }
        }
        return stringBuilder.toString();
    }
}

