/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.register.type;

import com.mathworks.comparisons.compare.Comparison;
import com.mathworks.comparisons.compare.concr.TextComparison;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterColumnsVisible;
import com.mathworks.comparisons.param.parameter.CParameterIgnoreWhitespace;
import com.mathworks.comparisons.param.parameter.CParameterShowDifferencesOnly;
import com.mathworks.comparisons.prefs.ComparisonPrefsManager;
import com.mathworks.comparisons.prefs.preference.CPreferenceColumnsVisible;
import com.mathworks.comparisons.prefs.preference.CPreferenceIgnoreWhitespace;
import com.mathworks.comparisons.prefs.preference.CPreferenceShowDifferencesOnly;
import com.mathworks.comparisons.register.ComparisonTypeDeterminant;
import com.mathworks.comparisons.register.ComparisonTypeDeterminantValueChecker;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.register.analyze.CTDAnalyzerMlxFile;
import com.mathworks.comparisons.register.check.BinarySourceChecker;
import com.mathworks.comparisons.register.check.CTDValueCheckerTrue;
import com.mathworks.comparisons.register.datatype.CDataTypeText;
import com.mathworks.comparisons.register.determinant.BinaryContentsDeterminant;
import com.mathworks.comparisons.register.determinant.MlxFileDeterminant;
import com.mathworks.comparisons.register.impl.ComparisonTypeImpl;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.impl.MlxFileSource;
import com.mathworks.comparisons.source.impl.TextMergeAwareComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.Map;

public class ComparisonTypeText
extends ComparisonTypeImpl {
    private final BinaryContentsDeterminant fBinaryContentsDeterminant = BinaryContentsDeterminant.getInstance();
    private final MlxFileDeterminant fMlxFileDeterminant = MlxFileDeterminant.getInstance();
    private final ComparisonTypeDeterminantValueChecker<BinaryContentsDeterminant> fBinarySourceChecker = new BinarySourceChecker();

    public ComparisonTypeText() {
        super(ResourceManager.getString("comparisondescription.text"), CDataTypeText.getInstance());
        this.addDeterminant(this.fBinaryContentsDeterminant);
        this.addDeterminant(this.fMlxFileDeterminant);
        this.addFeature(ComparisonTypeFeature.CANRUNWITHOUTDISPLAY);
        this.setDefaultParameters();
    }

    @Override
    public boolean checkDeterminantValues(Map<ComparisonTypeDeterminant, Object> map) {
        boolean bl = false;
        if (map.containsKey(this.fMlxFileDeterminant)) {
            bl = new CTDValueCheckerTrue().checkValue(this.fMlxFileDeterminant, map.get(this.fMlxFileDeterminant));
        }
        if (!bl && map.containsKey(this.fBinaryContentsDeterminant)) {
            bl = !this.fBinarySourceChecker.checkValue(this.fBinaryContentsDeterminant, map.get(this.fBinaryContentsDeterminant));
        }
        return bl;
    }

    @Override
    public Comparison<String> createComparison() {
        this.setDefaultParameters();
        return new TextComparison();
    }

    private void setDefaultParameters() {
        this.setDefaultParameter(CParameterColumnsVisible.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceColumnsVisible.getInstance()));
        this.setDefaultParameter(CParameterIgnoreWhitespace.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceIgnoreWhitespace.getInstance()));
        this.setDefaultParameter(CParameterShowDifferencesOnly.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceShowDifferencesOnly.getInstance()));
    }

    @Override
    public ComparisonSource prepareForComparison(ComparisonSource comparisonSource) {
        if (ComparisonTypeText.isMlxFile(comparisonSource)) {
            return new TextMergeAwareComparisonSource(new MlxFileSource(comparisonSource));
        }
        return new TextMergeAwareComparisonSource(comparisonSource);
    }

    private static boolean isMlxFile(ComparisonSource comparisonSource) {
        return new CTDAnalyzerMlxFile().getValue(comparisonSource);
    }

    @Override
    public void prepareForComparison(ComparisonParameterSet comparisonParameterSet) {
        if (!comparisonParameterSet.hasParameter(CParameterColumnsVisible.getInstance())) {
            comparisonParameterSet.setValue(CParameterColumnsVisible.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceColumnsVisible.getInstance()));
        }
        if (!comparisonParameterSet.hasParameter(CParameterIgnoreWhitespace.getInstance())) {
            comparisonParameterSet.setValue(CParameterIgnoreWhitespace.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceIgnoreWhitespace.getInstance()));
        }
        if (!comparisonParameterSet.hasParameter(CParameterShowDifferencesOnly.getInstance())) {
            comparisonParameterSet.setValue(CParameterShowDifferencesOnly.getInstance(), ComparisonPrefsManager.getInstance().getValue(CPreferenceShowDifferencesOnly.getInstance()));
        }
        super.prepareForComparison(comparisonParameterSet);
    }
}

