/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection;

import com.mathworks.comparisons.param.ComparisonParameter;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.impl.ComparisonParameterSetImpl;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.Collection;

public class ComparisonSelection
implements ComparisonParameterSet {
    private final SelectionPoliciesRegister fSelectionPoliciesRegister;
    private final SingleSelection[] fSelections = new SingleSelection[]{new SingleSelection(), new SingleSelection()};
    private ComparisonType fComparisonType = null;
    private final ComparisonParameterSet fComparisonParameterSet = new ComparisonParameterSetImpl();

    public ComparisonSelection(SelectionPoliciesRegister selectionPoliciesRegister) {
        this.fSelectionPoliciesRegister = selectionPoliciesRegister;
    }

    public ComparisonSelection(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        this.fSelections[0].setComparisonSource(comparisonSource);
        this.fSelections[1].setComparisonSource(comparisonSource2);
        this.fSelectionPoliciesRegister = null;
    }

    public SelectionDataType getSelectionDataType(Index index) {
        return this.fSelections[index.ordinal()].getSelectionDataType();
    }

    public Object getSelection(Index index) {
        return this.fSelections[index.ordinal()].getSelection();
    }

    public <T> void setSelection(Index index, SelectionDataType<T> selectionDataType, T t) {
        if (this.fSelectionPoliciesRegister != null && this.fSelections[index.ordinal()].setSelection(selectionDataType, t)) {
            this.fComparisonType = null;
        }
    }

    public ComparisonSource getComparisonSource(Index index) {
        return this.fSelections[index.ordinal()].getComparisonSource();
    }

    public void convertToComparisonSource(Index index) throws InvalidConversionException {
        if (this.fSelectionPoliciesRegister != null && this.fSelections[index.ordinal()].convertToComparisonSource()) {
            this.fComparisonType = null;
        }
    }

    public ComparisonType getComparisonType() {
        return this.fComparisonType;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        this.fComparisonType = comparisonType;
    }

    public void swap() {
        this.refresh();
        SingleSelection singleSelection = this.fSelections[0];
        this.fSelections[0] = this.fSelections[1];
        this.fSelections[1] = singleSelection;
    }

    public void refresh() {
        this.fSelections[0].refresh();
        this.fSelections[1].refresh();
    }

    public boolean hasSelection(Index index) {
        return this.fSelections[index.ordinal()].hasSelection();
    }

    public boolean hasComparisonSource(Index index) {
        return this.fSelections[index.ordinal()].hasComparisonSource();
    }

    public boolean hasSelections() {
        return this.fSelections[0].hasSelection() && this.fSelections[1].hasSelection();
    }

    public boolean hasComparisonSources() {
        return this.fSelections[0].hasComparisonSource() && this.fSelections[1].hasComparisonSource();
    }

    public boolean hasComparisonType() {
        return this.fComparisonType != null;
    }

    public boolean isSelectionReady() {
        return this.fSelections[0].hasComparisonSource() && this.fSelections[1].hasComparisonSource() && this.fComparisonType != null;
    }

    public void prepareForComparison() {
        if (this.isSelectionReady()) {
            this.fSelections[0].prepareSourceForComparison();
            this.fSelections[1].prepareSourceForComparison();
            this.fComparisonType.prepareForComparison(this.fComparisonParameterSet);
        }
    }

    @Override
    public synchronized void dispose() {
        this.fSelections[0].dispose();
        this.fSelections[1].dispose();
        this.fComparisonParameterSet.dispose();
        this.fComparisonType = null;
    }

    @Override
    public Collection<ComparisonParameter> getParameters() {
        return this.fComparisonParameterSet.getParameters();
    }

    @Override
    public boolean hasParameter(ComparisonParameter comparisonParameter) {
        return this.fComparisonParameterSet.hasParameter(comparisonParameter);
    }

    @Override
    public void removeParameter(ComparisonParameter comparisonParameter) {
        this.fComparisonParameterSet.removeParameter(comparisonParameter);
    }

    @Override
    public Object getValue(ComparisonParameter comparisonParameter) {
        return this.fComparisonParameterSet.getValue(comparisonParameter);
    }

    @Override
    public void setValue(ComparisonParameter comparisonParameter, Object object) {
        this.fComparisonParameterSet.setValue(comparisonParameter, object);
    }

    @Override
    public void addAll(ComparisonParameterSet comparisonParameterSet) {
        for (ComparisonParameter comparisonParameter : comparisonParameterSet.getParameters()) {
            this.setValue(comparisonParameter, comparisonParameterSet.getValue(comparisonParameter));
        }
    }

    private class SingleSelection {
        private SelectionDataType fSelectionDataType = null;
        private Object fSelectionObject = null;
        private ComparisonSource fComparisonSource = null;
        private boolean fIsComparisonSourcePrepared = false;

        private SingleSelection() {
        }

        public <T> boolean setSelection(SelectionDataType<T> selectionDataType, T t) {
            assert (selectionDataType != null);
            boolean bl = false;
            if (t == null || selectionDataType.getApplicableType().isAssignableFrom(t.getClass()) || t.getClass().equals(String.class)) {
                if (this.fSelectionObject == null || !this.fSelectionObject.equals(t)) {
                    this.fComparisonSource = null;
                    this.fIsComparisonSourcePrepared = false;
                    this.fSelectionObject = t;
                    this.fSelectionDataType = selectionDataType;
                    bl = true;
                }
            } else {
                throw new IllegalArgumentException(ResourceManager.format("exception.incompatibleclasses", t.getClass().getName(), selectionDataType.getApplicableType().getName()));
            }
            return bl;
        }

        public SelectionDataType getSelectionDataType() {
            return this.fSelectionDataType;
        }

        public Object getSelection() {
            return this.fSelectionObject;
        }

        public boolean hasSelection() {
            return this.fSelectionObject != null;
        }

        public boolean convertToComparisonSource() throws InvalidConversionException {
            boolean bl = false;
            if (this.fComparisonSource == null && this.fSelectionObject != null) {
                this.fComparisonSource = ComparisonSelection.this.fSelectionPoliciesRegister.convertToComparisonSource(this.fSelectionDataType, this.fSelectionObject);
                bl = true;
            }
            return bl;
        }

        public ComparisonSource getComparisonSource() {
            return this.fComparisonSource;
        }

        public void setComparisonSource(ComparisonSource comparisonSource) {
            this.fComparisonSource = comparisonSource;
        }

        public void refresh() {
            if (this.fComparisonSource != null) {
                this.fComparisonSource.refresh();
            }
        }

        public void prepareSourceForComparison() {
            if (!this.fIsComparisonSourcePrepared) {
                this.fComparisonSource = ComparisonSelection.this.fComparisonType.prepareForComparison(this.fComparisonSource);
                this.fIsComparisonSourcePrepared = true;
            }
        }

        public boolean hasComparisonSource() {
            return this.fComparisonSource != null;
        }

        public void dispose() {
            if (this.fComparisonSource != null) {
                this.fComparisonSource.dispose();
                this.fComparisonSource = null;
                this.fIsComparisonSourcePrepared = false;
            }
            if (this.fSelectionDataType != null) {
                this.fSelectionDataType = null;
            }
            if (this.fSelectionObject != null) {
                this.fSelectionObject = null;
            }
        }
    }

    public static enum Index {
        FIRST,
        SECOND;

    }
}

