/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.event.ComparisonEventSupport;
import com.mathworks.comparisons.event.data.CEventDataSelectionDialogCreated;
import com.mathworks.comparisons.event.data.CEventDataSelectionDialogDisposed;
import com.mathworks.comparisons.event.data.CEventDataSelectionReady;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.report.ComparisonReport;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.selection.dialog.SourceSelectionPanelBuilder;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;

public class SourceSelectionDialog {
    public static final String SOURCE_SELECTION_DIALOG = "SourceSelectionDialog";
    private final ComparisonEventSupport fEventSupport = new ComparisonEventSupport();
    private final SourceSelectionPanelBuilder fPanelBuilder;
    private MJPanel fPanel = null;
    private MJDialog fDialog = null;
    private ComparisonReport fParentReport = null;

    public SourceSelectionDialog(ComparisonEventListener comparisonEventListener, ComparisonTypeRegister comparisonTypeRegister, SelectionPoliciesRegister selectionPoliciesRegister, SourceSelectionListModel sourceSelectionListModel, ComparisonSelection comparisonSelection) {
        this.fEventSupport.addComparisonEventListener(comparisonEventListener);
        this.fPanelBuilder = new SourceSelectionPanelBuilder(comparisonTypeRegister, selectionPoliciesRegister, sourceSelectionListModel, comparisonSelection);
    }

    public void showDialog() {
        if (this.fDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceSelectionDialog.this.doShowDialog();
                }
            });
        }
    }

    private synchronized void doShowDialog() {
        if (this.fDialog != null) {
            this.fPanelBuilder.setInitialSelections();
            this.fDialog.setVisible(true);
        }
    }

    public void attach(final ComparisonReport comparisonReport) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!((Object)((Object)comparisonReport)).equals((Object)SourceSelectionDialog.this.fParentReport)) {
                    boolean bl = SourceSelectionDialog.this.fDialog == null || SourceSelectionDialog.this.fDialog.isVisible();
                    SourceSelectionDialog.this.fParentReport = comparisonReport;
                    SourceSelectionDialog.this.destroy();
                    SourceSelectionDialog.this.create();
                    if (bl) {
                        SourceSelectionDialog.this.fEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionDialogCreated.getInstance()));
                    }
                }
            }
        });
    }

    public void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceSelectionDialog.this.destroy();
                SourceSelectionDialog.this.fPanelBuilder.dispose();
                SourceSelectionDialog.this.fPanel = null;
                SourceSelectionDialog.this.fEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionDialogDisposed.getInstance()));
                SourceSelectionDialog.this.fEventSupport.removeAllComparisonEventListeners();
            }
        });
    }

    private synchronized void create() {
        assert (SwingUtilities.isEventDispatchThread()) : "Wrong thread";
        if (this.fDialog == null) {
            if (this.fPanel == null) {
                this.fPanelBuilder.createPanel();
                this.fPanelBuilder.addCompareActionListener(new CompareAction());
                this.fPanelBuilder.addCancelActionListener(new CancelAction());
                this.fPanel = (MJPanel)this.fPanelBuilder.getComponent();
            }
            this.fDialog = new MJDialog((Frame)SwingUtilities.windowForComponent((Component)((Object)this.fParentReport)), false);
            this.fDialog.setDefaultCloseOperation(1);
            this.fDialog.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    if (SourceSelectionDialog.this.fParentReport != null) {
                        SourceSelectionDialog.this.fParentReport.close();
                    }
                }
            });
            this.fDialog.setContentPane((Container)this.fPanel);
            this.fDialog.setName(SOURCE_SELECTION_DIALOG);
            this.fDialog.setTitle(ResourceManager.getString("selectiondialog.title"));
            this.fDialog.pack();
            this.fDialog.setMinimumSize(this.fDialog.getPreferredSize());
            this.fDialog.setLocationRelativeTo((Component)((Object)this.fParentReport));
            this.fPanelBuilder.setInitialFocus();
        }
    }

    private synchronized void destroy() {
        assert (SwingUtilities.isEventDispatchThread()) : "Wrong thread";
        if (this.fDialog != null) {
            this.fDialog.dispose();
            this.fDialog = null;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceSelectionDialog.this.fDialog.setNonBlockingVisible(false);
            if (SourceSelectionDialog.this.fParentReport != null) {
                SourceSelectionDialog.this.fParentReport.close();
            }
        }
    }

    private class CompareAction
    implements ActionListener {
        private CompareAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceSelectionDialog.this.fDialog.setNonBlockingVisible(false);
            SourceSelectionDialog.this.fEventSupport.fireComparisonEvent(new ComparisonEvent(this, CEventDataSelectionReady.getInstance()));
        }
    }
}

