/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.toolbox.shared.computils.exceptions.ErrorDialog;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class ExceptionHandler {
    private ExceptionHandler() {
    }

    public static void rethrow(RuntimeException runtimeException) {
        throw runtimeException;
    }

    public static void rethrow(InvocationTargetException invocationTargetException) {
        ExceptionHandler.rethrow(invocationTargetException.getTargetException());
    }

    public static void rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            ExceptionHandler.rethrow((RuntimeException)throwable);
        } else if (throwable instanceof InvocationTargetException) {
            ExceptionHandler.rethrow((InvocationTargetException)throwable);
        } else {
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
    }

    public static void handleException(Exception exception) {
        ExceptionHandler.showErrorDialogOnEdt(exception.getMessage());
    }

    private static void showErrorDialogOnEdt(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            ExceptionHandler.showErrorDialog(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExceptionHandler.showErrorDialog(string);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    private static void showErrorDialog(String string) {
        ErrorDialog errorDialog = new ErrorDialog(string);
        errorDialog.setWrapping(true);
        errorDialog.show();
    }
}

