/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mlwidgets.inspector.PropertyViewUtils;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class TMInspector {
    private static final int DIALOG_WIDTH = 384;
    private static final int DIALOG_HEIGHT = 416;
    private static final int BORDER_WIDTH = 5;
    private static final ResourceBundle fResource = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.guiutil.resources.RES_TMINSPECTOR");
    private static TMInspector sInstance;
    private static MJDialog sDialog;
    private PropertyView fPView = null;
    private MJPanel fPanel = null;
    private MJLabel fLabel = null;

    private TMInspector() {
        this.setPView(new PropertyView());
        this.layoutGui();
    }

    private void layoutGui() {
        TMInspector.setDialog(new MJDialog());
        TMInspector.getDialog().setTitle(fResource.getString("TMInspector.Title"));
        this.setPanel(new MJPanel());
        this.getPanel().setLayout((LayoutManager)new BorderLayout());
        this.setLabel(new MJLabel());
        this.getLabel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getPanel().add((Component)this.fLabel, (Object)"North");
        this.getPanel().add((Component)this.fPView, (Object)"Center");
        TMInspector.getDialog().getContentPane().add((Component)this.fPanel);
        TMInspector.getDialog().pack();
    }

    public static synchronized TMInspector getInstance() {
        if (sInstance == null) {
            TMInspector.setInstance(new TMInspector());
        }
        return sInstance;
    }

    private static void setInstance(TMInspector tMInspector) {
        sInstance = tMInspector;
    }

    public boolean isShowing() {
        return TMInspector.getDialog().isShowing();
    }

    public void inspectObject(Object object, String string) {
        final Object object2 = object;
        final String string2 = string;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TMInspector.this.inspect(object2);
                    TMInspector.this.getLabel().setText(string2);
                }
            });
        } else {
            this.inspect(object);
            this.getLabel().setText(string);
        }
    }

    public void inspectObject(Object object) {
        final Object object2 = object;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TMInspector.this.inspect(object2);
                }
            });
        } else {
            this.inspect(object);
        }
    }

    private synchronized void inspect(Object object) {
        Object[] objectArray = new Object[]{object};
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "";
        if (object instanceof Component) {
            string = " (" + ((Component)object).getName() + ")";
        }
        if (beanInfo != null) {
            this.getLabel().setText(beanInfo.getBeanDescriptor().getDisplayName() + string);
        } else {
            this.getLabel().setText(string);
        }
        this.getPView().getRegistry().setSelected(objectArray, true);
        TMInspector.getDialog().setVisible(true);
    }

    public synchronized void inspectObjectArray(Object[] objectArray) {
        final Object[] objectArray2 = objectArray;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TMInspector.this.getLabel().setText(PropertyViewUtils.getResource((String)"status.MultipleObjects"));
                    TMInspector.this.getPView().getRegistry().setSelected(objectArray2, true);
                    TMInspector.getDialog().setVisible(true);
                }
            });
        } else {
            this.getLabel().setText(PropertyViewUtils.getResource((String)"status.MultipleObjects"));
            this.getPView().getRegistry().setSelected(objectArray, true);
            TMInspector.getDialog().setVisible(true);
        }
    }

    public static void close() {
        if (TMInspector.getDialog() != null) {
            TMInspector.getDialog().dispose();
        }
    }

    private PropertyView getPView() {
        return this.fPView;
    }

    private void setPView(PropertyView propertyView) {
        this.fPView = propertyView;
    }

    private MJPanel getPanel() {
        return this.fPanel;
    }

    private void setPanel(MJPanel mJPanel) {
        this.fPanel = mJPanel;
    }

    private MJLabel getLabel() {
        return this.fLabel;
    }

    private void setLabel(MJLabel mJLabel) {
        this.fLabel = mJLabel;
    }

    private static MJDialog getDialog() {
        return sDialog;
    }

    private static void setDialog(MJDialog mJDialog) {
        sDialog = mJDialog;
    }

    static {
        sDialog = null;
        sInstance = null;
        sDialog = null;
    }
}

