/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.RegistrarProxy;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;

class EntryRep
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    public EntryClass eclass;
    public String codebase;
    public Object[] fields;

    public EntryRep(Entry entry) throws RemoteException {
        EntryClassBase entryClassBase = ClassMapper.toEntryClassBase(entry.getClass());
        this.eclass = entryClassBase.eclass;
        this.codebase = entryClassBase.codebase;
        try {
            ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(entry.getClass());
            this.fields = new Object[entryFieldArray.length];
            int n = entryFieldArray.length;
            while (--n >= 0) {
                ClassMapper.EntryField entryField = entryFieldArray[n];
                Object object = entryField.field.get(entry);
                if (entryField.marshal && object != null) {
                    object = new MarshalledWrapper(object);
                }
                this.fields[n] = object;
            }
        }
        catch (IOException iOException) {
            throw new MarshalException("error marshalling arguments", iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MarshalException("error marshalling arguments", illegalAccessException);
        }
    }

    public Entry get() {
        try {
            Class clazz = this.eclass.toClass(this.codebase);
            ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(clazz);
            Entry entry = (Entry)clazz.newInstance();
            int n = entryFieldArray.length;
            while (--n >= 0) {
                Object object = this.fields[n];
                ClassMapper.EntryField entryField = entryFieldArray[n];
                Field field = entryField.field;
                try {
                    if (entryField.marshal && object != null) {
                        object = ((MarshalledWrapper)object).get();
                    }
                    field.set(entry, object);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof IllegalArgumentException) {
                        String string = "unable to assign " + (object != null ? "value of type " + object.getClass().getName() : "null") + " to field " + field.getDeclaringClass().getName() + "." + field.getName() + " of type " + field.getType().getName();
                        throwable2 = new ClassCastException(string).initCause(throwable);
                    }
                    RegistrarProxy.handleException(throwable2);
                }
            }
            return entry;
        }
        catch (Throwable throwable) {
            RegistrarProxy.handleException(throwable);
            return null;
        }
    }

    public int hashCode() {
        return this.eclass.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EntryRep) {
            EntryRep entryRep = (EntryRep)object;
            if (!this.eclass.equals(entryRep.eclass) || this.fields.length != entryRep.fields.length) {
                return false;
            }
            int n = this.fields.length;
            while (--n >= 0) {
                if ((this.fields[n] != null || entryRep.fields[n] == null) && (this.fields[n] == null || this.fields[n].equals(entryRep.fields[n]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            EntryRep entryRep = (EntryRep)super.clone();
            entryRep.fields = (Object[])entryRep.fields.clone();
            return entryRep;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static EntryRep[] toEntryRep(Entry[] entryArray, boolean bl) throws RemoteException {
        EntryRep[] entryRepArray = null;
        if (entryArray != null) {
            entryRepArray = new EntryRep[entryArray.length];
            int n = entryArray.length;
            while (--n >= 0) {
                if (entryArray[n] == null) continue;
                entryRepArray[n] = new EntryRep(entryArray[n]);
                if (bl) continue;
                entryRepArray[n].codebase = null;
            }
        }
        return entryRepArray;
    }

    public static Entry[] toEntry(EntryRep[] entryRepArray) {
        Entry[] entryArray = null;
        if (entryRepArray != null) {
            entryArray = new Entry[entryRepArray.length];
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryArray[n] = entryRepArray[n].get();
            }
        }
        return entryArray;
    }
}

