/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.DocumentationFacetVisitor;
import com.mathworks.helpsearch.facets.Facetable;
import java.util.LinkedList;
import java.util.List;

public class ResultCategory
implements Comparable<ResultCategory>,
Facetable {
    private final String fLabel;
    private final String fRelativePath;
    private final String fNodeId;
    private final ResultCategory fParent;

    public ResultCategory(ResultCategory parent, String label, String relPath, String nodeId) {
        this.fParent = parent;
        this.fLabel = label;
        this.fRelativePath = relPath;
        this.fNodeId = nodeId;
    }

    @Override
    public DocFacet getFacetType() {
        return DocFacet.CATEGORY;
    }

    @Override
    public ResultCategory getParent() {
        return this.fParent;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getRelativePath() {
        return this.fRelativePath;
    }

    public String getNodeId() {
        return this.fNodeId;
    }

    public List<ResultCategory> getNodesRootFirst() {
        LinkedList<ResultCategory> nodes = new LinkedList<ResultCategory>();
        for (ResultCategory currentCat = this; currentCat != null; currentCat = currentCat.getParent()) {
            nodes.add(0, currentCat);
        }
        return nodes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResultCategory) {
            ResultCategory bcc = (ResultCategory)obj;
            return this.fNodeId.equals(bcc.getNodeId());
        }
        return false;
    }

    @Override
    public int compareTo(ResultCategory o) {
        int byLabel = this.fLabel.compareTo(o.fLabel);
        if (byLabel == 0) {
            return this.fNodeId.compareTo(o.getNodeId());
        }
        return byLabel;
    }

    public int hashCode() {
        return this.fNodeId.hashCode();
    }

    @Override
    public String getFacetId() {
        return this.getNodeId();
    }

    @Override
    public void accept(DocumentationFacetVisitor visitor) {
        visitor.visit(this);
    }
}

