/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.InformationTypeFilter;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.facets.CategoryFacetCollector;
import com.mathworks.helpsearch.facets.CategoryLabelRetriever;
import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.FacetSearchHelper;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.MatlabeticalProductComparator;
import com.mathworks.helpsearch.product.ProductFacetFilter;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.facet.FacetFilter;
import com.mathworks.search.facet.FacetResultCollector;
import com.mathworks.search.facet.SimpleFacetResultCollector;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FacetHelperBuilder {
    private FacetHelperBuilder() {
    }

    public static List<FacetSearchHelper<? extends Facetable>> buildFacetHelpers(DocumentationSet docSet, DocumentationQuery query, SearchEngine engine) {
        LinkedList<FacetSearchHelper<? extends Facetable>> facetHelpers = new LinkedList<FacetSearchHelper<? extends Facetable>>();
        Map<DocFacet, String> queryFacets = query.getFacets();
        for (DocFacet facet : DocFacet.values()) {
            String rawSelectionValue;
            FacetSearchHelper<? extends Facetable> facetHelper;
            if (!facet.useFacetWithFormat(docSet.getFormat()) || (facetHelper = FacetHelperBuilder.buildFacetInfo(docSet, facet, engine, rawSelectionValue = queryFacets.get((Object)facet))) == null) continue;
            facetHelpers.add(facetHelper);
        }
        return facetHelpers;
    }

    private static FacetSearchHelper<? extends Facetable> buildFacetInfo(DocumentationSet docSet, DocFacet facet, SearchEngine engine, String selectionValue) {
        switch (facet) {
            case CATEGORY: {
                return FacetHelperBuilder.createCategoryFacet(selectionValue, engine);
            }
            case TYPE: {
                InformationType selectedType = FacetHelperBuilder.getSelectedType(docSet, selectionValue);
                return FacetHelperBuilder.createInfoTypeFacet(docSet, selectedType);
            }
            case PRODUCT: {
                DocProduct product = FacetHelperBuilder.getSelectedProduct(docSet, selectionValue);
                return FacetHelperBuilder.createProductFacet(docSet, product);
            }
        }
        return null;
    }

    private static FacetSearchHelper<ResultCategory> createCategoryFacet(String category, SearchEngine engine) {
        return FacetHelperBuilder.getCategoryFacetHelper(category, new CategoryLabelRetriever(engine));
    }

    private static InformationType getSelectedType(DocumentationSet docSet, String rawSelectionValue) {
        if (rawSelectionValue == null) {
            return null;
        }
        return docSet.getFormat().getInfoTypeByIndexString(rawSelectionValue);
    }

    public static FacetSearchHelper<InformationType> createInfoTypeFacet(DocumentationSet docSet, InformationType selectedType) {
        if (selectedType == null) {
            return FacetHelperBuilder.getTypeHelper(docSet.getFormat());
        }
        return FacetHelperBuilder.createSelectedFacetHandler(selectedType);
    }

    private static DocProduct getSelectedProduct(DocumentationSet docSet, String rawSelectionValue) {
        if (rawSelectionValue == null) {
            return null;
        }
        return docSet.getProductByShortName(rawSelectionValue);
    }

    private static FacetSearchHelper<DocProduct> createProductFacet(DocumentationSet docSet, DocProduct selectedProduct) {
        if (selectedProduct == null) {
            return FacetHelperBuilder.getProductHandler(docSet);
        }
        return FacetHelperBuilder.createSelectedFacetHandler(selectedProduct);
    }

    private static FacetSearchHelper<ResultCategory> getCategoryFacetHelper(String selectedCategory, CategoryLabelRetriever labelRetriever) {
        FacetSearchHelper<ResultCategory> helper = new FacetSearchHelper<ResultCategory>(DocFacet.CATEGORY);
        helper.setCollector(new CategoryFacetCollector(helper, selectedCategory, labelRetriever));
        if (selectedCategory != null) {
            helper.setExpression(DocFacet.CATEGORY.createSearchExpression(selectedCategory));
        }
        return helper;
    }

    private static FacetSearchHelper<InformationType> getTypeHelper(ContentFormat format) {
        FacetSearchHelper<InformationType> helper = new FacetSearchHelper<InformationType>(DocFacet.TYPE);
        InformationTypeFilter filter = new InformationTypeFilter(format);
        SimpleFacetResultCollector collector = SimpleFacetResultCollector.createCollector((FacetFilter)filter);
        helper.setCollector((FacetResultCollector<InformationType>)collector);
        return helper;
    }

    private static FacetSearchHelper<DocProduct> getProductHandler(DocumentationSet docSet) {
        FacetSearchHelper<DocProduct> helper = new FacetSearchHelper<DocProduct>(DocFacet.PRODUCT);
        ProductFacetFilter filter = new ProductFacetFilter(docSet);
        SimpleFacetResultCollector collector = SimpleFacetResultCollector.createFacetComparatorCollector((FacetFilter)filter, (Comparator)new MatlabeticalProductComparator());
        helper.setCollector((FacetResultCollector<DocProduct>)collector);
        return helper;
    }

    private static <T extends Facetable> FacetSearchHelper<T> createSelectedFacetHandler(T selectedFacet) {
        DocFacet docFacet = selectedFacet.getFacetType();
        FacetSearchHelper<T> helper = new FacetSearchHelper<T>(docFacet);
        helper.setExpression(docFacet.createSearchExpression(selectedFacet.getFacetId()));
        helper.setSelectedFacet(selectedFacet);
        return helper;
    }
}

