/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.DomDocumentBuilder;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;

public class DefaultDomDocumentBuilder
implements DomDocumentBuilder {
    private final LocalizedFileLocator fLocalizer;
    private final HtmlToDomAdapter fDomAdapter;

    public DefaultDomDocumentBuilder(LocalizedFileLocator localizer, HtmlToDomAdapter domAdapter) {
        this.fLocalizer = localizer;
        this.fDomAdapter = domAdapter;
    }

    @Override
    public Document toDomDocument(DocumentationDocument doc, File prodDir) throws IOException {
        File file = this.getLocalizedFile(new File(prodDir, doc.getRelativePath()));
        if (this.doesFileExist(file)) {
            return this.toDomDocument(file);
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    private File getLocalizedFile(File file) {
        if (this.fLocalizer != null) {
            return this.fLocalizer.findLocalizedFile(file);
        }
        return file;
    }

    protected boolean doesFileExist(File file) {
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document toDomDocument(File fileToParse) throws IOException {
        try (InputStream is = this.getInputStream(fileToParse);){
            Document document = this.fDomAdapter.parseDocument(is);
            return document;
        }
    }

    protected InputStream getInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }
}

