/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.CompositeDocumentBooster;
import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocumentationBooster
extends CompositeDocumentBooster {
    private static final Map<String, Float> REF_PAGE_BOOSTS = new HashMap<String, Float>();
    private static final Map<String, Float> INFO_TYPE_BOOSTS;

    public DocumentationBooster() {
        super(new RefPageBooster(), new InfoTypeBooster());
    }

    static {
        REF_PAGE_BOOSTS.put("matlab", Float.valueOf(2.0f));
        REF_PAGE_BOOSTS.put("simulink", Float.valueOf(1.5f));
        INFO_TYPE_BOOSTS = new HashMap<String, Float>();
        INFO_TYPE_BOOSTS.put("list", Float.valueOf(0.2f));
    }

    private static class InfoTypeBooster
    implements DocumentBooster {
        private InfoTypeBooster() {
        }

        @Override
        public float getDocumentBoost(DocumentationDocument doc) {
            float infoTypeBoost = 0.0f;
            for (String infoTypeString : doc.getInfoTypeStrings()) {
                if (!INFO_TYPE_BOOSTS.containsKey(infoTypeString)) continue;
                float boostForType = ((Float)INFO_TYPE_BOOSTS.get(infoTypeString)).floatValue();
                infoTypeBoost = Math.max(boostForType, infoTypeBoost);
            }
            return infoTypeBoost == 0.0f ? 1.0f : infoTypeBoost;
        }

        @Override
        public Map<DocumentationSearchField, Float> getFieldBoosts(DocumentationDocument doc) {
            return Collections.emptyMap();
        }
    }

    private static class RefPageBooster
    implements DocumentBooster {
        private RefPageBooster() {
        }

        @Override
        public float getDocumentBoost(DocumentationDocument doc) {
            return doc.isReferencePage() ? RefPageBooster.getBoostForProduct(doc.getDocSetItem()) : 1.0f;
        }

        private static float getBoostForProduct(DocSetItem docSetItem) {
            Float boost = (Float)REF_PAGE_BOOSTS.get(docSetItem.getShortName());
            return boost == null ? 1.0f : boost.floatValue();
        }

        @Override
        public Map<DocumentationSearchField, Float> getFieldBoosts(DocumentationDocument doc) {
            List<ReferenceEntity> refEntities = doc.getReferenceEntities();
            for (ReferenceEntity entity : refEntities) {
                if (entity.getType() != RefEntityType.FUNCTION || !doc.getTitle().startsWith(entity.getName())) continue;
                EnumMap<DocumentationSearchField, Float> titleBoostMap = new EnumMap<DocumentationSearchField, Float>(DocumentationSearchField.class);
                titleBoostMap.put(DocumentationSearchField.TITLE_SEARCH, Float.valueOf(1.25f));
                return titleBoostMap;
            }
            return Collections.emptyMap();
        }
    }
}

