/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.classic;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;

public class TitleFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private boolean fTitleTagFound = false;
    private String fTitle = "";

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"h1", "h2"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        if (this.fTitleTagFound) {
            return false;
        }
        this.fTitleTagFound = TitleFragmentHandler.isTitleTag(xmlTag);
        return this.fTitleTagFound;
    }

    private static boolean isTitleTag(XmlTagInfo xmlTag) {
        if (xmlTag.getTagName().equalsIgnoreCase("h1")) {
            String h1Class = xmlTag.getAttribute("class");
            return h1Class != null && h1Class.equals("reftitle");
        }
        if (xmlTag.getTagName().equalsIgnoreCase("h2")) {
            String h2Class = xmlTag.getAttribute("class");
            return h2Class != null && h2Class.equals("title");
        }
        return false;
    }

    @Override
    public boolean continueHandling() {
        return false;
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void startElement(XmlTagInfo location) {
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
        if (TitleFragmentHandler.isTitleTag(location)) {
            this.fTitle = this.fTitle + chars;
        }
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        if (doc.getTitle() == null && this.fTitle != null) {
            doc.setTitle(this.fTitle.trim());
        }
    }
}

